/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.plugins.document.BackgroundReadStats;
import org.apache.jackrabbit.oak.plugins.document.BackgroundWriteStats;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreStatsCollector;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;

public class DocumentNodeStoreStats
implements DocumentNodeStoreStatsCollector {
    private static final String BGR_READ_HEAD = "DOCUMENT_NS_BGR_READ_HEAD";
    private static final String BGR_CACHE_INVALIDATE = "DOCUMENT_NS_BGR_CACHE_INVALIDATE";
    private static final String BGR_DIFF_CACHE = "DOCUMENT_NS_BGR_DIFF_CACHE";
    private static final String BGR_LOCK = "DOCUMENT_NS_BGR_LOCK";
    private static final String BGR_DISPATCH = "DOCUMENT_NS_BGR_DISPATCH";
    private static final String BGR_TOTAL_TIME = "DOCUMENT_NS_BGR_TOTAL_TIME";
    static final String BGR_NUM_CHANGES_RATE = "DOCUMENT_NS_BGR_NUM_CHANGES_RATE";
    private static final String BGR_NUM_CHANGES_HISTO = "DOCUMENT_NS_BGR_NUM_CHANGES_HISTO";
    static final String BGR_LAG = "DOCUMENT_NS_BGR_LAG";
    private static final String BGW_CLEAN = "DOCUMENT_NS_BGW_CLEAN";
    private static final String BGW_SPLIT = "DOCUMENT_NS_BGW_SPLIT";
    private static final String BGW_WRITE = "DOCUMENT_NS_BGW_LOCK";
    private static final String BGW_SWEEP = "DOCUMENT_NS_BGW_SWEEP";
    static final String BGW_NUM = "DOCUMENT_NS_BGW_NUM";
    static final String BGW_NUM_WRITES_RATE = "DOCUMENT_NS_BGW_NUM_WRITE_RATE";
    private static final String BGW_TOTAL = "DOCUMENT_NS_BGW_TOTAL_TIME";
    static final String LEASE_UPDATE = "DOCUMENT_NS_LEASE_UPDATE";
    private static final String MERGE_SUCCESS_NUM_RETRY = "DOCUMENT_NS_MERGE_SUCCESS_RETRY";
    static final String MERGE_SUCCESS_COUNT = "DOCUMENT_NS_MERGE_SUCCESS_COUNT";
    private static final String MERGE_SUCCESS_TIME = "DOCUMENT_NS_MERGE_SUCCESS_TIME";
    private static final String MERGE_SUCCESS_NORMALIZED_TIME = "DOCUMENT_NS_MERGE_SUCCESS_NORMALIZED_TIME";
    private static final String MERGE_SUCCESS_SUSPENDED = "DOCUMENT_NS_MERGE_SUCCESS_SUSPENDED";
    private static final String MERGE_SUCCESS_EXCLUSIVE = "DOCUMENT_NS_MERGE_SUCCESS_EXCLUSIVE";
    static final String MERGE_FAILED_EXCLUSIVE = "DOCUMENT_NS_MERGE_FAILED_EXCLUSIVE";
    private static final String HEAD_OF_QUEUE_WAIT_TIME = "DOCUMENT_NS_HEAD_OF_QUEUE_WAIT_TIME";
    private static final String MERGE_SUSPEND_TIME = "DOCUMENT_NS_MERGE_SUSPEND_TIME";
    private static final String MERGE_LOCK_TIME = "DOCUMENT_NS_MERGE_LOCK_TIME";
    private static final String MERGE_COMMIT_HOOK_TIME = "DOCUMENT_NS_MERGE_COMMIT_HOOK_TIME";
    private static final String MERGE_CHANGES_APPLIED_TIME = "DOCUMENT_NS_MERGE_CHANGES_APPLIED_TIME";
    private static final String MERGE_CHANGES_RATE = "DOCUMENT_NS_MERGE_CHANGES_RATE";
    static final String BRANCH_COMMIT_COUNT = "DOCUMENT_NS_BRANCH_COMMIT_COUNT";
    static final String MERGE_BRANCH_COMMIT_COUNT = "DOCUMENT_NS_MERGE_BRANCH_COMMIT_COUNT";
    private final TimerStats readHead;
    private final TimerStats readCacheInvalidate;
    private final TimerStats readDiffCache;
    private final TimerStats readLock;
    private final TimerStats readDispatch;
    private final TimerStats readTotalTime;
    private final MeterStats numChangesRate;
    private final HistogramStats numChangesHisto;
    private final MeterStats changesLag;
    private final TimerStats writeClean;
    private final TimerStats writeSplit;
    private final TimerStats writeSweep;
    private final HistogramStats writeNum;
    private final TimerStats writeWrite;
    private final TimerStats writeTotal;
    private final MeterStats numWritesRate;
    private final TimerStats leaseUpdate;
    private final HistogramStats mergeSuccessRetries;
    private final MeterStats mergeSuccessRate;
    private final TimerStats mergeSuccessTime;
    private final TimerStats mergeSuccessNormalizedTime;
    private final MeterStats mergeSuccessExclusive;
    private final MeterStats mergeSuccessSuspended;
    private final MeterStats mergeFailedExclusive;
    private final TimerStats headOfQueueWaitTime;
    private final TimerStats mergeSuspendTime;
    private final TimerStats mergeLockTime;
    private final TimerStats mergeCommitHookTime;
    private final TimerStats mergeChangesApplied;
    private final MeterStats mergeChangesRate;
    private final MeterStats branchCommitRate;
    private final MeterStats mergeBranchCommitRate;

    public DocumentNodeStoreStats(StatisticsProvider sp) {
        this.readHead = sp.getTimer(BGR_READ_HEAD, StatsOptions.METRICS_ONLY);
        this.readCacheInvalidate = sp.getTimer(BGR_CACHE_INVALIDATE, StatsOptions.METRICS_ONLY);
        this.readDiffCache = sp.getTimer(BGR_DIFF_CACHE, StatsOptions.METRICS_ONLY);
        this.readLock = sp.getTimer(BGR_LOCK, StatsOptions.METRICS_ONLY);
        this.readDispatch = sp.getTimer(BGR_DISPATCH, StatsOptions.METRICS_ONLY);
        this.readTotalTime = sp.getTimer(BGR_TOTAL_TIME, StatsOptions.METRICS_ONLY);
        this.numChangesRate = sp.getMeter(BGR_NUM_CHANGES_RATE, StatsOptions.DEFAULT);
        this.numChangesHisto = sp.getHistogram(BGR_NUM_CHANGES_HISTO, StatsOptions.METRICS_ONLY);
        this.changesLag = sp.getMeter(BGR_LAG, StatsOptions.METRICS_ONLY);
        this.writeClean = sp.getTimer(BGW_CLEAN, StatsOptions.METRICS_ONLY);
        this.writeSplit = sp.getTimer(BGW_SPLIT, StatsOptions.METRICS_ONLY);
        this.writeSweep = sp.getTimer(BGW_SWEEP, StatsOptions.METRICS_ONLY);
        this.writeWrite = sp.getTimer(BGW_WRITE, StatsOptions.METRICS_ONLY);
        this.writeTotal = sp.getTimer(BGW_TOTAL, StatsOptions.METRICS_ONLY);
        this.writeNum = sp.getHistogram(BGW_NUM, StatsOptions.METRICS_ONLY);
        this.numWritesRate = sp.getMeter(BGW_NUM_WRITES_RATE, StatsOptions.DEFAULT);
        this.leaseUpdate = sp.getTimer(LEASE_UPDATE, StatsOptions.METRICS_ONLY);
        this.mergeSuccessRetries = sp.getHistogram(MERGE_SUCCESS_NUM_RETRY, StatsOptions.METRICS_ONLY);
        this.mergeSuccessRate = sp.getMeter(MERGE_SUCCESS_COUNT, StatsOptions.DEFAULT);
        this.mergeSuccessTime = sp.getTimer(MERGE_SUCCESS_TIME, StatsOptions.METRICS_ONLY);
        this.mergeSuccessNormalizedTime = sp.getTimer(MERGE_SUCCESS_NORMALIZED_TIME, StatsOptions.METRICS_ONLY);
        this.mergeSuccessExclusive = sp.getMeter(MERGE_SUCCESS_EXCLUSIVE, StatsOptions.METRICS_ONLY);
        this.mergeSuccessSuspended = sp.getMeter(MERGE_SUCCESS_SUSPENDED, StatsOptions.METRICS_ONLY);
        this.mergeFailedExclusive = sp.getMeter(MERGE_FAILED_EXCLUSIVE, StatsOptions.DEFAULT);
        this.headOfQueueWaitTime = sp.getTimer(HEAD_OF_QUEUE_WAIT_TIME, StatsOptions.METRICS_ONLY);
        this.mergeSuspendTime = sp.getTimer(MERGE_SUSPEND_TIME, StatsOptions.METRICS_ONLY);
        this.mergeLockTime = sp.getTimer(MERGE_LOCK_TIME, StatsOptions.METRICS_ONLY);
        this.mergeCommitHookTime = sp.getTimer(MERGE_COMMIT_HOOK_TIME, StatsOptions.METRICS_ONLY);
        this.mergeChangesApplied = sp.getTimer(MERGE_CHANGES_APPLIED_TIME, StatsOptions.METRICS_ONLY);
        this.mergeChangesRate = sp.getMeter(MERGE_CHANGES_RATE, StatsOptions.METRICS_ONLY);
        this.branchCommitRate = sp.getMeter(BRANCH_COMMIT_COUNT, StatsOptions.DEFAULT);
        this.mergeBranchCommitRate = sp.getMeter(MERGE_BRANCH_COMMIT_COUNT, StatsOptions.DEFAULT);
    }

    @Override
    public void doneBackgroundRead(BackgroundReadStats stats) {
        this.readHead.update(stats.readHead, TimeUnit.MILLISECONDS);
        this.readCacheInvalidate.update(stats.cacheInvalidationTime, TimeUnit.MILLISECONDS);
        this.readDiffCache.update(stats.populateDiffCache, TimeUnit.MILLISECONDS);
        this.readLock.update(stats.lock, TimeUnit.MILLISECONDS);
        this.readDispatch.update(stats.dispatchChanges, TimeUnit.MILLISECONDS);
        this.readTotalTime.update(stats.totalReadTime, TimeUnit.MILLISECONDS);
        this.numChangesRate.mark(stats.numExternalChanges);
        this.numChangesHisto.update(stats.numExternalChanges);
        this.changesLag.mark(stats.externalChangesLag);
    }

    @Override
    public void doneBackgroundUpdate(BackgroundWriteStats stats) {
        this.writeClean.update(stats.clean, TimeUnit.MILLISECONDS);
        this.writeSplit.update(stats.split, TimeUnit.MILLISECONDS);
        this.writeSweep.update(stats.sweep, TimeUnit.MILLISECONDS);
        this.writeWrite.update(stats.write, TimeUnit.MILLISECONDS);
        this.writeTotal.update(stats.totalWriteTime, TimeUnit.MILLISECONDS);
        this.writeNum.update(stats.num);
        this.numWritesRate.mark(stats.num);
    }

    @Override
    public void doneLeaseUpdate(long timeMicros) {
        this.leaseUpdate.update(timeMicros, TimeUnit.MICROSECONDS);
    }

    @Override
    public void doneBranchCommit() {
        this.branchCommitRate.mark();
    }

    @Override
    public void doneMergeBranch(int numCommits, int numChanges) {
        this.mergeBranchCommitRate.mark((long)numCommits);
        this.mergeChangesRate.mark((long)numChanges);
    }

    @Override
    public void doneMerge(int numChanges, int numRetries, long timeMillis, long suspendMillis, boolean exclusive) {
        this.mergeSuccessRate.mark();
        this.mergeSuccessRetries.update((long)numRetries);
        this.mergeSuccessTime.update(timeMillis, TimeUnit.MILLISECONDS);
        if (numChanges > 0) {
            this.mergeSuccessNormalizedTime.update(timeMillis / (long)numChanges, TimeUnit.MILLISECONDS);
            this.mergeChangesRate.mark((long)numChanges);
        }
        if (exclusive) {
            this.mergeSuccessExclusive.mark();
        }
        this.mergeSuspendTime.update(suspendMillis, TimeUnit.MILLISECONDS);
        if (suspendMillis > 0L) {
            this.mergeSuccessSuspended.mark();
        }
    }

    @Override
    public void failedMerge(int numRetries, long timeMillis, long suspendMillis, boolean exclusive) {
        if (exclusive) {
            this.mergeFailedExclusive.mark();
        }
    }

    @Override
    public void doneWaitUntilHead(long waitMicros) {
        this.headOfQueueWaitTime.update(waitMicros, TimeUnit.MICROSECONDS);
    }

    @Override
    public void doneMergeLockAcquired(long timeMicros) {
        this.mergeLockTime.update(timeMicros, TimeUnit.MICROSECONDS);
    }

    @Override
    public void doneCommitHookProcessed(long timeMicros) {
        this.mergeCommitHookTime.update(timeMicros, TimeUnit.MICROSECONDS);
    }

    @Override
    public void doneChangesApplied(long timeMicros) {
        this.mergeChangesApplied.update(timeMicros, TimeUnit.MICROSECONDS);
    }
}

