/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Suppliers;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.ReadConcernLevel;
import com.mongodb.client.MongoDatabase;
import com.mongodb.event.ServerMonitorListener;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.MissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.mongo.CompositeServerMonitorListener;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoMissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoStatus;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoVersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MongoDocumentNodeStoreBuilderBase<T extends MongoDocumentNodeStoreBuilderBase<T>>
extends DocumentNodeStoreBuilder<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDocumentNodeStoreBuilder.class);
    private boolean socketKeepAlive = true;
    private MongoStatus mongoStatus;
    private long maxReplicationLagMillis = TimeUnit.HOURS.toMillis(6L);
    private boolean clientSessionDisabled = false;

    public T setMongoDB(@NotNull String uri, @NotNull String name, int blobCacheSizeMB) {
        CompositeServerMonitorListener serverMonitorListener = new CompositeServerMonitorListener();
        MongoClientOptions.Builder options = MongoConnection.getDefaultBuilder();
        options.addServerMonitorListener((ServerMonitorListener)serverMonitorListener);
        options.socketKeepAlive(this.socketKeepAlive);
        MongoClient client = new MongoClient(new MongoClientURI(uri, options));
        MongoStatus status = new MongoStatus(client, name);
        serverMonitorListener.addListener(status);
        MongoDatabase db = client.getDatabase(name);
        if (!MongoConnection.hasWriteConcern(uri)) {
            db = db.withWriteConcern(MongoConnection.getDefaultWriteConcern(client));
        }
        if (status.isMajorityReadConcernSupported() && status.isMajorityReadConcernEnabled() && !MongoConnection.hasReadConcern(uri)) {
            db = db.withReadConcern(MongoConnection.getDefaultReadConcern(client, db));
        }
        this.setMongoDB(client, db, status, blobCacheSizeMB);
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoDB(@NotNull MongoClient client, @NotNull String dbName, int blobCacheSizeMB) {
        return this.setMongoDB(client, client.getDatabase(dbName), new MongoStatus(client, dbName), blobCacheSizeMB);
    }

    public T setMongoDB(@NotNull MongoClient client, @NotNull String dbName) {
        return this.setMongoDB(client, dbName, 16);
    }

    public T setSocketKeepAlive(boolean enable) {
        this.socketKeepAlive = enable;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public T setClientSessionDisabled(boolean b) {
        this.clientSessionDisabled = b;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    boolean isClientSessionDisabled() {
        return this.clientSessionDisabled;
    }

    public T setMaxReplicationLag(long duration, TimeUnit unit) {
        this.maxReplicationLagMillis = unit.toMillis(duration);
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    @Override
    public VersionGCSupport createVersionGCSupport() {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof MongoDocumentStore) {
            return new MongoVersionGCSupport((MongoDocumentStore)store);
        }
        return super.createVersionGCSupport();
    }

    @Override
    public Iterable<ReferencedBlob> createReferencedBlobs(DocumentNodeStore ns) {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof MongoDocumentStore) {
            return () -> new MongoBlobReferenceIterator(ns, (MongoDocumentStore)store);
        }
        return super.createReferencedBlobs(ns);
    }

    @Override
    public MissingLastRevSeeker createMissingLastRevSeeker() {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof MongoDocumentStore) {
            return new MongoMissingLastRevSeeker((MongoDocumentStore)store, this.getClock());
        }
        return super.createMissingLastRevSeeker();
    }

    MongoStatus getMongoStatus() {
        return this.mongoStatus;
    }

    long getMaxReplicationLagMillis() {
        return this.maxReplicationLagMillis;
    }

    private T setMongoDB(@NotNull MongoClient client, @NotNull MongoDatabase db, MongoStatus status, int blobCacheSizeMB) {
        if (!MongoConnection.isSufficientWriteConcern(client, db.getWriteConcern())) {
            LOG.warn("Insufficient write concern: " + db.getWriteConcern() + " At least " + MongoConnection.getDefaultWriteConcern(client) + " is recommended.");
        }
        if (status.isMajorityReadConcernSupported() && !status.isMajorityReadConcernEnabled()) {
            LOG.warn("The read concern should be enabled on mongod using --enableMajorityReadConcern");
        } else if (status.isMajorityReadConcernSupported() && !MongoConnection.isSufficientReadConcern(client, db.getReadConcern())) {
            ReadConcernLevel currentLevel = MongoConnection.readConcernLevel(db.getReadConcern());
            ReadConcernLevel recommendedLevel = MongoConnection.readConcernLevel(MongoConnection.getDefaultReadConcern(client, db));
            if (currentLevel == null) {
                LOG.warn("Read concern hasn't been set. At least " + recommendedLevel + " is recommended.");
            } else {
                LOG.warn("Insufficient read concern: " + currentLevel + ". At least " + recommendedLevel + " is recommended.");
            }
        }
        this.mongoStatus = status;
        this.documentStoreSupplier = Suppliers.memoize(() -> new MongoDocumentStore(client, db, this));
        if (this.blobStore == null) {
            MongoBlobStore s = new MongoBlobStore(db, (long)(blobCacheSizeMB * 1024) * 1024L);
            this.setGCBlobStore((GarbageCollectableBlobStore)s);
        }
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }
}

