/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.LocalDiffCache;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.PathRev;
import org.apache.jackrabbit.oak.plugins.document.util.RevisionsKey;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;

public enum CacheType {
    NODE{

        @Override
        public <K> String keyToString(K key) {
            return ((PathRev)key).asString();
        }

        @Override
        public <K> K keyFromString(String key) {
            return (K)PathRev.fromString(key);
        }

        @Override
        public <K> int compareKeys(K a, K b) {
            return ((PathRev)a).compareTo((PathRev)b);
        }

        @Override
        public <V> String valueToString(V value) {
            return ((DocumentNodeState)((Object)value)).asString();
        }

        @Override
        public <V> V valueFromString(DocumentNodeStore store, DocumentStore docStore, String value) {
            return (V)((Object)DocumentNodeState.fromString(store, value));
        }

        @Override
        public <K> boolean shouldCache(DocumentNodeStore store, K key) {
            String path = ((PathRev)key).getPath();
            if (!store.getNodeCachePredicate().apply((Object)path)) {
                return false;
            }
            return !store.getNodeStateCache().isCached(path);
        }
    }
    ,
    CHILDREN{

        @Override
        public <K> String keyToString(K key) {
            return ((PathRev)key).asString();
        }

        @Override
        public <K> K keyFromString(String key) {
            return (K)PathRev.fromString(key);
        }

        @Override
        public <K> int compareKeys(K a, K b) {
            return ((PathRev)a).compareTo((PathRev)b);
        }

        @Override
        public <V> String valueToString(V value) {
            return ((DocumentNodeState.Children)value).asString();
        }

        @Override
        public <V> V valueFromString(DocumentNodeStore store, DocumentStore docStore, String value) {
            return (V)DocumentNodeState.Children.fromString(value);
        }

        @Override
        public <K> boolean shouldCache(DocumentNodeStore store, K key) {
            String path = ((PathRev)key).getPath();
            if (!store.getNodeCachePredicate().apply((Object)path)) {
                return false;
            }
            return !store.getNodeStateCache().isCached(path);
        }
    }
    ,
    DIFF{

        @Override
        public <K> String keyToString(K key) {
            return ((PathRev)key).asString();
        }

        @Override
        public <K> K keyFromString(String key) {
            return (K)PathRev.fromString(key);
        }

        @Override
        public <K> int compareKeys(K a, K b) {
            return ((PathRev)a).compareTo((PathRev)b);
        }

        @Override
        public <V> String valueToString(V value) {
            return ((StringValue)value).asString();
        }

        @Override
        public <V> V valueFromString(DocumentNodeStore store, DocumentStore docStore, String value) {
            return (V)StringValue.fromString(value);
        }

        @Override
        public <K> boolean shouldCache(DocumentNodeStore store, K key) {
            return true;
        }
    }
    ,
    DOCUMENT{

        @Override
        public <K> String keyToString(K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <K> K keyFromString(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <K> int compareKeys(K a, K b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V> String valueToString(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V> V valueFromString(DocumentNodeStore store, DocumentStore docStore, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <K> boolean shouldCache(DocumentNodeStore store, K key) {
            return false;
        }
    }
    ,
    PREV_DOCUMENT{

        @Override
        public <K> String keyToString(K key) {
            return ((StringValue)key).asString();
        }

        @Override
        public <K> K keyFromString(String key) {
            return (K)StringValue.fromString(key);
        }

        @Override
        public <K> int compareKeys(K a, K b) {
            return ((StringValue)a).asString().compareTo(((StringValue)b).asString());
        }

        @Override
        public <V> String valueToString(V value) {
            return ((NodeDocument)value).asString();
        }

        @Override
        public <V> V valueFromString(DocumentNodeStore store, DocumentStore docStore, String value) {
            return (V)NodeDocument.fromString(docStore, value);
        }

        @Override
        public <K> boolean shouldCache(DocumentNodeStore store, K key) {
            return true;
        }
    }
    ,
    LOCAL_DIFF{

        @Override
        public <K> String keyToString(K key) {
            return ((RevisionsKey)key).asString();
        }

        @Override
        public <K> K keyFromString(String key) {
            return (K)RevisionsKey.fromString(key);
        }

        @Override
        public <K> int compareKeys(K a, K b) {
            return ((RevisionsKey)a).compareTo((RevisionsKey)b);
        }

        @Override
        public <V> String valueToString(V value) {
            return ((LocalDiffCache.Diff)value).asString();
        }

        @Override
        public <V> V valueFromString(DocumentNodeStore store, DocumentStore docStore, String value) {
            return (V)LocalDiffCache.Diff.fromString(value);
        }

        @Override
        public <K> boolean shouldCache(DocumentNodeStore store, K key) {
            return true;
        }
    };

    public static final CacheType[] VALUES;

    public abstract <K> String keyToString(K var1);

    public abstract <K> K keyFromString(String var1);

    public abstract <K> int compareKeys(K var1, K var2);

    public abstract <V> String valueToString(V var1);

    public abstract <V> V valueFromString(DocumentNodeStore var1, DocumentStore var2, String var3);

    public abstract <K> boolean shouldCache(DocumentNodeStore var1, K var2);

    static {
        VALUES = CacheType.values();
    }
}

