/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBJDBCTools;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RDBBlobStoreDB {
    H2("H2"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 1, 4, this.description);
        }
    }
    ,
    DERBY("Apache Derby"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 10, 11, this.description);
        }
    }
    ,
    DB2("DB2"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 10, 1, this.description);
        }

        @Override
        public String getDataTableCreationStatement(String tableName) {
            return "create table " + tableName + " (ID varchar(" + RDBBlobStore.IDSIZE + ") not null primary key, DATA blob(" + 0x200000 + "))";
        }
    }
    ,
    MSSQL("Microsoft SQL Server"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 11, 0, this.description);
        }

        @Override
        public String getDataTableCreationStatement(String tableName) {
            return "create table " + tableName + " (ID varchar(" + RDBBlobStore.IDSIZE + ") not null, DATA varbinary(max)constraint " + tableName + "_PK primary key clustered (ID ASC))";
        }
    }
    ,
    MYSQL("MySQL"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 5, 5, this.description);
        }

        @Override
        public String getDataTableCreationStatement(String tableName) {
            return "create table " + tableName + " (ID varchar(" + RDBBlobStore.IDSIZE + ") not null primary key, DATA mediumblob)";
        }
    }
    ,
    ORACLE("Oracle"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 12, 1, 12, 1, this.description);
        }

        @Override
        public String getMetaTableCreationStatement(String tableName) {
            return "create table " + tableName + " (ID varchar(" + RDBBlobStore.IDSIZE + ") not null primary key, LVL number, LASTMOD number)";
        }
    }
    ,
    POSTGRES("PostgreSQL"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 9, 5, 9, 4, this.description);
        }

        @Override
        public String getDataTableCreationStatement(String tableName) {
            return "create table " + tableName + " (ID varchar(" + RDBBlobStore.IDSIZE + ") not null primary key, DATA bytea)";
        }
    }
    ,
    DEFAULT("default"){};

    private static final Logger LOG;
    private static final int MINBLOB = 0x200000;
    protected String description;

    public String checkVersion(DatabaseMetaData md) throws SQLException {
        return "Unknown database type: " + md.getDatabaseProductName();
    }

    public String getDataTableCreationStatement(String tableName) {
        return "create table " + tableName + " (ID varchar(" + RDBBlobStore.IDSIZE + ") not null primary key, DATA blob)";
    }

    public String getMetaTableCreationStatement(String tableName) {
        return "create table " + tableName + " (ID varchar(" + RDBBlobStore.IDSIZE + ") not null primary key, LVL int, LASTMOD bigint)";
    }

    private RDBBlobStoreDB(String description) {
        this.description = description;
    }

    public String toString() {
        return this.description;
    }

    @NotNull
    public static RDBBlobStoreDB getValue(String desc) {
        for (RDBBlobStoreDB db : RDBBlobStoreDB.values()) {
            if (db.description.equals(desc)) {
                return db;
            }
            if (db != DB2 || !desc.startsWith("DB2/")) continue;
            return db;
        }
        LOG.error("DB type " + desc + " unknown, trying default settings");
        RDBBlobStoreDB.DEFAULT.description = desc + " - using default settings";
        return DEFAULT;
    }

    static {
        LOG = LoggerFactory.getLogger(RDBBlobStoreDB.class);
    }
}

