/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBJDBCTools;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBJSONSupport;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBRow;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBDocumentSerializer {
    private final DocumentStore store;
    private static final String MODIFIED = "_modified";
    private static final String MODCOUNT = "_modCount";
    private static final String CMODCOUNT = "_collisionsModCount";
    private static final String SDTYPE = "_sdType";
    private static final String SDMAXREVTIME = "_sdMaxRevTime";
    private static final String ID = "_id";
    private static final String HASBINARY = "_bin";
    private static final String DELETEDONCE = "_deletedOnce";
    private final Comparator<Revision> comparator = StableRevisionComparator.REVERSE;
    private static final Logger LOG = LoggerFactory.getLogger(RDBDocumentSerializer.class);
    private static final RDBJSONSupport JSON = new RDBJSONSupport(true);
    private static byte[] GZIPSIG = new byte[]{31, -117};

    public RDBDocumentSerializer(DocumentStore store) {
        this.store = store;
    }

    public String asString(@NotNull Document doc, Set<String> columnProperties) {
        StringBuilder sb = new StringBuilder(32768);
        sb.append("{");
        boolean needComma = false;
        for (Map.Entry<String, Object> entry : doc.entrySet()) {
            String key = entry.getKey();
            if (columnProperties.contains(key)) continue;
            if (needComma) {
                sb.append(",");
            }
            RDBJSONSupport.appendJsonMember(sb, key, entry.getValue());
            needComma = true;
        }
        sb.append("}");
        return sb.toString();
    }

    public String asString(UpdateOp update, Set<String> columnProperties) {
        StringBuilder sb = new StringBuilder("[");
        boolean needComma = false;
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> change : update.getChanges().entrySet()) {
            UpdateOp.Operation op = change.getValue();
            UpdateOp.Key key = change.getKey();
            if (columnProperties.contains(key.getName()) && null == key.getRevision()) continue;
            if (needComma) {
                sb.append(",");
            }
            sb.append("[");
            if (op.type == UpdateOp.Operation.Type.INCREMENT) {
                sb.append("\"+\",");
            } else if (op.type == UpdateOp.Operation.Type.SET || op.type == UpdateOp.Operation.Type.SET_MAP_ENTRY) {
                sb.append("\"=\",");
            } else if (op.type == UpdateOp.Operation.Type.MAX) {
                sb.append("\"M\",");
            } else if (op.type == UpdateOp.Operation.Type.REMOVE || op.type == UpdateOp.Operation.Type.REMOVE_MAP_ENTRY) {
                sb.append("\"*\",");
            } else {
                throw new DocumentStoreException("Can't serialize " + update.toString() + " for JSON append");
            }
            RDBJSONSupport.appendJsonString(sb, key.getName());
            sb.append(",");
            Revision rev = key.getRevision();
            if (rev != null) {
                RDBJSONSupport.appendJsonString(sb, rev.toString());
                sb.append(",");
            }
            RDBJSONSupport.appendJsonValue(sb, op.value);
            sb.append("]");
            needComma = true;
        }
        return sb.append("]").toString();
    }

    @NotNull
    public <T extends Document> T fromRow(@NotNull Collection<T> collection, @NotNull RDBRow row) throws DocumentStoreException {
        JsopTokenizer json;
        String charData = row.getData();
        Preconditions.checkNotNull((Object)charData, (Object)("RDBRow.getData() is null for collection " + collection + ", id: " + row.getId()));
        T doc = collection.newDocument(this.store);
        ((Document)doc).put(ID, row.getId());
        if (row.getModified() != Long.MIN_VALUE) {
            ((Document)doc).put(MODIFIED, row.getModified());
        }
        if (row.getModcount() != Long.MIN_VALUE) {
            ((Document)doc).put(MODCOUNT, row.getModcount());
        }
        if (row.getCollisionsModcount() != Long.MIN_VALUE) {
            ((Document)doc).put(CMODCOUNT, row.getCollisionsModcount());
        }
        if (row.hasBinaryProperties() != null) {
            ((Document)doc).put(HASBINARY, (long)row.hasBinaryProperties());
        }
        if (row.deletedOnce() != null) {
            ((Document)doc).put(DELETEDONCE, (boolean)row.deletedOnce());
        }
        if (row.getSchemaVersion() >= 2L) {
            if (row.getSdType() != Long.MIN_VALUE) {
                ((Document)doc).put(SDTYPE, row.getSdType());
            }
            if (row.getSdMaxRevTime() != Long.MIN_VALUE) {
                ((Document)doc).put(SDMAXREVTIME, row.getSdMaxRevTime());
            }
        }
        byte[] bdata = row.getBdata();
        boolean blobInUse = false;
        try {
            if (bdata != null && bdata.length != 0) {
                String s = RDBDocumentSerializer.fromBlobData(bdata);
                json = new JsopTokenizer(s);
                json.read(123);
                RDBDocumentSerializer.readDocumentFromJson(json, doc);
                json.read(0);
                blobInUse = true;
            }
        }
        catch (Exception ex) {
            throw RDBJDBCTools.asDocumentStoreException(ex, "parsing blob data as JSON");
        }
        json = new JsopTokenizer(charData);
        try {
            int next = json.read();
            if (next == 123) {
                if (blobInUse) {
                    throw new DocumentStoreException("expected literal \"blob\" but found: " + row.getData());
                }
                RDBDocumentSerializer.readDocumentFromJson(json, doc);
            } else if (next == 1) {
                if (!blobInUse) {
                    throw new DocumentStoreException("did not expect \"blob\" here: " + row.getData());
                }
                if (!"blob".equals(json.getToken())) {
                    throw new DocumentStoreException("expected string literal \"blob\"");
                }
            } else {
                throw new DocumentStoreException("unexpected token " + next + " in " + row.getData());
            }
            next = json.read();
            if (next == 44) {
                do {
                    Object ob;
                    if (!((ob = JSON.parse(json)) instanceof List)) {
                        throw new DocumentStoreException("expected array but got: " + ob);
                    }
                    List update = (List)ob;
                    for (List op : update) {
                        this.applyUpdate(doc, update, op);
                    }
                } while (json.matches(44));
            }
            json.read(0);
            RDBDocumentSerializer.checkSdType(doc);
            return doc;
        }
        catch (Exception ex) {
            char last;
            String message = String.format("Error processing persisted data for document '%s'", row.getId());
            if (charData.length() > 0 && (last = charData.charAt(charData.length() - 1)) != '}' && last != '\"' && last != ']') {
                message = message + " (DATA column might be truncated)";
            }
            LOG.error(message, (Throwable)ex);
            throw RDBJDBCTools.asDocumentStoreException(ex, message);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T extends Document> void applyUpdate(T doc, List updateString, List<Object> op) {
        String opcode = op.get(0).toString();
        String key = op.get(1).toString();
        Revision rev = null;
        Object value = null;
        if (op.size() == 3) {
            value = op.get(2);
        } else {
            rev = Revision.fromString(op.get(2).toString());
            value = op.get(3);
        }
        Object old = doc.get(key);
        if ("=".equals(opcode)) {
            if (rev == null) {
                doc.put(key, value);
                return;
            } else {
                TreeMap<Revision, Object> m = (TreeMap<Revision, Object>)old;
                if (m == null) {
                    m = new TreeMap<Revision, Object>(this.comparator);
                    doc.put(key, m);
                }
                m.put(rev, value);
            }
            return;
        } else if ("*".equals(opcode)) {
            if (rev == null) {
                doc.remove(key);
                return;
            } else {
                Map m = (Map)old;
                if (m == null) return;
                m.remove(rev);
            }
            return;
        } else if ("+".equals(opcode)) {
            if (rev != null) throw new DocumentStoreException("unexpected operation " + op + " in: " + updateString);
            Long x = (Long)value;
            if (old == null) {
                old = 0L;
            }
            doc.put(key, (Long)old + x);
            return;
        } else {
            if (!"M".equals(opcode)) throw new DocumentStoreException("unexpected operation " + op + " in: " + updateString);
            if (rev != null) throw new DocumentStoreException("unexpected operation " + op + " in: " + updateString);
            Comparable newValue = (Comparable)value;
            if (old != null && newValue.compareTo(old) <= 0) return;
            doc.put(key, value);
        }
    }

    private static <T extends Document> void readDocumentFromJson(@NotNull JsopTokenizer json, @NotNull T doc) {
        if (!json.matches(125)) {
            do {
                String key = json.readString();
                json.read(58);
                Object value = JSON.parse(json);
                doc.put(key, value);
            } while (json.matches(44));
            json.read(125);
        }
    }

    private static void checkSdType(Document doc) {
        long value;
        Object sdType = doc.get(SDTYPE);
        if (sdType instanceof Long && (value = ((Long)sdType).longValue()) == 0L) {
            doc.remove(SDTYPE);
            LOG.debug("Incorrect _sdType 0 in {}", (Object)doc.getId());
        }
    }

    private static String fromBlobData(byte[] bdata) {
        try {
            if (bdata.length >= 2 && bdata[0] == GZIPSIG[0] && bdata[1] == GZIPSIG[1]) {
                ByteArrayInputStream bis = new ByteArrayInputStream(bdata);
                GZIPInputStream gis = new GZIPInputStream((InputStream)bis, 65536);
                return IOUtils.toString((InputStream)gis, (String)"UTF-8");
            }
            return IOUtils.toString((byte[])bdata, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

