/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBConnectionHandler;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentSerializer;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStoreDB;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBJDBCTools;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBRow;
import org.apache.jackrabbit.oak.plugins.document.util.UTF8Encoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBDocumentStoreJDBC {
    private static final Logger LOG = LoggerFactory.getLogger(RDBDocumentStoreJDBC.class);
    private static final PerfLogger PERFLOG = new PerfLogger(LoggerFactory.getLogger((String)(RDBDocumentStoreJDBC.class.getName() + ".perf")));
    private static final String COLLISIONSMODCOUNT = "_collisionsModCount";
    private static final String MODCOUNT = "_modCount";
    private static final String MODIFIED = "_modified";
    private static final int SCHEMAVERSION = 2;
    private final RDBDocumentStoreDB dbInfo;
    private final RDBDocumentSerializer ser;
    private final int queryHitsLimit;
    private final int queryTimeLimit;
    private static final Map<String, String> INDEXED_PROP_MAPPING;
    private static final Set<String> SUPPORTED_OPS;
    private static final Integer INT_FALSE;
    private static final Integer INT_TRUE;
    private static final Function<Document, String> idExtractor;

    public RDBDocumentStoreJDBC(RDBDocumentStoreDB dbInfo, RDBDocumentSerializer ser, int queryHitsLimit, int queryTimeLimit) {
        this.dbInfo = dbInfo;
        this.ser = ser;
        this.queryHitsLimit = queryHitsLimit;
        this.queryTimeLimit = queryTimeLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendingUpdate(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, String id, Long modified, boolean setModifiedConditionally, Number hasBinary, Boolean deletedOnce, Long modcount, Long cmodcount, Long oldmodcount, String appendData) throws SQLException {
        String appendDataWithComma = "," + appendData;
        RDBJDBCTools.PreparedStatementComponent stringAppend = this.dbInfo.getConcatQuery(appendDataWithComma, tmd.getDataLimitInOctets());
        StringBuilder t = new StringBuilder();
        t.append("update " + tmd.getName() + " set ");
        t.append(setModifiedConditionally ? "MODIFIED = case when ? > MODIFIED then ? else MODIFIED end, " : "MODIFIED = ?, ");
        t.append("HASBINARY = ?, DELETEDONCE = ?, MODCOUNT = ?, CMODCOUNT = ?, DSIZE = DSIZE + ?, ");
        if (tmd.hasVersion()) {
            t.append("VERSION = 2, ");
        }
        t.append("DATA = " + stringAppend.getStatementComponent() + " ");
        t.append("where ID = ?");
        if (oldmodcount != null) {
            t.append(" and MODCOUNT = ?");
        }
        try (PreparedStatement stmt = connection.prepareStatement(t.toString());){
            int result;
            int si = 1;
            stmt.setObject(si++, (Object)modified, -5);
            if (setModifiedConditionally) {
                stmt.setObject(si++, (Object)modified, -5);
            }
            stmt.setObject(si++, (Object)RDBDocumentStoreJDBC.hasBinaryAsNullOrInteger(hasBinary), 5);
            stmt.setObject(si++, (Object)RDBDocumentStoreJDBC.deletedOnceAsNullOrInteger(deletedOnce), 5);
            stmt.setObject(si++, (Object)modcount, -5);
            stmt.setObject(si++, (Object)(cmodcount == null ? Long.valueOf(0L) : cmodcount), -5);
            stmt.setObject(si++, (Object)appendDataWithComma.length(), -5);
            si = stringAppend.setParameters(stmt, si);
            RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si++, id);
            if (oldmodcount != null) {
                stmt.setObject(si++, (Object)oldmodcount, -5);
            }
            if ((result = stmt.executeUpdate()) != 1) {
                LOG.debug("DB append update failed for " + tmd.getName() + "/" + id + " with oldmodcount=" + oldmodcount);
            }
            boolean bl = result == 1;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, List<String> allIds) throws SQLException {
        int count = 0;
        for (List ids : Lists.partition(allIds, (int)RDBJDBCTools.MAX_IN_CLAUSE)) {
            RDBJDBCTools.PreparedStatementComponent inClause = RDBJDBCTools.createInStatement("ID", ids, tmd.isIdBinary());
            String sql = "delete from " + tmd.getName() + " where " + inClause.getStatementComponent();
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                inClause.setParameters(stmt, 1);
                int result = stmt.executeUpdate();
                if (result != ids.size()) {
                    LOG.debug("DB delete failed for " + tmd.getName() + "/" + ids);
                }
                count += result;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, Map<String, Long> toDelete) throws SQLException {
        try (PreparedStatement stmt = connection.prepareStatement("delete from " + tmd.getName() + " where ID=? and MODIFIED=?");){
            for (Map.Entry<String, Long> entry : toDelete.entrySet()) {
                RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, 1, entry.getKey());
                stmt.setLong(2, entry.getValue());
                stmt.addBatch();
            }
            int[] rets = stmt.executeBatch();
            int updatedRows = 0;
            for (int ret : rets) {
                if (ret < 0) continue;
                updatedRows += ret;
            }
            int n = updatedRows;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteWithCondition(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, List<RDBDocumentStore.QueryCondition> conditions) throws SQLException, DocumentStoreException {
        StringBuilder query = new StringBuilder("delete from " + tmd.getName());
        String whereClause = RDBDocumentStoreJDBC.buildWhereClause(null, null, null, conditions);
        if (whereClause.length() != 0) {
            query.append(" where ").append(whereClause);
        }
        try (PreparedStatement stmt = connection.prepareStatement(query.toString());){
            int si = 1;
            for (RDBDocumentStore.QueryCondition cond : conditions) {
                if (cond.getOperands().size() != 1) {
                    throw new DocumentStoreException("unexpected condition: " + cond);
                }
                stmt.setLong(si++, (Long)cond.getOperands().get(0));
            }
            int n = stmt.executeUpdate();
            return n;
        }
    }

    public long determineServerTimeDifferenceMillis(Connection connection) {
        ResultSet rs;
        PreparedStatement stmt;
        block8: {
            String sql = this.dbInfo.getCurrentTimeStampInSecondsSyntax();
            if (sql.isEmpty()) {
                LOG.debug("{}: unsupported database, skipping DB server time check", (Object)this.dbInfo.toString());
                return 0L;
            }
            stmt = null;
            rs = null;
            stmt = connection.prepareStatement(sql);
            long start = System.currentTimeMillis();
            rs = stmt.executeQuery();
            if (!rs.next()) break block8;
            long roundtrip = System.currentTimeMillis() - start;
            long serverTimeSec = rs.getInt(1);
            long roundedTimeSec = (start + roundtrip / 2L + 500L) / 1000L;
            long resultSec = roundedTimeSec - serverTimeSec;
            String message = String.format("instance timestamp: %d, DB timestamp: %d, difference: %d", roundedTimeSec, serverTimeSec, resultSec);
            if (Math.abs(resultSec) >= 2L) {
                LOG.info(message);
            } else {
                LOG.debug(message);
            }
            long l = resultSec * 1000L;
            RDBJDBCTools.closeResultSet(rs);
            RDBJDBCTools.closeStatement(stmt);
            return l;
        }
        try {
            try {
                throw new DocumentStoreException("failed to determine server timestamp");
            }
            catch (Exception ex) {
                LOG.error("Trying to determine time difference to server", (Throwable)ex);
                throw RDBJDBCTools.asDocumentStoreException(ex, "Trying to determine time difference to server");
            }
        }
        catch (Throwable throwable) {
            RDBJDBCTools.closeResultSet(rs);
            RDBJDBCTools.closeStatement(stmt);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Document> Set<String> insert(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, List<T> documents) throws SQLException {
        int[] results;
        int actualSchema = tmd.hasSplitDocs() ? 2 : 1;
        List<Document> sortedDocs = RDBDocumentStoreJDBC.sortDocuments(documents);
        try (PreparedStatement stmt = connection.prepareStatement("insert into " + tmd.getName() + "(ID, MODIFIED, HASBINARY, DELETEDONCE, MODCOUNT, CMODCOUNT, DSIZE, " + (tmd.hasVersion() ? "VERSION, " : "") + (tmd.hasSplitDocs() ? "SDTYPE, SDMAXREVTIME, " : "") + "DATA, BDATA) values (?, ?, ?, ?, ?, ?, ?, " + (tmd.hasVersion() ? " " + actualSchema + ", " : "") + (tmd.hasSplitDocs() ? "?, ?, " : "") + "?, ?)");){
            for (Document document : sortedDocs) {
                String data = this.ser.asString(document, tmd.getColumnOnlyProperties());
                String id = document.getId();
                Number hasBinary = (Number)document.get("_bin");
                Boolean deletedOnce = (Boolean)document.get("_deletedOnce");
                Long cmodcount = (Long)document.get(COLLISIONSMODCOUNT);
                int si = 1;
                RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si++, id);
                stmt.setObject(si++, document.get(MODIFIED), -5);
                stmt.setObject(si++, (Object)RDBDocumentStoreJDBC.hasBinaryAsNullOrInteger(hasBinary), 5);
                stmt.setObject(si++, (Object)RDBDocumentStoreJDBC.deletedOnceAsNullOrInteger(deletedOnce), 5);
                stmt.setObject(si++, document.get(MODCOUNT), -5);
                stmt.setObject(si++, (Object)(cmodcount == null ? Long.valueOf(0L) : cmodcount), -5);
                stmt.setObject(si++, (Object)data.length(), -5);
                if (tmd.hasSplitDocs()) {
                    stmt.setObject(si++, document.get("_sdType"));
                    stmt.setObject(si++, document.get("_sdMaxRevTime"));
                }
                if (data.length() < tmd.getDataLimitInOctets() / 3) {
                    stmt.setString(si++, data);
                    stmt.setBinaryStream(si++, (InputStream)null, 0);
                } else {
                    stmt.setString(si++, "\"blob\"");
                    byte[] bytes = RDBDocumentStore.asBytes(data);
                    stmt.setBytes(si++, bytes);
                }
                stmt.addBatch();
            }
            results = stmt.executeBatch();
        }
        HashSet<String> succesfullyInserted = new HashSet<String>();
        for (int i = 0; i < results.length; ++i) {
            int result = results[i];
            if (result != 1 && result != -2) {
                LOG.debug("DB insert failed for {}: {}", (Object)tmd.getName(), (Object)sortedDocs.get(i).getId());
                continue;
            }
            succesfullyInserted.add(sortedDocs.get(i).getId());
        }
        return succesfullyInserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Document> Set<String> update(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, List<T> documents, boolean upsert) throws SQLException {
        RDBDocumentStoreJDBC.assertNoDuplicatedIds(documents);
        HashSet<String> successfulUpdates = new HashSet<String>();
        ArrayList<String> updatedKeys = new ArrayList<String>();
        int[] batchResults = new int[]{};
        try (PreparedStatement stmt = connection.prepareStatement("update " + tmd.getName() + " set MODIFIED = ?, HASBINARY = ?, DELETEDONCE = ?, MODCOUNT = ?, CMODCOUNT = ?, DSIZE = ?, DATA = ?, " + (tmd.hasVersion() ? " VERSION = 2, " : "") + "BDATA = ? where ID = ? and MODCOUNT = ?");){
            boolean batchIsEmpty = true;
            for (Document document : RDBDocumentStoreJDBC.sortDocuments(documents)) {
                Long modcount = (Long)document.get(MODCOUNT);
                if (modcount == 1L) continue;
                String data = this.ser.asString(document, tmd.getColumnOnlyProperties());
                Number hasBinary = (Number)document.get("_bin");
                Boolean deletedOnce = (Boolean)document.get("_deletedOnce");
                Long cmodcount = (Long)document.get(COLLISIONSMODCOUNT);
                int si = 1;
                stmt.setObject(si++, document.get(MODIFIED), -5);
                stmt.setObject(si++, (Object)RDBDocumentStoreJDBC.hasBinaryAsNullOrInteger(hasBinary), 5);
                stmt.setObject(si++, (Object)RDBDocumentStoreJDBC.deletedOnceAsNullOrInteger(deletedOnce), 5);
                stmt.setObject(si++, (Object)modcount, -5);
                stmt.setObject(si++, (Object)(cmodcount == null ? Long.valueOf(0L) : cmodcount), -5);
                stmt.setObject(si++, (Object)data.length(), -5);
                if (data.length() < tmd.getDataLimitInOctets() / 3) {
                    stmt.setString(si++, data);
                    stmt.setBinaryStream(si++, (InputStream)null, 0);
                } else {
                    stmt.setString(si++, "\"blob\"");
                    byte[] bytes = RDBDocumentStore.asBytes(data);
                    stmt.setBytes(si++, bytes);
                }
                RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si++, document.getId());
                stmt.setObject(si++, (Object)(modcount - 1L), -5);
                stmt.addBatch();
                updatedKeys.add(document.getId());
                batchIsEmpty = false;
            }
            if (!batchIsEmpty) {
                batchResults = stmt.executeBatch();
                connection.commit();
            }
        }
        for (int i = 0; i < batchResults.length; ++i) {
            int result = batchResults[i];
            if (result != 1 && result != -2) continue;
            successfulUpdates.add((String)updatedKeys.get(i));
        }
        if (upsert) {
            ArrayList<Document> toBeInserted = new ArrayList<Document>(documents.size());
            for (Document doc : documents) {
                if ((Long)doc.get(MODCOUNT) != 1L) continue;
                toBeInserted.add(doc);
            }
            if (!toBeInserted.isEmpty()) {
                for (String id : this.insert(connection, tmd, toBeInserted)) {
                    successfulUpdates.add(id);
                }
            }
        }
        return successfulUpdates;
    }

    private static <T extends Document> void assertNoDuplicatedIds(List<T> documents) {
        if (Sets.newHashSet((Iterable)Iterables.transform(documents, idExtractor)).size() < documents.size()) {
            throw new IllegalArgumentException("There are duplicated ids in the document list");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<RDBRow> query(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, String minId, String maxId, List<String> excludeKeyPatterns, List<RDBDocumentStore.QueryCondition> conditions, int limit) throws SQLException {
        long start = System.currentTimeMillis();
        ArrayList<RDBRow> result = new ArrayList<RDBRow>();
        long dataTotal = 0L;
        long bdataTotal = 0L;
        PreparedStatement stmt = null;
        String fields = tmd.hasSplitDocs() ? "ID, MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, VERSION, SDTYPE, SDMAXREVTIME, DATA, BDATA" : (tmd.hasVersion() ? "ID, MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, VERSION, DATA, BDATA" : "ID, MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, DATA, BDATA");
        ResultSet rs = null;
        try {
            long pstart = PERFLOG.start(PERFLOG.isDebugEnabled() ? "querying: table=" + tmd.getName() + ", minId=" + minId + ", maxId=" + maxId + ", excludeKeyPatterns=" + excludeKeyPatterns + ", conditions=" + conditions + ", limit=" + limit : null);
            stmt = this.prepareQuery(connection, tmd, fields, minId, maxId, excludeKeyPatterns, conditions, limit, "ID");
            rs = stmt.executeQuery();
            while (rs.next() && result.size() < limit) {
                int field = 1;
                String id = RDBDocumentStoreJDBC.getIdFromRS(tmd, rs, field++);
                if (minId != null && id.compareTo(minId) < 0 || maxId != null && id.compareTo(maxId) > 0) {
                    throw new DocumentStoreException("unexpected query result: '" + minId + "' < '" + id + "' < '" + maxId + "' - broken DB collation?");
                }
                long modified = RDBDocumentStoreJDBC.readLongFromResultSet(rs, field++);
                long modcount = RDBDocumentStoreJDBC.readLongFromResultSet(rs, field++);
                long cmodcount = RDBDocumentStoreJDBC.readLongFromResultSet(rs, field++);
                Long hasBinary = RDBDocumentStoreJDBC.readLongOrNullFromResultSet(rs, field++);
                Boolean deletedOnce = RDBDocumentStoreJDBC.readBooleanOrNullFromResultSet(rs, field++);
                long schemaVersion = tmd.hasVersion() ? RDBDocumentStoreJDBC.readLongFromResultSet(rs, field++) : 0L;
                long sdType = tmd.hasSplitDocs() ? RDBDocumentStoreJDBC.readLongFromResultSet(rs, field++) : Long.MIN_VALUE;
                long sdMaxRevTime = tmd.hasSplitDocs() ? RDBDocumentStoreJDBC.readLongFromResultSet(rs, field++) : Long.MIN_VALUE;
                String data = rs.getString(field++);
                byte[] bdata = rs.getBytes(field++);
                result.add(new RDBRow(id, hasBinary, deletedOnce, modified, modcount, cmodcount, schemaVersion, sdType, sdMaxRevTime, data, bdata));
                dataTotal += (long)data.length();
                bdataTotal += bdata == null ? 0L : (long)bdata.length;
                PERFLOG.end(pstart, 10L, "queried: table={} -> id={}, modcount={}, modified={}, data={}, bdata={}", new Object[]{tmd.getName(), id, modcount, modified, data == null ? 0 : data.length(), bdata == null ? 0 : bdata.length});
            }
        }
        catch (Throwable throwable) {
            RDBJDBCTools.closeStatement(stmt);
            RDBJDBCTools.closeResultSet(rs);
            throw throwable;
        }
        RDBJDBCTools.closeStatement(stmt);
        RDBJDBCTools.closeResultSet(rs);
        long elapsed = System.currentTimeMillis() - start;
        if (this.queryHitsLimit != 0 && result.size() > this.queryHitsLimit || this.queryTimeLimit != 0 && elapsed > (long)this.queryTimeLimit) {
            String message;
            String params = String.format("params minid '%s' maxid '%s' excludeKeyPatterns %s conditions %s limit %d.", minId, maxId, excludeKeyPatterns, conditions, limit);
            String resultRange = "";
            if (result.size() > 0) {
                resultRange = String.format(" Result range: '%s'...'%s'.", ((RDBRow)result.get(0)).getId(), ((RDBRow)result.get(result.size() - 1)).getId());
            }
            String postfix = String.format(" Read %d chars from DATA and %d bytes from BDATA. Check calling method.", dataTotal, bdataTotal);
            if (this.queryHitsLimit != 0 && result.size() > this.queryHitsLimit) {
                message = String.format("Potentially excessive query on %s with %d hits (limited to %d, configured QUERYHITSLIMIT %d), elapsed time %dms, %s%s%s", tmd.getName(), result.size(), limit, this.queryHitsLimit, elapsed, params, resultRange, postfix);
                LOG.info(message, (Throwable)new Exception("call stack"));
            }
            if (this.queryTimeLimit != 0 && elapsed > (long)this.queryTimeLimit) {
                message = String.format("Long running query on %s with %d hits (limited to %d), elapsed time %dms (configured QUERYTIMELIMIT %d), %s%s%s", tmd.getName(), result.size(), limit, elapsed, this.queryTimeLimit, params, resultRange, postfix);
                LOG.info(message, (Throwable)new Exception("call stack"));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, String aggregate, String field, String minId, String maxId, List<String> excludeKeyPatterns, List<RDBDocumentStore.QueryCondition> conditions) throws SQLException {
        long l;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        long start = System.currentTimeMillis();
        long result = -1L;
        String selector = aggregate + "(" + ("*".equals(field) ? "*" : INDEXED_PROP_MAPPING.get(field)) + ")";
        try {
            stmt = this.prepareQuery(connection, tmd, selector, minId, maxId, excludeKeyPatterns, conditions, Integer.MAX_VALUE, null);
            rs = stmt.executeQuery();
            l = result = rs.next() ? rs.getLong(1) : -1L;
        }
        catch (Throwable throwable) {
            RDBJDBCTools.closeStatement(stmt);
            RDBJDBCTools.closeResultSet(rs);
            if (LOG.isDebugEnabled()) {
                long elapsed = System.currentTimeMillis() - start;
                String params = String.format("params minid '%s' maxid '%s' excludeKeyPatterns %s conditions %s.", minId, maxId, excludeKeyPatterns, conditions);
                LOG.debug("Aggregate query " + selector + " on " + tmd.getName() + " with " + params + " -> " + result + ", took " + elapsed + "ms");
            }
            throw throwable;
        }
        RDBJDBCTools.closeStatement(stmt);
        RDBJDBCTools.closeResultSet(rs);
        if (LOG.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - start;
            String params = String.format("params minid '%s' maxid '%s' excludeKeyPatterns %s conditions %s.", minId, maxId, excludeKeyPatterns, conditions);
            LOG.debug("Aggregate query " + selector + " on " + tmd.getName() + " with " + params + " -> " + result + ", took " + elapsed + "ms");
        }
        return l;
    }

    @NotNull
    public Iterator<RDBRow> queryAsIterator(RDBConnectionHandler ch, RDBDocumentStore.RDBTableMetaData tmd, String minId, String maxId, List<String> excludeKeyPatterns, List<RDBDocumentStore.QueryCondition> conditions, int limit, String sortBy) throws SQLException {
        return new ResultSetIterator(ch, tmd, minId, maxId, excludeKeyPatterns, conditions, limit, sortBy);
    }

    @NotNull
    private PreparedStatement prepareQuery(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, String columns, String minId, String maxId, List<String> excludeKeyPatterns, List<RDBDocumentStore.QueryCondition> conditions, int limit, String sortBy) throws SQLException {
        StringBuilder selectClause = new StringBuilder();
        if (limit != Integer.MAX_VALUE && this.dbInfo.getFetchFirstSyntax() == RDBDocumentStoreDB.FETCHFIRSTSYNTAX.TOP) {
            selectClause.append("TOP " + limit + " ");
        }
        selectClause.append(columns + " from " + tmd.getName());
        String whereClause = RDBDocumentStoreJDBC.buildWhereClause(minId, maxId, excludeKeyPatterns, conditions);
        StringBuilder query = new StringBuilder();
        query.append("select ").append((CharSequence)selectClause);
        if (whereClause.length() != 0) {
            query.append(" where ").append(whereClause);
        }
        if (sortBy != null) {
            query.append(" order by ID");
        }
        if (limit != Integer.MAX_VALUE) {
            switch (this.dbInfo.getFetchFirstSyntax()) {
                case LIMIT: {
                    query.append(" LIMIT " + limit);
                    break;
                }
                case FETCHFIRST: {
                    query.append(" FETCH FIRST " + limit + " ROWS ONLY");
                    break;
                }
            }
        }
        PreparedStatement stmt = connection.prepareStatement(query.toString());
        int si = 1;
        if (minId != null) {
            RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si++, minId);
        }
        if (maxId != null) {
            RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si++, maxId);
        }
        for (String keyPattern : excludeKeyPatterns) {
            RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si++, keyPattern);
        }
        for (RDBDocumentStore.QueryCondition cond : conditions) {
            for (Object object : cond.getOperands()) {
                stmt.setObject(si++, object);
            }
        }
        if (limit != Integer.MAX_VALUE) {
            stmt.setFetchSize(limit);
        }
        return stmt;
    }

    public List<RDBRow> read(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, Collection<String> allKeys) throws SQLException {
        ArrayList<RDBRow> rows = new ArrayList<RDBRow>();
        for (List keys : Iterables.partition(allKeys, (int)RDBJDBCTools.MAX_IN_CLAUSE)) {
            long pstart = PERFLOG.start(PERFLOG.isDebugEnabled() ? "reading: " + keys : null);
            RDBJDBCTools.PreparedStatementComponent inClause = RDBJDBCTools.createInStatement("ID", keys, tmd.isIdBinary());
            StringBuilder query = new StringBuilder();
            if (tmd.hasSplitDocs()) {
                query.append("select ID, MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, VERSION, SDTYPE, SDMAXREVTIME, DATA, BDATA from ");
            } else if (tmd.hasVersion()) {
                query.append("select ID, MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, VERSION, DATA, BDATA from ");
            } else {
                query.append("select ID, MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, DATA, BDATA from ");
            }
            query.append(tmd.getName());
            query.append(" where ").append(inClause.getStatementComponent());
            PreparedStatement stmt = connection.prepareStatement(query.toString());
            ResultSet rs = null;
            stmt.setPoolable(false);
            try {
                inClause.setParameters(stmt, 1);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    int field = 1;
                    String id = RDBDocumentStoreJDBC.getIdFromRS(tmd, rs, field++);
                    long modified = RDBDocumentStoreJDBC.readLongFromResultSet(rs, field++);
                    long modcount = RDBDocumentStoreJDBC.readLongFromResultSet(rs, field++);
                    long cmodcount = RDBDocumentStoreJDBC.readLongFromResultSet(rs, field++);
                    Long hasBinary = RDBDocumentStoreJDBC.readLongOrNullFromResultSet(rs, field++);
                    Boolean deletedOnce = RDBDocumentStoreJDBC.readBooleanOrNullFromResultSet(rs, field++);
                    long schemaVersion = tmd.hasVersion() ? RDBDocumentStoreJDBC.readLongFromResultSet(rs, field++) : 0L;
                    long sdType = tmd.hasSplitDocs() ? RDBDocumentStoreJDBC.readLongFromResultSet(rs, field++) : Long.MIN_VALUE;
                    long sdMaxRevTime = tmd.hasSplitDocs() ? RDBDocumentStoreJDBC.readLongFromResultSet(rs, field++) : Long.MIN_VALUE;
                    String data = rs.getString(field++);
                    byte[] bdata = rs.getBytes(field++);
                    RDBRow row = new RDBRow(id, hasBinary, deletedOnce, modified, modcount, cmodcount, schemaVersion, sdType, sdMaxRevTime, data, bdata);
                    rows.add(row);
                    PERFLOG.end(pstart, 10L, "read: table={}, id={} -> modcount={}, modified={}, data={}, bdata={}", new Object[]{tmd.getName(), id, modcount, modified, data == null ? 0 : data.length(), bdata == null ? 0 : bdata.length});
                }
            }
            catch (SQLException ex) {
                block13: {
                    List<RDBRow> list;
                    try {
                        LOG.debug("attempting to read " + keys, (Throwable)ex);
                        PERFLOG.end(pstart, 10L, "read: table={} -> exception={}", (Object)tmd.getName(), (Object)ex.getMessage());
                        if (!"22001".equals(ex.getSQLState())) break block13;
                        try {
                            connection.rollback();
                        }
                        catch (SQLException ex2) {
                            LOG.debug("failed to rollback", (Throwable)ex2);
                        }
                        list = null;
                    }
                    catch (Throwable throwable) {
                        RDBJDBCTools.closeResultSet(rs);
                        RDBJDBCTools.closeStatement(stmt);
                        throw throwable;
                    }
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(stmt);
                    return list;
                }
                throw ex;
            }
            RDBJDBCTools.closeResultSet(rs);
            RDBJDBCTools.closeStatement(stmt);
        }
        return rows;
    }

    @Nullable
    public RDBRow read(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, String id, long lastmodcount, long lastmodified) throws SQLException {
        RDBRow field2;
        ResultSet rs;
        PreparedStatement stmt;
        long pstart;
        block11: {
            pstart = PERFLOG.start();
            boolean useCaseStatement = lastmodcount != -1L && lastmodified >= 1L;
            StringBuffer sql = new StringBuffer();
            String fields = tmd.hasSplitDocs() ? "MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, VERSION, SDTYPE, SDMAXREVTIME, " : (tmd.hasVersion() ? "MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, VERSION, " : "MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, ");
            sql.append("select ").append(fields);
            if (useCaseStatement) {
                sql.append("case when (MODCOUNT = ? and MODIFIED = ?) then null else DATA end as DATA, ");
                sql.append("case when (MODCOUNT = ? and MODIFIED = ?) then null else BDATA end as BDATA ");
            } else {
                sql.append("DATA, BDATA ");
            }
            sql.append("from " + tmd.getName() + " where ID = ?");
            stmt = connection.prepareStatement(sql.toString());
            rs = null;
            int si = 1;
            if (useCaseStatement) {
                stmt.setLong(si++, lastmodcount);
                stmt.setLong(si++, lastmodified);
                stmt.setLong(si++, lastmodcount);
                stmt.setLong(si++, lastmodified);
            }
            RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si, id);
            rs = stmt.executeQuery();
            if (!rs.next()) break block11;
            int field2 = 1;
            long modified = RDBDocumentStoreJDBC.readLongFromResultSet(rs, field2++);
            long modcount = RDBDocumentStoreJDBC.readLongFromResultSet(rs, field2++);
            long cmodcount = RDBDocumentStoreJDBC.readLongFromResultSet(rs, field2++);
            Long hasBinary = RDBDocumentStoreJDBC.readLongOrNullFromResultSet(rs, field2++);
            Boolean deletedOnce = RDBDocumentStoreJDBC.readBooleanOrNullFromResultSet(rs, field2++);
            long schemaVersion = tmd.hasVersion() ? RDBDocumentStoreJDBC.readLongFromResultSet(rs, field2++) : 0L;
            long sdType = tmd.hasSplitDocs() ? RDBDocumentStoreJDBC.readLongFromResultSet(rs, field2++) : Long.MIN_VALUE;
            long sdMaxRevTime = tmd.hasSplitDocs() ? RDBDocumentStoreJDBC.readLongFromResultSet(rs, field2++) : Long.MIN_VALUE;
            String data = rs.getString(field2++);
            byte[] bdata = rs.getBytes(field2++);
            PERFLOG.end(pstart, 10L, "read: table={}, id={}, lastmodcount={}, lastmodified={} -> modcount={}, modified={}, data={}, bdata={}", new Object[]{tmd.getName(), id, lastmodcount, lastmodified, modcount, modified, data == null ? 0 : data.length(), bdata == null ? 0 : bdata.length});
            RDBRow rDBRow = new RDBRow(id, hasBinary, deletedOnce, modified, modcount, cmodcount, schemaVersion, sdType, sdMaxRevTime, data, bdata);
            RDBJDBCTools.closeResultSet(rs);
            RDBJDBCTools.closeStatement(stmt);
            return rDBRow;
        }
        try {
            PERFLOG.end(pstart, 10L, "read: table={}, id={}, lastmodcount={}, lastmodified={} -> not found", new Object[]{tmd.getName(), id, lastmodcount, lastmodified});
            field2 = null;
        }
        catch (SQLException ex) {
            block12: {
                RDBRow rDBRow;
                try {
                    LOG.debug("attempting to read " + id + " (id length is " + id.length() + ")", (Throwable)ex);
                    PERFLOG.end(pstart, 10L, "read: table={}, id={}, lastmodcount={}, lastmodified={} -> exception={}", new Object[]{tmd.getName(), id, lastmodcount, lastmodified, ex.getMessage()});
                    if (!"22001".equals(ex.getSQLState())) break block12;
                    try {
                        connection.rollback();
                    }
                    catch (SQLException ex2) {
                        LOG.debug("failed to rollback", (Throwable)ex2);
                    }
                    rDBRow = null;
                }
                catch (Throwable throwable) {
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(stmt);
                    throw throwable;
                }
                RDBJDBCTools.closeResultSet(rs);
                RDBJDBCTools.closeStatement(stmt);
                return rDBRow;
            }
            throw ex;
        }
        RDBJDBCTools.closeResultSet(rs);
        RDBJDBCTools.closeStatement(stmt);
        return field2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, String id, Long modified, Number hasBinary, Boolean deletedOnce, Long modcount, Long cmodcount, Long oldmodcount, String data) throws SQLException {
        StringBuilder t = new StringBuilder();
        t.append("update " + tmd.getName() + " set ");
        t.append("MODIFIED = ?, HASBINARY = ?, DELETEDONCE = ?, MODCOUNT = ?, CMODCOUNT = ?, DSIZE = ?, DATA = ?, " + (tmd.hasVersion() ? " VERSION = 2, " : "") + "BDATA = ? ");
        t.append("where ID = ?");
        if (oldmodcount != null) {
            t.append(" and MODCOUNT = ?");
        }
        try (PreparedStatement stmt = connection.prepareStatement(t.toString());){
            int result;
            int si = 1;
            stmt.setObject(si++, (Object)modified, -5);
            stmt.setObject(si++, (Object)RDBDocumentStoreJDBC.hasBinaryAsNullOrInteger(hasBinary), 5);
            stmt.setObject(si++, (Object)RDBDocumentStoreJDBC.deletedOnceAsNullOrInteger(deletedOnce), 5);
            stmt.setObject(si++, (Object)modcount, -5);
            stmt.setObject(si++, (Object)(cmodcount == null ? Long.valueOf(0L) : cmodcount), -5);
            stmt.setObject(si++, (Object)data.length(), -5);
            if (data.length() < tmd.getDataLimitInOctets() / 3) {
                stmt.setString(si++, data);
                stmt.setBinaryStream(si++, (InputStream)null, 0);
            } else {
                stmt.setString(si++, "\"blob\"");
                byte[] bytes = RDBDocumentStore.asBytes(data);
                stmt.setBytes(si++, bytes);
            }
            RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si++, id);
            if (oldmodcount != null) {
                stmt.setObject(si++, (Object)oldmodcount, -5);
            }
            if ((result = stmt.executeUpdate()) != 1) {
                LOG.debug("DB update failed for " + tmd.getName() + "/" + id + " with oldmodcount=" + oldmodcount);
            }
            boolean bl = result == 1;
            return bl;
        }
    }

    private static String buildWhereClause(String minId, String maxId, List<String> excludeKeyPatterns, List<RDBDocumentStore.QueryCondition> conditions) {
        StringBuilder result = new StringBuilder();
        String whereSep = "";
        if (minId != null) {
            result.append("ID > ?");
            whereSep = " and ";
        }
        if (maxId != null) {
            result.append(whereSep).append("ID < ?");
            whereSep = " and ";
        }
        if (excludeKeyPatterns != null && !excludeKeyPatterns.isEmpty()) {
            result.append(whereSep);
            whereSep = " and ";
            result.append("not (");
            for (int i = 0; i < excludeKeyPatterns.size(); ++i) {
                result.append(i == 0 ? "" : " or ");
                result.append("ID like ?");
            }
            result.append(")");
        }
        for (RDBDocumentStore.QueryCondition cond : conditions) {
            String op = cond.getOperator();
            if (!SUPPORTED_OPS.contains(op)) {
                throw new DocumentStoreException("unsupported operator: " + op);
            }
            String indexedProperty = cond.getPropertyName();
            String column = INDEXED_PROP_MAPPING.get(indexedProperty);
            if (column != null) {
                String realOperand = op;
                boolean allowNull = false;
                if (op.startsWith("null or ")) {
                    realOperand = op.substring("null or ".length());
                    allowNull = true;
                }
                result.append(whereSep);
                if (allowNull) {
                    result.append("(").append(column).append(" is null or ");
                }
                result.append(column).append(" ").append(realOperand);
                List<? extends Object> operands = cond.getOperands();
                if (operands.size() == 1) {
                    result.append(" ?");
                } else if (operands.size() > 1) {
                    result.append(" (");
                    for (int i = 0; i < operands.size(); ++i) {
                        result.append("?");
                        if (i >= operands.size() - 1) continue;
                        result.append(", ");
                    }
                    result.append(") ");
                }
                if (allowNull) {
                    result.append(")");
                }
                whereSep = " and ";
                continue;
            }
            throw new DocumentStoreException("unsupported indexed property: " + indexedProperty);
        }
        return result.toString();
    }

    private static String getIdFromRS(RDBDocumentStore.RDBTableMetaData tmd, ResultSet rs, int idx) throws SQLException {
        if (tmd.isIdBinary()) {
            try {
                return new String(rs.getBytes(idx), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error("UTF-8 not supported", (Throwable)ex);
                throw RDBJDBCTools.asDocumentStoreException(ex, "UTF-8 not supported");
            }
        }
        return rs.getString(idx);
    }

    private static void setIdInStatement(RDBDocumentStore.RDBTableMetaData tmd, PreparedStatement stmt, int idx, String id) throws SQLException {
        try {
            if (tmd.isIdBinary()) {
                stmt.setBytes(idx, UTF8Encoder.encodeAsByteArray(id));
            } else {
                if (!UTF8Encoder.canEncode(id)) {
                    throw new IOException("can not encode as UTF-8");
                }
                stmt.setString(idx, id);
            }
        }
        catch (IOException ex) {
            LOG.warn("Invalid ID: " + id, (Throwable)ex);
            throw RDBJDBCTools.asDocumentStoreException(ex, "Invalid ID: " + id);
        }
    }

    private static long readLongFromResultSet(ResultSet res, int index) throws SQLException {
        long v = res.getLong(index);
        return res.wasNull() ? Long.MIN_VALUE : v;
    }

    @Nullable
    private static Boolean readBooleanOrNullFromResultSet(ResultSet res, int index) throws SQLException {
        long v = res.getLong(index);
        return res.wasNull() ? null : Boolean.valueOf(v != 0L);
    }

    @Nullable
    private static Long readLongOrNullFromResultSet(ResultSet res, int index) throws SQLException {
        long v = res.getLong(index);
        return res.wasNull() ? null : Long.valueOf(v);
    }

    @Nullable
    private static Integer deletedOnceAsNullOrInteger(Boolean b) {
        return b == null ? null : (b != false ? INT_TRUE : INT_FALSE);
    }

    @Nullable
    private static Integer hasBinaryAsNullOrInteger(Number n) {
        return n == null ? null : (n.longValue() == 1L ? INT_TRUE : INT_FALSE);
    }

    private static <T extends Document> List<T> sortDocuments(Collection<T> documents) {
        ArrayList<T> result = new ArrayList<T>(documents);
        Collections.sort(result, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Document)o1).getId().compareTo(((Document)o2).getId());
            }
        });
        return result;
    }

    static {
        Cloneable tmp = new HashMap<String, String>();
        tmp.put(MODIFIED, "MODIFIED");
        tmp.put("_bin", "HASBINARY");
        tmp.put("_deletedOnce", "DELETEDONCE");
        tmp.put(COLLISIONSMODCOUNT, "CMODCOUNT");
        tmp.put("_sdType", "SDTYPE");
        tmp.put("_sdMaxRevTime", "SDMAXREVTIME");
        tmp.put(RDBDocumentStore.VERSIONPROP, "VERSION");
        INDEXED_PROP_MAPPING = Collections.unmodifiableMap(tmp);
        tmp = new HashSet();
        tmp.add(">=");
        tmp.add(">");
        tmp.add("<=");
        tmp.add("<");
        tmp.add("=");
        tmp.add("in");
        tmp.add("is null");
        tmp.add("is not null");
        tmp.add("null or <");
        SUPPORTED_OPS = Collections.unmodifiableSet(tmp);
        INT_FALSE = 0;
        INT_TRUE = 1;
        idExtractor = new Function<Document, String>(){

            public String apply(Document input) {
                return input.getId();
            }
        };
    }

    private class ResultSetIterator
    implements Iterator<RDBRow>,
    Closeable {
        private RDBConnectionHandler ch;
        private Connection connection;
        private RDBDocumentStore.RDBTableMetaData tmd;
        private PreparedStatement stmt;
        private ResultSet rs;
        private RDBRow next = null;
        private Exception callstack = null;
        private long elapsed = 0L;
        private String message = null;
        private long cnt = 0L;
        private long pstart;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResultSetIterator(RDBConnectionHandler ch, RDBDocumentStore.RDBTableMetaData tmd, String minId, String maxId, List<String> excludeKeyPatterns, List<RDBDocumentStore.QueryCondition> conditions, int limit, String sortBy) throws SQLException {
            long start = System.currentTimeMillis();
            try {
                this.ch = ch;
                this.connection = ch.getROConnection();
                this.tmd = tmd;
                String fields = tmd.hasSplitDocs() ? "ID, MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, VERSION, SDTYPE, SDMAXREVTIME, DATA, BDATA" : (tmd.hasVersion() ? "ID, MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, VERSION, DATA, BDATA" : "ID, MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, DATA, BDATA");
                this.stmt = RDBDocumentStoreJDBC.this.prepareQuery(this.connection, tmd, fields, minId, maxId, excludeKeyPatterns, conditions, limit, sortBy);
                this.rs = this.stmt.executeQuery();
                this.next = this.internalNext();
                this.message = String.format("Query on %s with params minid '%s' maxid '%s' excludeKeyPatterns %s conditions %s.", tmd.getName(), minId, maxId, excludeKeyPatterns, conditions);
                if (LOG.isDebugEnabled()) {
                    this.callstack = new Exception("call stack");
                }
                this.pstart = PERFLOG.start(PERFLOG.isDebugEnabled() ? "querying: table=" + tmd.getName() + ", minId=" + minId + ", maxId=" + maxId + ", excludeKeyPatterns=" + excludeKeyPatterns + ", conditions=" + conditions + ", limit=" + limit + ", sortBy=" + sortBy : null);
            }
            finally {
                this.elapsed += System.currentTimeMillis() - start;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public void remove() {
            throw new RuntimeException("remove not supported");
        }

        @Override
        public RDBRow next() {
            RDBRow result = this.next;
            if (this.next != null) {
                this.next = this.internalNext();
                ++this.cnt;
                return result;
            }
            throw new NoSuchElementException("ResultSet exhausted");
        }

        private RDBRow internalNext() {
            long start = System.currentTimeMillis();
            try {
                if (this.rs.next()) {
                    int field = 1;
                    String id = RDBDocumentStoreJDBC.getIdFromRS(this.tmd, this.rs, field++);
                    long modified = RDBDocumentStoreJDBC.readLongFromResultSet(this.rs, field++);
                    long modcount = RDBDocumentStoreJDBC.readLongFromResultSet(this.rs, field++);
                    long cmodcount = RDBDocumentStoreJDBC.readLongFromResultSet(this.rs, field++);
                    Long hasBinary = RDBDocumentStoreJDBC.readLongOrNullFromResultSet(this.rs, field++);
                    Boolean deletedOnce = RDBDocumentStoreJDBC.readBooleanOrNullFromResultSet(this.rs, field++);
                    long schemaVersion = this.tmd.hasVersion() ? RDBDocumentStoreJDBC.readLongFromResultSet(this.rs, field++) : 0L;
                    long sdType = this.tmd.hasSplitDocs() ? RDBDocumentStoreJDBC.readLongFromResultSet(this.rs, field++) : Long.MIN_VALUE;
                    long sdMaxRevTime = this.tmd.hasSplitDocs() ? RDBDocumentStoreJDBC.readLongFromResultSet(this.rs, field++) : Long.MIN_VALUE;
                    String data = this.rs.getString(field++);
                    byte[] bdata = this.rs.getBytes(field++);
                    PERFLOG.end(this.pstart, 10L, "queried: table={} -> id={}, modcount={}, modified={}, data={}, bdata={}", new Object[]{this.tmd.getName(), id, modcount, modified, data == null ? 0 : data.length(), bdata == null ? 0 : bdata.length});
                    RDBRow rDBRow = new RDBRow(id, hasBinary, deletedOnce, modified, modcount, cmodcount, schemaVersion, sdType, sdMaxRevTime, data, bdata);
                    return rDBRow;
                }
                this.rs = RDBJDBCTools.closeResultSet(this.rs);
                this.stmt = RDBJDBCTools.closeStatement(this.stmt);
                this.connection.commit();
                this.internalClose();
                RDBRow field = null;
                return field;
            }
            catch (SQLException ex) {
                LOG.debug("iterating through result set", (Throwable)ex);
                throw new RuntimeException(ex);
            }
            finally {
                this.elapsed += System.currentTimeMillis() - start;
            }
        }

        @Override
        public void close() throws IOException {
            this.internalClose();
        }

        public void finalize() throws Throwable {
            try {
                if (this.connection != null) {
                    if (this.callstack != null) {
                        LOG.error("finalizing unclosed " + this + "; check caller", (Throwable)this.callstack);
                    } else {
                        LOG.error("finalizing unclosed " + this);
                    }
                }
            }
            finally {
                super.finalize();
            }
        }

        private void internalClose() {
            this.rs = RDBJDBCTools.closeResultSet(this.rs);
            this.stmt = RDBJDBCTools.closeStatement(this.stmt);
            this.ch.closeConnection(this.connection);
            this.connection = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.message + " -> " + this.cnt + " results in " + this.elapsed + "ms");
            }
        }
    }
}

