/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class CompositeObserver
implements Observer {
    private final Set<Observer> observers = Sets.newIdentityHashSet();

    public synchronized void addObserver(@NotNull Observer observer) {
        Preconditions.checkState((boolean)this.observers.add((Observer)Preconditions.checkNotNull((Object)observer)));
    }

    public synchronized void removeObserver(@NotNull Observer observer) {
        Preconditions.checkState((boolean)this.observers.remove(Preconditions.checkNotNull((Object)observer)));
    }

    @Override
    public synchronized void contentChanged(@NotNull NodeState root, @NotNull CommitInfo info) {
        Preconditions.checkNotNull((Object)root);
        for (Observer observer : this.observers) {
            observer.contentChanged(root, info);
        }
    }

    public synchronized String toString() {
        return this.observers.toString();
    }
}

