/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveTracker {
    private List<MoveEntry> entries = new ArrayList<MoveEntry>();
    private Set<String> parentSourcePaths = new HashSet<String>();
    private Set<String> parentDestPaths = new HashSet<String>();

    public void addMove(@NotNull String sourcePath, @NotNull String destPath) {
        String originalSource = sourcePath;
        for (MoveEntry me : Lists.reverse(this.entries)) {
            if (!Text.isDescendantOrEqual((String)me.destPath, (String)sourcePath)) continue;
            String relPath = PathUtils.relativize((String)me.destPath, (String)sourcePath);
            if (!relPath.isEmpty()) {
                originalSource = me.sourcePath + '/' + relPath;
                break;
            }
            originalSource = me.sourcePath;
            break;
        }
        this.entries.add(new MoveEntry(originalSource, destPath));
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Nullable
    public String getSourcePath(String destPath) {
        for (MoveEntry me : Lists.reverse(this.entries)) {
            if (!me.destPath.equals(destPath)) continue;
            return me.sourcePath;
        }
        return null;
    }

    @Nullable
    public String getDestPath(String sourcePath) {
        for (MoveEntry me : Lists.reverse(this.entries)) {
            if (!me.sourcePath.equals(sourcePath)) continue;
            return me.destPath;
        }
        return null;
    }

    public boolean containsMove(@Nullable String path) {
        if (path != null) {
            for (String p : Iterables.concat(this.parentSourcePaths, this.parentDestPaths)) {
                if (!Text.isDescendantOrEqual((String)path, (String)p)) continue;
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.entries.clear();
        this.parentSourcePaths.clear();
        this.parentDestPaths.clear();
    }

    private final class MoveEntry {
        private final String sourcePath;
        private String destPath;

        private MoveEntry(@NotNull String sourcePath, String destPath) {
            this.sourcePath = sourcePath;
            this.destPath = destPath;
            MoveTracker.this.parentSourcePaths.add(Text.getRelativeParent((String)sourcePath, (int)1));
            MoveTracker.this.parentDestPaths.add(Text.getRelativeParent((String)destPath, (int)1));
        }
    }
}

