/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.filter;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.CollectionUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.jetbrains.annotations.NotNull;

public class PathFilter {
    private static final Set<String> INCLUDE_ROOT = Set.of("/");
    public static final String PROP_INCLUDED_PATHS = "includedPaths";
    public static final String PROP_EXCLUDED_PATHS = "excludedPaths";
    private static final PathFilter ALL = new PathFilter(INCLUDE_ROOT, (Iterable)List.of()){

        @Override
        public Result filter(@NotNull String path) {
            return Result.INCLUDE;
        }
    };
    private final String[] includedPaths;
    private final String[] excludedPaths;

    public static PathFilter from(@NotNull NodeBuilder defn) {
        if (!defn.hasProperty(PROP_EXCLUDED_PATHS) && !defn.hasProperty(PROP_INCLUDED_PATHS)) {
            return ALL;
        }
        return new PathFilter(PathFilter.getStrings(defn.getProperty(PROP_INCLUDED_PATHS), INCLUDE_ROOT), PathFilter.getStrings(defn.getProperty(PROP_EXCLUDED_PATHS), Set.of()));
    }

    public static Iterable<String> getStrings(PropertyState ps, Set<String> defaultValues) {
        if (ps != null && (ps.getType() == Type.STRING || ps.getType() == Type.STRINGS)) {
            return (Iterable)ps.getValue(Type.STRINGS);
        }
        return defaultValues;
    }

    public PathFilter(Iterable<String> includes, Iterable<String> excludes) {
        Set includeCopy = CollectionUtils.toSet(includes);
        Set excludeCopy = CollectionUtils.toSet(excludes);
        PathUtils.unifyInExcludes((Set)includeCopy, (Set)excludeCopy);
        Validate.checkState((!includeCopy.isEmpty() ? 1 : 0) != 0, (String)"No valid include provided. Includes %s, Excludes %s", (Object[])new Object[]{includes, excludes});
        this.includedPaths = includeCopy.toArray(new String[0]);
        this.excludedPaths = excludeCopy.toArray(new String[0]);
    }

    public Result filter(@NotNull String path) {
        for (String excludedPath : this.excludedPaths) {
            if (!excludedPath.equals(path) && !PathUtils.isAncestor((String)excludedPath, (String)path)) continue;
            return Result.EXCLUDE;
        }
        for (String includedPath : this.includedPaths) {
            if (!includedPath.equals(path) && !PathUtils.isAncestor((String)includedPath, (String)path)) continue;
            return Result.INCLUDE;
        }
        for (String includedPath : this.includedPaths) {
            if (!PathUtils.isAncestor((String)path, (String)includedPath)) continue;
            return Result.TRAVERSE;
        }
        return Result.EXCLUDE;
    }

    public List<String> getIncludedPaths() {
        return List.of(this.includedPaths);
    }

    public List<String> getExcludedPaths() {
        return List.of(this.excludedPaths);
    }

    public String toString() {
        return "PathFilter{includedPaths=" + Arrays.toString(this.includedPaths) + ", excludedPaths=" + Arrays.toString(this.excludedPaths) + "}";
    }

    public boolean areAllDescendantsIncluded(String path) {
        for (String excludedPath : this.excludedPaths) {
            if (!excludedPath.equals(path) && !PathUtils.isAncestor((String)excludedPath, (String)path) && !PathUtils.isAncestor((String)path, (String)excludedPath)) continue;
            return false;
        }
        for (String includedPath : this.includedPaths) {
            if (!includedPath.equals(path) && !PathUtils.isAncestor((String)includedPath, (String)path)) continue;
            return true;
        }
        return false;
    }

    public static enum Result {
        INCLUDE,
        EXCLUDE,
        TRAVERSE;

    }
}

