/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.SinglePropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;

public class DecimalPropertyState
extends SinglePropertyState<BigDecimal> {
    private final BigDecimal value;

    public DecimalPropertyState(@Nonnull String name, @Nonnull BigDecimal value) {
        super(name);
        this.value = (BigDecimal)Preconditions.checkNotNull((Object)value);
    }

    public static PropertyState decimalProperty(@Nonnull String name, @Nonnull BigDecimal value) {
        return new DecimalPropertyState(name, value);
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public Conversions.Converter getConverter() {
        return Conversions.convert(this.value);
    }

    public Type<?> getType() {
        return Type.DECIMAL;
    }
}

