/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.util.ISO8601;

public class PropertyStateValue
implements PropertyValue {
    private final PropertyState ps;

    PropertyStateValue(PropertyState ps) {
        this.ps = ps;
    }

    public boolean isArray() {
        return this.ps.isArray();
    }

    @Nonnull
    public Type<?> getType() {
        return this.ps.getType();
    }

    @Nonnull
    public <T> T getValue(Type<T> type) {
        return (T)this.ps.getValue(type);
    }

    @Nonnull
    public <T> T getValue(Type<T> type, int index) {
        return (T)this.ps.getValue(type, index);
    }

    public long size() {
        return this.ps.size();
    }

    public long size(int index) {
        return this.ps.size(index);
    }

    public int count() {
        return this.ps.count();
    }

    @CheckForNull
    public PropertyState unwrap() {
        return this.ps;
    }

    public int compareTo(@Nonnull PropertyValue p2) {
        if (this.getType().tag() != p2.getType().tag()) {
            return Integer.signum(p2.getType().tag() - this.getType().tag());
        }
        switch (this.getType().tag()) {
            case 6: {
                return PropertyStateValue.compare((Iterable)this.getValue(Type.BOOLEANS), (Iterable)p2.getValue(Type.BOOLEANS));
            }
            case 12: {
                return PropertyStateValue.compare((Iterable)this.getValue(Type.DECIMALS), (Iterable)p2.getValue(Type.DECIMALS));
            }
            case 4: {
                return PropertyStateValue.compare((Iterable)this.getValue(Type.DOUBLES), (Iterable)p2.getValue(Type.DOUBLES));
            }
            case 3: {
                return PropertyStateValue.compare((Iterable)this.getValue(Type.LONGS), (Iterable)p2.getValue(Type.LONGS));
            }
            case 2: {
                return PropertyStateValue.compareBinaries((Iterable)this.getValue(Type.BINARIES), (Iterable)p2.getValue(Type.BINARIES));
            }
            case 5: {
                return PropertyStateValue.compareAsDate((Iterable)this.getValue(Type.STRINGS), (Iterable)p2.getValue(Type.STRINGS));
            }
        }
        return PropertyStateValue.compare((Iterable)this.getValue(Type.STRINGS), (Iterable)p2.getValue(Type.STRINGS));
    }

    private static <T extends Comparable<T>> int compare(Iterable<T> p1, Iterable<T> p2) {
        Iterator<T> i1 = p1.iterator();
        Iterator<T> i2 = p2.iterator();
        while (i1.hasNext() || i2.hasNext()) {
            if (!i1.hasNext()) {
                return 1;
            }
            if (!i2.hasNext()) {
                return -1;
            }
            int compare = ((Comparable)i1.next()).compareTo(i2.next());
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int compareBinaries(Iterable<Blob> p1, Iterable<Blob> p2) {
        Iterator<Blob> i1 = p1.iterator();
        Iterator<Blob> i2 = p2.iterator();
        while (true) {
            if (!i1.hasNext()) {
                if (!i2.hasNext()) return 0;
            }
            if (!i1.hasNext()) {
                return 1;
            }
            if (!i2.hasNext()) {
                return -1;
            }
            try (InputStream v1 = i1.next().getNewStream();
                 InputStream v2 = i2.next().getNewStream();){
                int b1;
                do {
                    int b2;
                    int compare;
                    if ((compare = (b1 = v1.read()) - (b2 = v2.read())) == 0) continue;
                    int n = compare;
                    return n;
                } while (b1 != -1);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to compare stream values", e);
            }
        }
    }

    private static int compareAsDate(Iterable<String> p1, Iterable<String> p2) {
        int plus = 43;
        int minus = 45;
        Iterator<String> i1 = p1.iterator();
        Iterator<String> i2 = p2.iterator();
        while (i1.hasNext() || i2.hasNext()) {
            String tz2;
            String tz1;
            if (!i1.hasNext()) {
                return 1;
            }
            if (!i2.hasNext()) {
                return -1;
            }
            String v1 = i1.next();
            String v2 = i2.next();
            char v1sign = v1.charAt(0);
            char v2sign = v2.charAt(0);
            boolean processStringLiterals = false;
            if (v1sign != '+' && v1sign != '-' && v2sign != '+' && v2sign != '-' && (tz1 = v1.substring(23)).equals(tz2 = v2.substring(23))) {
                processStringLiterals = true;
            }
            if (processStringLiterals) {
                return v1.compareTo(v2);
            }
            Calendar c1 = ISO8601.parse((String)v1);
            Calendar c2 = ISO8601.parse((String)v2);
            int compare = -1;
            compare = c1 != null && c2 != null ? c1.compareTo(c2) : v1.compareTo(v2);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private String getInternalString() {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = ((Iterable)this.getValue(Type.STRINGS)).iterator();
        while (iterator.hasNext()) {
            sb.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.getType().tag() ^ this.getInternalString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PropertyStateValue) {
            return this.compareTo((PropertyStateValue)o) == 0;
        }
        return false;
    }

    public String toString() {
        return this.getInternalString();
    }
}

