/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.FilterSet;
import org.apache.jackrabbit.vault.fs.api.PathFilter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.apache.jackrabbit.vault.packaging.PackageInfo;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.util.Text;
import org.apache.jackrabbit.vault.validation.ValidationViolation;
import org.apache.jackrabbit.vault.validation.impl.util.ValidationMessageErrorHandler;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.FilterValidator;
import org.apache.jackrabbit.vault.validation.spi.GenericMetaInfDataValidator;
import org.apache.jackrabbit.vault.validation.spi.JcrPathValidator;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class AdvancedFilterValidator
implements GenericMetaInfDataValidator,
FilterValidator,
DocumentViewXmlValidator,
JcrPathValidator {
    protected static final String MESSAGE_ORPHANED_FILTER_ENTRIES = "Found orphaned filter entries: %s";
    protected static final String MESSAGE_INVALID_PATTERN = "Invalid pattern given ('%s') which will never match for any descendants of the root path '%s'.";
    protected static final String MESSAGE_ROOT_PATH_NOT_ABSOLUTE = "Root path must be absolute, but does not start with a '/': '%s'.";
    protected static final String MESSAGE_INVALID_FILTER_XML = "Invalid filter.xml";
    protected static final String MESSAGE_FILTER_ROOT_ANCESTOR_COVERED_BUT_EXCLUDED = "Filter root's ancestor '%s' is covered by dependency '%s' but excluded by its patterns.";
    protected static final String MESSAGE_FILTER_ROOT_ANCESTOR_UNCOVERED = "Filter root's ancestor '%s' is not covered by any of the specified dependencies nor a valid root.";
    protected static final String MESSAGE_NODE_NOT_CONTAINED = "Node '%s' is not contained in any of the filter rules";
    protected static final String MESSAGE_ANCESTOR_NODE_NOT_COVERED = "Ancestor node '%s' is not covered by any of the filter rules. Preferably depend on a package that provides this node or include it in the filter rules!";
    protected static final String MESSAGE_ANCESTOR_NODE_NOT_COVERED_BUT_VALID_ROOT = "Ancestor node '%s' is not covered by any of the filter rules but that node is a given root (either by a dependency or by the known roots). Remove that node!";
    protected static final String MESSAGE_NODE_BELOW_CLEANUP_FILTER = "Node '%s' is covered by a 'cleanup' filter rule. That filter type is only supposed to be used for removing nodes during import!";
    static final Path FILTER_XML_PATH = Paths.get("vault", "filter.xml");
    private final boolean isSubPackage;
    private final Collection<String> validRoots;
    @NotNull
    private final ValidationMessageSeverity defaultSeverity;
    @NotNull
    private final ValidationMessageSeverity severityForUncoveredAncestorNode;
    @NotNull
    private final ValidationMessageSeverity severityForUncoveredFilterRootAncestors;
    @NotNull
    private final ValidationMessageSeverity severityForOrphanedFilterEntries;
    private final Collection<PackageInfo> dependenciesMetaInfo;
    private final WorkspaceFilter filter;
    private Map<String, FilterValidator> filterValidators;
    private final Collection<String> danglingNodePaths;
    private final Map<PathFilterSet, List<FilterSet.Entry<PathFilter>>> orphanedFilterSets;

    public AdvancedFilterValidator(@NotNull ValidationMessageSeverity defaultSeverity, @NotNull ValidationMessageSeverity severityForUncoveredAncestorNodes, @NotNull ValidationMessageSeverity severityForUncoveredFilterRootAncestors, @NotNull ValidationMessageSeverity severityForOrphanedFilterEntries, boolean isSubPackage, @NotNull Collection<PackageInfo> dependenciesMetaInfo, @NotNull WorkspaceFilter filter, @NotNull Collection<String> validRoots) {
        this.isSubPackage = isSubPackage;
        this.filterValidators = new HashMap<String, FilterValidator>();
        this.defaultSeverity = defaultSeverity;
        this.severityForUncoveredAncestorNode = severityForUncoveredAncestorNodes;
        this.severityForUncoveredFilterRootAncestors = severityForUncoveredFilterRootAncestors;
        this.severityForOrphanedFilterEntries = severityForOrphanedFilterEntries;
        this.dependenciesMetaInfo = dependenciesMetaInfo;
        this.filter = filter;
        this.validRoots = validRoots;
        this.danglingNodePaths = new LinkedList<String>();
        for (PackageInfo dependencyInfo : dependenciesMetaInfo) {
            for (PathFilterSet set : dependencyInfo.getFilter().getFilterSets()) {
                String root = set.getRoot();
                validRoots.add(root);
            }
        }
        this.orphanedFilterSets = new LinkedHashMap<PathFilterSet, List<FilterSet.Entry<PathFilter>>>();
        if (!isSubPackage) {
            for (PathFilterSet pathFilter : filter.getFilterSets()) {
                if ("cleanup".equals(pathFilter.getType())) continue;
                List entries = pathFilter.getEntries().stream().filter(FilterSet.Entry::isInclude).collect(Collectors.toList());
                this.orphanedFilterSets.put(pathFilter, entries);
            }
        }
    }

    public void setFilterValidators(Map<String, FilterValidator> filterValidators) {
        this.filterValidators.putAll(filterValidators);
    }

    @Override
    public Collection<ValidationMessage> done() {
        StringBuilder orphanEntries = new StringBuilder();
        for (Map.Entry<PathFilterSet, List<FilterSet.Entry<PathFilter>>> entry : this.orphanedFilterSets.entrySet()) {
            if (orphanEntries.length() > 0) {
                orphanEntries.append(", ");
            }
            if (entry.getValue().isEmpty()) {
                orphanEntries.append("entry with root '").append(entry.getKey().getRoot()).append("'");
                continue;
            }
            orphanEntries.append("includes [");
            StringBuilder includeEntries = new StringBuilder();
            for (FilterSet.Entry<PathFilter> pathFilterEntry : entry.getValue()) {
                if (includeEntries.length() > 0) {
                    includeEntries.append(", ");
                }
                includeEntries.append(((PathFilter)pathFilterEntry.getFilter()).toString());
            }
            orphanEntries.append((CharSequence)includeEntries).append("] below root '").append(entry.getKey().getRoot()).append("'");
        }
        if (orphanEntries.length() > 0) {
            return Collections.singleton(new ValidationMessage(this.severityForOrphanedFilterEntries, String.format(MESSAGE_ORPHANED_FILTER_ENTRIES, orphanEntries.toString())));
        }
        return null;
    }

    @Override
    public Collection<ValidationMessage> validate(@NotNull WorkspaceFilter filter) {
        if (this.isSubPackage) {
            return null;
        }
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        messages.addAll(this.validatePathFilterSets(filter.getFilterSets(), true));
        messages.addAll(this.validatePathFilterSets(filter.getPropertyFilterSets(), false));
        LinkedHashSet<String> ancestors = new LinkedHashSet<String>();
        for (PathFilterSet set : filter.getFilterSets()) {
            String root;
            if ("cleanup".equals(set.getType()) || this.validRoots.contains(root = StringUtils.substringBeforeLast((String)set.getRoot(), (String)"/")) || filter.contains(root)) continue;
            ancestors.add(root);
        }
        for (String root : ancestors) {
            String coveringPackageId = null;
            boolean isContained = false;
            for (PackageInfo dependencyInfo : this.dependenciesMetaInfo) {
                WorkspaceFilter dependencyFilter = dependencyInfo.getFilter();
                if (dependencyFilter.contains(root)) {
                    isContained = true;
                }
                if (!dependencyFilter.covers(root)) continue;
                coveringPackageId = dependencyInfo.getId().toString();
            }
            if (isContained) continue;
            String msg = coveringPackageId == null ? String.format(MESSAGE_FILTER_ROOT_ANCESTOR_UNCOVERED, root) : String.format(MESSAGE_FILTER_ROOT_ANCESTOR_COVERED_BUT_EXCLUDED, root, coveringPackageId);
            messages.add(new ValidationMessage(this.severityForUncoveredFilterRootAncestors, msg));
        }
        return messages;
    }

    private Collection<ValidationMessage> validatePathFilterSets(Collection<PathFilterSet> pathFilterSets, boolean checkRoots) {
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        for (PathFilterSet pathFilterSet : pathFilterSets) {
            if (checkRoots && !pathFilterSet.getRoot().startsWith("/")) {
                messages.add(new ValidationMessage(this.defaultSeverity, String.format(MESSAGE_ROOT_PATH_NOT_ABSOLUTE, pathFilterSet.getRoot())));
            }
            for (FilterSet.Entry pathFilterEntry : pathFilterSet.getEntries()) {
                if (!(pathFilterEntry.getFilter() instanceof DefaultPathFilter)) {
                    throw new IllegalStateException("Unexpected path filter found: " + pathFilterEntry.getFilter() + ". Must be of type DefaultPathFilter!");
                }
                DefaultPathFilter defaultPathFilter = (DefaultPathFilter)DefaultPathFilter.class.cast(pathFilterEntry.getFilter());
                defaultPathFilter.getPattern();
                if (AdvancedFilterValidator.isRegexValidForRootPath(defaultPathFilter.getPattern(), pathFilterSet.getRoot())) continue;
                messages.add(new ValidationMessage(this.defaultSeverity, String.format(MESSAGE_INVALID_PATTERN, defaultPathFilter.getPattern(), pathFilterSet.getRoot())));
            }
        }
        return messages;
    }

    private Collection<ValidationMessage> validateFileNodePath(@NotNull String nodePath) {
        if (this.isSubPackage) {
            return null;
        }
        this.removeFromOrphanedFilterEntries(nodePath);
        if (!this.filter.contains(nodePath)) {
            if (this.filter.isAncestor(nodePath)) {
                if (this.validRoots.contains(nodePath)) {
                    return Collections.singleton(new ValidationMessage(this.severityForUncoveredAncestorNode, String.format(MESSAGE_ANCESTOR_NODE_NOT_COVERED_BUT_VALID_ROOT, nodePath)));
                }
                return Collections.singleton(new ValidationMessage(this.severityForUncoveredAncestorNode, String.format(MESSAGE_ANCESTOR_NODE_NOT_COVERED, nodePath)));
            }
            return Collections.singleton(new ValidationMessage(this.defaultSeverity, String.format(MESSAGE_NODE_NOT_CONTAINED, nodePath)));
        }
        PathFilterSet pathFilterSet = this.filter.getCoveringFilterSet(nodePath);
        if (pathFilterSet != null && "cleanup".equals(pathFilterSet.getType())) {
            return Collections.singleton(new ValidationMessage(this.defaultSeverity, String.format(MESSAGE_NODE_BELOW_CLEANUP_FILTER, nodePath)));
        }
        String danglingNodePath = this.getDanglingAncestorNodePath(nodePath, this.filter);
        if (danglingNodePath != null) {
            return Collections.singleton(new ValidationMessage(this.defaultSeverity, "Ancestor node (" + danglingNodePath + ") of Node '" + nodePath + "' which is contained in a filter include element is not included!"));
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validateJcrPath(@NotNull NodeContext nodeContext, boolean isFolder) {
        if (!isFolder) {
            return this.validateFileNodePath(nodeContext.getNodePath());
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validate(@NotNull DocViewNode node, @NotNull NodeContext nodeContext, boolean isRoot) {
        if (!isRoot) {
            return this.validateFileNodePath(nodeContext.getNodePath());
        }
        return null;
    }

    static boolean isRegexValidForRootPath(String regex, String rootPath) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(rootPath);
        if (matcher.matches()) {
            return true;
        }
        return matcher.hitEnd();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<ValidationMessage> validateMetaInfData(@NotNull InputStream input, @NotNull Path filePath) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try (InputStream xsdInput = this.getClass().getResourceAsStream("/filter.xsd");){
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource schemaFile = new StreamSource(xsdInput);
            Schema schema = schemaFactory.newSchema(schemaFile);
            factory.setSchema(schema);
            LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
            if (xsdInput == null) {
                throw new IllegalStateException("Can not load filter.xsd");
            }
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            ValidationMessageErrorHandler errorHandler = new ValidationMessageErrorHandler(this.defaultSeverity);
            parser.setErrorHandler(errorHandler);
            Document document = parser.parse(input, "");
            messages.addAll(errorHandler.getValidationMessages());
            DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
            try {
                filter.load(document.getDocumentElement());
                for (Map.Entry<String, FilterValidator> entry : this.filterValidators.entrySet()) {
                    messages.add(new ValidationMessage(ValidationMessageSeverity.DEBUG, "Validating with validator " + entry.getKey() + "..."));
                    Collection<ValidationMessage> filterValidatorMessages = entry.getValue().validate((WorkspaceFilter)filter);
                    if (filterValidatorMessages == null) continue;
                    messages.addAll(ValidationViolation.wrapMessages(entry.getKey(), filterValidatorMessages, null, null, null, 0, 0));
                }
            }
            catch (PatternSyntaxException | ConfigurationException e) {
                messages.add(new ValidationMessage(this.defaultSeverity, MESSAGE_INVALID_FILTER_XML, e));
            }
            LinkedList<ValidationMessage> linkedList = messages;
            return linkedList;
        }
        catch (SAXException e) {
            throw new IOException("Could not parse input as xml", e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Could not instantiate DOM parser", e);
        }
    }

    @Override
    public boolean shouldValidateMetaInfData(@NotNull Path filePath) {
        return FILTER_XML_PATH.equals(filePath);
    }

    private void removeFromOrphanedFilterEntries(@NotNull String nodePath) {
        Iterator<Map.Entry<PathFilterSet, List<FilterSet.Entry<PathFilter>>>> iter = this.orphanedFilterSets.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<PathFilterSet, List<FilterSet.Entry<PathFilter>>> orphanedFilterEntry = iter.next();
            if (!orphanedFilterEntry.getKey().contains(nodePath)) continue;
            Iterator<FilterSet.Entry<PathFilter>> includeIterator = orphanedFilterEntry.getValue().iterator();
            while (includeIterator.hasNext()) {
                FilterSet.Entry<PathFilter> includeEntry = includeIterator.next();
                if (!includeEntry.isInclude() || !((PathFilter)includeEntry.getFilter()).matches(nodePath)) continue;
                includeIterator.remove();
            }
            if (!orphanedFilterEntry.getValue().isEmpty()) continue;
            iter.remove();
        }
    }

    @Nullable
    String getDanglingAncestorNodePath(String nodePath, WorkspaceFilter filter) {
        if (this.danglingNodePaths.contains(nodePath)) {
            return null;
        }
        for (PathFilterSet pathFilterSet : filter.getFilterSets()) {
            if (!pathFilterSet.contains(nodePath)) continue;
            String parentNodePath = Text.getRelativeParent((String)nodePath, (int)1);
            if (!nodePath.equals(pathFilterSet.getRoot()) && !parentNodePath.equals(pathFilterSet.getRoot())) {
                return this.getDanglingAncestorNodePath(parentNodePath, filter);
            }
            return null;
        }
        this.danglingNodePaths.add(nodePath);
        return nodePath;
    }
}

