/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.nio.file.Path;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.Validator;
import org.apache.jackrabbit.vault.validation.spi.ValidatorFactory;
import org.apache.jackrabbit.vault.validation.spi.ValidatorSettings;
import org.apache.jackrabbit.vault.validation.spi.impl.OakIndexDefinitionValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OakIndexDefinitionValidatorFactory
implements ValidatorFactory {
    @Override
    @Nullable
    public Validator createValidator(@NotNull ValidationContext context, @NotNull ValidatorSettings settings) {
        Path path = OakIndexDefinitionValidatorFactory.getPathOfNotAllowedIndexDefinition(context);
        if (path != null) {
            return new OakIndexDefinitionValidator(path, settings.getDefaultSeverity());
        }
        return null;
    }

    private static Path getPathOfNotAllowedIndexDefinition(ValidationContext context) {
        if (!OakIndexDefinitionValidatorFactory.areIndexDefinitionsAllowed(context.getProperties())) {
            return context.getPackageRootPath();
        }
        ValidationContext containerContext = context.getContainerValidationContext();
        if (containerContext != null) {
            return OakIndexDefinitionValidatorFactory.getPathOfNotAllowedIndexDefinition(containerContext);
        }
        return null;
    }

    static boolean areIndexDefinitionsAllowed(PackageProperties properties) {
        return "true".equals(properties.getProperty("allowIndexDefinitions"));
    }

    @Override
    public boolean shouldValidateSubpackages() {
        return true;
    }

    @Override
    @NotNull
    public String getId() {
        return "jackrabbit-oakindex";
    }

    @Override
    public int getServiceRanking() {
        return 0;
    }
}

