/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;

public class PrimaryNodeTypeValidator
implements DocumentViewXmlValidator {
    protected static final String MESSAGE_MISSING_PRIMARY_TYPE = "Mandatory jcr:primaryType missing on node '%s'";
    @NotNull
    private final ValidationMessageSeverity severity;
    @NotNull
    private final WorkspaceFilter filter;

    public PrimaryNodeTypeValidator(@NotNull ValidationMessageSeverity severity, @NotNull WorkspaceFilter filter) {
        this.severity = severity;
        this.filter = filter;
    }

    @Override
    public Collection<ValidationMessage> done() {
        return null;
    }

    @Override
    public Collection<ValidationMessage> validate(@NotNull DocViewNode node, @NotNull String nodePath, @NotNull Path filePath, boolean isRoot) {
        if (node.primary == null && this.filter.contains(nodePath) && !node.props.isEmpty()) {
            return Collections.singleton(new ValidationMessage(this.severity, String.format(MESSAGE_MISSING_PRIMARY_TYPE, nodePath)));
        }
        return null;
    }
}

