/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt;

import java.io.IOException;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.CredentialsConfig;
import org.apache.jackrabbit.vault.fs.config.SimpleCredentialsConfig;
import org.apache.jackrabbit.vault.fs.config.VaultAuthConfig;
import org.apache.jackrabbit.vault.vlt.CredentialsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCredentialsStore
implements CredentialsStore {
    protected static Logger log = LoggerFactory.getLogger(ConfigCredentialsStore.class);
    private VaultAuthConfig config = new VaultAuthConfig();
    private Credentials defaultCreds;
    private Credentials credentials;
    private boolean storeEnabled;

    public ConfigCredentialsStore() {
        try {
            this.config.load();
        }
        catch (IOException e) {
            log.error("Error while loading auth configuration: {} ", (Object)e.toString());
        }
        catch (ConfigurationException e) {
            log.error("Error while loading auth configuration: {} ", (Object)e.toString());
        }
    }

    public void setDefaultCredentials(String userPass) {
        this.defaultCreds = ConfigCredentialsStore.fromUserPass(userPass);
    }

    public void setCredentials(String userPass) {
        this.credentials = ConfigCredentialsStore.fromUserPass(userPass);
    }

    private static Credentials fromUserPass(String userPass) {
        if (userPass != null) {
            int idx = userPass.indexOf(58);
            if (idx > 0) {
                return new SimpleCredentials(userPass.substring(0, idx), userPass.substring(idx + 1).toCharArray());
            }
            return new SimpleCredentials(userPass, new char[0]);
        }
        return null;
    }

    public Credentials getCredentials(RepositoryAddress mountpoint) {
        if (this.credentials != null) {
            return this.credentials;
        }
        Credentials creds = this.fetchCredentials(mountpoint);
        return creds == null ? this.defaultCreds : creds;
    }

    private Credentials fetchCredentials(RepositoryAddress mountpoint) {
        VaultAuthConfig.RepositoryConfig cfg = this.config.getRepoConfig(this.getLookupId(mountpoint));
        if (cfg == null) {
            return null;
        }
        return cfg.getCredsConfig().getCredentials();
    }

    private String getLookupId(RepositoryAddress mountpoint) {
        return mountpoint.getSpecificURI() + "/" + mountpoint.getWorkspace();
    }

    @Override
    public void storeCredentials(RepositoryAddress mountpoint, Credentials creds) {
        if (!(creds instanceof SimpleCredentials)) {
            if (creds != null) {
                log.error("Unable to store non-simple credentials of type " + creds.getClass().getName());
            }
            return;
        }
        Credentials currentCreds = this.fetchCredentials(mountpoint);
        if (creds.equals(currentCreds)) {
            return;
        }
        SimpleCredentials simpleCredentials = (SimpleCredentials)creds;
        if (this.storeEnabled || "admin".equals(simpleCredentials.getUserID()) && "admin".equals(new String(simpleCredentials.getPassword()))) {
            VaultAuthConfig.RepositoryConfig cfg = new VaultAuthConfig.RepositoryConfig(this.getLookupId(mountpoint));
            cfg.addCredsConfig((CredentialsConfig)new SimpleCredentialsConfig(simpleCredentials));
            this.config.addRepositoryConfig(cfg);
            try {
                this.config.save();
                log.warn("Credentials for {} updated in {}.", (Object)mountpoint, (Object)this.config.getConfigFile().getPath());
            }
            catch (IOException e) {
                log.error("Error while saving auth configuration: {} ", (Object)e.toString());
            }
        }
    }

    public void setStoreEnabled(boolean storeEnabled) {
        this.storeEnabled = storeEnabled;
    }
}

