/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.vault.vlt.VltDirectory;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.VltFile;
import org.apache.jackrabbit.vault.vlt.meta.VltEntries;
import org.apache.jackrabbit.vault.vlt.meta.VltEntry;

public class FileList {
    private final Map<String, VltFile> files = new TreeMap<String, VltFile>();
    private final VltDirectory dir;
    private final VltEntries entries;
    private final Set<String> globalIgnores;
    private List<Pattern> ignored = new LinkedList<Pattern>();

    public FileList(VltDirectory dir, VltEntries entries) throws VltException {
        this.dir = dir;
        this.entries = entries;
        this.globalIgnores = new HashSet<String>(dir.getContext().getMetaInf().getSettings().getIgnoredNames());
        this.globalIgnores.add(".vltignore");
        this.loadIgnored(dir.getDirectory());
        this.scanDirectory(dir.getDirectory());
        this.scanEntries();
    }

    private void loadIgnored(File directory) throws VltException {
        try {
            File file = new File(directory, ".vltignore");
            if (file.isFile() && file.canRead()) {
                for (Object o : FileUtils.readLines((File)file, (String)"utf-8")) {
                    this.ignored.add(FileList.createPatternFromGlob(o.toString()));
                }
            }
        }
        catch (IOException e) {
            throw new VltException("Unable to load .vltignore file", e);
        }
    }

    private static Pattern createPatternFromGlob(String glob) {
        glob = glob.replace(".", "\\.");
        glob = glob.replace("*", ".*");
        glob = glob.replace("?", ".+");
        return Pattern.compile(glob);
    }

    public boolean isVltIgnored(String name) {
        for (Pattern p : this.ignored) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private void scanEntries() throws VltException {
        for (VltEntry entry : this.entries.entries()) {
            if (this.files.containsKey(entry.getName())) continue;
            VltFile file = new VltFile(this.dir, entry.getName(), entry);
            this.files.put(file.getName(), file);
        }
    }

    private void scanDirectory(File localDir) throws VltException {
        File[] localFiles = localDir.listFiles();
        if (localFiles != null) {
            for (File localFile : localFiles) {
                if (this.isIgnored(localFile)) continue;
                String name = localFile.getName();
                VltEntry entry = this.entries.getEntry(name);
                VltFile file = new VltFile(this.dir, name, entry);
                this.files.put(name, file);
            }
        }
    }

    public boolean isIgnored(File file) {
        String name = file.getName();
        return name.equals(".vlt") || this.globalIgnores.contains(name) || this.isVltIgnored(name);
    }

    public VltFile getFile(String name) {
        return this.files.get(name);
    }

    public boolean hasFile(String name) {
        return this.files.containsKey(name);
    }

    public Collection<VltFile> getFiles() {
        return this.files.values();
    }

    public Set<String> getFileNames() {
        return new HashSet<String>(this.files.keySet());
    }

    public void addFile(VltFile file) {
        this.files.put(file.getName(), file);
    }
}

