/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.spi2dav.ConnectionOptions;
import org.apache.jackrabbit.vault.fs.Mounter;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.VaultFileSystem;
import org.apache.jackrabbit.vault.fs.api.VaultFsConfig;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ExportRoot;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.util.Constants;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.apache.jackrabbit.vault.util.RepositoryProvider;
import org.apache.jackrabbit.vault.vlt.CredentialsStore;
import org.apache.jackrabbit.vault.vlt.FileAction;
import org.apache.jackrabbit.vault.vlt.VltDirectory;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.VltFile;
import org.apache.jackrabbit.vault.vlt.actions.Action;
import org.apache.jackrabbit.vault.vlt.meta.Ignored;
import org.apache.jackrabbit.vault.vlt.meta.MetaDirectory;
import org.apache.jackrabbit.vault.vlt.meta.xml.zip.ZipMetaDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VltContext {
    protected static Logger log = LoggerFactory.getLogger(VltContext.class);
    private final File cwd;
    private final RepositoryProvider repProvider;
    private final CredentialsStore credsProvider;
    private final ExportRoot exportRoot;
    private final ConnectionOptions connectionOptions;
    private Map<RepositoryAddress, VaultFileSystem> fileSystems = new HashMap<RepositoryAddress, VaultFileSystem>();
    private RepositoryAddress mountpoint;
    private boolean verbose;
    private boolean quiet;
    private boolean swallowErrors = true;
    private final PrintStream stdout;
    private String[] defaultFilterRoots = Constants.EMPTY_STRING_ARRAY;
    private String defaultFilter;
    private String fsRoot = "";
    private PathFilter globalIgnored;

    @Deprecated
    public VltContext(File cwd, File localFile, RepositoryProvider repProvider, CredentialsStore credsProvider) throws IOException {
        this(cwd, localFile, repProvider, credsProvider, System.out, null);
    }

    @Deprecated
    public VltContext(File cwd, File localFile, RepositoryProvider repProvider, CredentialsStore credsProvider, PrintStream out) throws IOException {
        this(cwd, localFile, repProvider, credsProvider, out, null);
    }

    public VltContext(File cwd, File localFile, RepositoryProvider repProvider, CredentialsStore credsProvider, PrintStream out, ConnectionOptions connectionOptions) throws IOException {
        if (!cwd.exists()) {
            throw new FileNotFoundException(cwd.getAbsolutePath());
        }
        if (!localFile.exists()) {
            throw new FileNotFoundException(localFile.getAbsolutePath());
        }
        this.stdout = out;
        this.cwd = cwd;
        this.repProvider = repProvider;
        this.credsProvider = credsProvider;
        ExportRoot er = ExportRoot.findRoot((File)localFile);
        if (er == null) {
            er = new ExportRoot(localFile);
        }
        this.exportRoot = er;
        this.connectionOptions = connectionOptions;
    }

    public RepositoryAddress getMountpoint() throws VltException {
        if (this.mountpoint == null) {
            File dir = new File(this.exportRoot.getJcrRoot(), ".vlt");
            MetaDirectory rootMeta = VltContext.createMetaDirectory(dir);
            try {
                String addr = rootMeta.getRepositoryUrl();
                if (addr == null) {
                    throw new VltException("Root directory must provide a repository url file.");
                }
                this.mountpoint = new RepositoryAddress(addr);
            }
            catch (IOException e) {
                throw new VltException("error while reading repository address.", e);
            }
            catch (URISyntaxException e) {
                throw new VltException("Illegal repository address.", e);
            }
        }
        return this.mountpoint;
    }

    public static MetaDirectory createMetaDirectory(File base) throws VltException {
        try {
            return new ZipMetaDir(base);
        }
        catch (IOException e) {
            throw new VltException("Error creating meta directory.", e);
        }
    }

    public String getFsRoot() {
        return this.fsRoot;
    }

    public void setFsRoot(String fsRoot) {
        this.fsRoot = fsRoot == null || fsRoot.equals("/") ? "" : fsRoot;
    }

    public PathFilter getGlobalIgnored() {
        return this.globalIgnored;
    }

    public void setGlobalIgnored(PathFilter globalIgnored) {
        this.globalIgnored = globalIgnored;
    }

    public void setFsRoot(VltDirectory dir) throws VltException {
        String aPath = dir.getAggregatePath();
        if (aPath != null) {
            RepositoryAddress adr = this.getMountpoint().resolve(aPath);
            this.setFsRoot(aPath);
            this.setMountpoint(adr);
        }
    }

    public void setMountpoint(RepositoryAddress addr) throws VltException {
        this.mountpoint = addr;
        File dir = new File(this.exportRoot.getJcrRoot(), ".vlt");
        MetaDirectory rootMeta = VltContext.createMetaDirectory(dir);
        try {
            String url = addr.toString();
            if (this.fsRoot.length() > 0 && url.endsWith(this.fsRoot)) {
                url = url.substring(0, url.length() - this.fsRoot.length());
            }
            rootMeta.setRepositoryUrl(url);
        }
        catch (IOException e) {
            throw new VltException("error while writing repository address.", e);
        }
    }

    public Session login(RepositoryAddress mountpoint) throws RepositoryException {
        Repository rep = this.repProvider.getRepository(mountpoint, this.connectionOptions);
        Credentials creds = this.credsProvider.getCredentials(mountpoint);
        Session s = rep.login(creds);
        this.credsProvider.storeCredentials(mountpoint, creds);
        return s;
    }

    public VaultFileSystem getFileSystem(RepositoryAddress mountpoint) throws VltException {
        VaultFileSystem fs = this.fileSystems.get(mountpoint);
        if (fs == null) {
            try {
                DefaultWorkspaceFilter filter = null;
                VaultFsConfig config = null;
                if (this.exportRoot != null && this.exportRoot.getMetaInf() != null) {
                    filter = (DefaultWorkspaceFilter)this.exportRoot.getMetaInf().getFilter();
                    config = this.exportRoot.getMetaInf().getConfig();
                }
                if (filter == null && this.defaultFilterRoots.length > 0) {
                    filter = new DefaultWorkspaceFilter();
                    for (String root : this.defaultFilterRoots) {
                        filter.add(new PathFilterSet(root));
                    }
                    this.stdout.printf("Created default filter:%n%s", filter.getSourceAsString());
                }
                if (filter == null && this.defaultFilter != null) {
                    filter = new DefaultWorkspaceFilter();
                    try {
                        filter.load(new File(this.defaultFilter));
                    }
                    catch (ConfigurationException e) {
                        throw new VltException("Specified filter is not valid.", e);
                    }
                }
                if (this.exportRoot != null && filter != null) {
                    if (this.globalIgnored == null) {
                        this.globalIgnored = new Ignored(this, this.cwd);
                    }
                    filter.setGlobalIgnored(this.globalIgnored);
                }
                if (filter != null) {
                    filter.setImportMode(ImportMode.REPLACE);
                }
                Repository rep = this.repProvider.getRepository(mountpoint);
                Credentials creds = this.credsProvider.getCredentials(mountpoint);
                fs = Mounter.mount((VaultFsConfig)config, (WorkspaceFilter)filter, (Repository)rep, (Credentials)creds, (RepositoryAddress)mountpoint, (String)this.fsRoot);
                this.credsProvider.storeCredentials(mountpoint, creds);
            }
            catch (RepositoryException e) {
                throw new VltException("Unable to mount filesystem", e);
            }
            catch (IOException e) {
                throw new VltException("Unable to mount filesystem", e);
            }
            this.fileSystems.put(mountpoint, fs);
        }
        return fs;
    }

    public ExportRoot getExportRoot() {
        return this.exportRoot;
    }

    public MetaInf getMetaInf() {
        return this.exportRoot.isValid() ? this.exportRoot.getMetaInf() : null;
    }

    public String[] getDefaultFilterRoots() {
        return this.defaultFilterRoots;
    }

    public void setDefaultFilterRoots(String[] defaultFilterRoots) {
        this.defaultFilterRoots = defaultFilterRoots;
    }

    public String getDefaultFilter() {
        return this.defaultFilter;
    }

    public void setDefaultFilter(String defaultFilter) {
        this.defaultFilter = defaultFilter;
    }

    public void close() {
        for (RepositoryAddress addr : this.fileSystems.keySet()) {
            VaultFileSystem fs = this.fileSystems.get(addr);
            try {
                fs.unmount();
            }
            catch (RepositoryException e) {
                log.warn("Error while unmounting fs.", (Throwable)e);
            }
        }
        this.fileSystems.clear();
    }

    public boolean execute(Action action) throws VltException {
        try {
            action.run(this);
        }
        catch (VltException e) {
            if (this.swallowErrors && e.isUserError()) {
                this.printError(e);
                return false;
            }
            throw e;
        }
        return true;
    }

    public String getCwdRelativePath(String path) {
        return PathUtil.getRelativeFilePath((String)this.cwd.getPath(), (String)path);
    }

    public VltException error(String path, String msg) {
        path = this.getCwdRelativePath(path);
        return new VltException(path, true, msg, null);
    }

    public VltException exception(String path, String msg, Throwable cause) {
        path = this.getCwdRelativePath(path);
        return new VltException(path, false, msg, cause);
    }

    public void printAction(VltFile file, FileAction action) {
        this.printAction(file.getPath(), action, file.getContentType());
    }

    public void printAction(String path, FileAction action, String contentType) {
        if (!this.quiet && (this.verbose || action != FileAction.VOID)) {
            path = this.getCwdRelativePath(path);
            if (action == FileAction.ADDED && contentType != null) {
                this.stdout.printf("%s %s (%s)%n", action.letter, path, contentType);
            } else {
                this.stdout.printf("%s %s%n", action.letter, path);
            }
            this.stdout.flush();
        }
    }

    public void printError(VltException e) {
        this.stdout.println(e.getMessage());
        this.stdout.flush();
    }

    public void printMessage(VltFile file, String msg) {
        if (!this.quiet) {
            String path = this.getCwdRelativePath(file.getPath());
            this.stdout.printf("%s %s%n", path, msg);
            this.stdout.flush();
        }
    }

    public void printMessage(String msg, VltFile file) {
        if (!this.quiet) {
            String path = this.getCwdRelativePath(file.getPath());
            this.stdout.printf("%s %s%n", msg, path);
            this.stdout.flush();
        }
    }

    public void printMessage(String msg) {
        if (!this.quiet) {
            this.stdout.println(msg);
            this.stdout.flush();
        }
    }

    public void printStatus(VltFile file) throws VltException {
        String path = this.getCwdRelativePath(file.getPath());
        VltFile.State state = file.getStatus();
        if (this.quiet && state == VltFile.State.UNKNOWN) {
            return;
        }
        if (this.verbose || state != VltFile.State.CLEAN) {
            if (state == VltFile.State.ADDED && file.getContentType() != null) {
                this.stdout.printf("%s %s (%s)%n", state.letter, path, file.getContentType());
            } else {
                this.stdout.printf("%s %s%n", state.letter, path);
            }
            this.stdout.flush();
        }
    }

    public void printRemoteStatus(VltFile file, FileAction action) throws VltException {
        String path = this.getCwdRelativePath(file.getPath());
        VltFile.State state = file.getStatus();
        if (this.quiet && state == VltFile.State.UNKNOWN && action == FileAction.VOID) {
            return;
        }
        if (this.verbose || state != VltFile.State.CLEAN || action != FileAction.VOID) {
            this.stdout.printf("%s%s %s%n", state.letter, action.letter, path);
            this.stdout.flush();
        }
    }

    public PrintStream getStdout() {
        return this.stdout;
    }

    public File getCwd() {
        return this.cwd;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }
}

