/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.fs.api.VaultFileOutput;
import org.apache.jackrabbit.vault.fs.api.VaultFileSystem;
import org.apache.jackrabbit.vault.fs.api.VaultFsTransaction;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.util.Constants;
import org.apache.jackrabbit.vault.util.FileInputSource;
import org.apache.jackrabbit.vault.util.LineOutputStream;
import org.apache.jackrabbit.vault.vlt.FileAction;
import org.apache.jackrabbit.vault.vlt.FileList;
import org.apache.jackrabbit.vault.vlt.VltContext;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.VltFile;
import org.apache.jackrabbit.vault.vlt.actions.Action;
import org.apache.jackrabbit.vault.vlt.meta.MetaDirectory;
import org.apache.jackrabbit.vault.vlt.meta.VltEntries;
import org.apache.jackrabbit.vault.vlt.meta.VltEntry;

public class VltDirectory {
    public static final String META_DIR_NAME = ".vlt";
    private final VltContext ctx;
    private File dir;
    private MetaDirectory metaDir;
    private VltEntries entries;
    private FileList files;

    public VltDirectory(VltContext ctx, File directory) throws VltException {
        this.ctx = ctx;
        this.dir = directory;
        if (!this.dir.exists()) {
            throw ctx.error(this.dir.getPath(), "no such file or directory.");
        }
        if (!this.dir.isDirectory()) {
            throw ctx.error(this.dir.getPath(), "not a directory.");
        }
        if (this.dir.getName().equals(META_DIR_NAME)) {
            throw ctx.error(this.dir.getPath(), "meta directory not controllable.");
        }
        this.metaDir = VltContext.createMetaDirectory(new File(this.dir, META_DIR_NAME));
        this.init();
    }

    public VltDirectory getParent() throws VltException {
        return new VltDirectory(this.ctx, this.dir.getParentFile());
    }

    public String getAggregatePath() throws VltException {
        VltDirectory parent = this.getParent();
        VltEntries es = parent.getEntries();
        if (es != null) {
            VltEntry e = es.getEntry(this.dir.getName());
            if (e != null) {
                return e.getAggregatePath();
            }
        } else {
            VltEntry e;
            VltEntry vltEntry = e = this.entries == null ? null : this.entries.getEntry(".content.xml");
            if (e != null) {
                return e.getAggregatePath();
            }
        }
        return null;
    }

    public VltContext getContext() {
        return this.ctx;
    }

    public boolean isControlled() {
        return this.entries != null;
    }

    public void assertControlled() throws VltException {
        if (this.entries == null) {
            throw this.ctx.exception(this.dir.getPath(), "Directory is not under vault control.", null);
        }
    }

    private void init() throws VltException {
        this.entries = this.metaDir.getEntries();
        if (this.entries != null) {
            this.files = new FileList(this, this.entries);
        }
    }

    public void close() {
        if (this.dir != null) {
            this.dir = null;
        }
        if (this.metaDir != null) {
            try {
                this.metaDir.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.metaDir = null;
        }
    }

    public void control(String path, String aPath) throws VltException {
        if (!this.metaDir.exists()) {
            try {
                this.metaDir.create(path);
            }
            catch (IOException e) {
                throw this.ctx.exception(path, "Error while creating.", e);
            }
        }
        this.entries = this.metaDir.getEntries();
        if (this.entries == null) {
            throw this.ctx.error(this.metaDir.getFile().getPath(), "No entries found.");
        }
        try {
            this.metaDir.sync();
        }
        catch (IOException e) {
            throw this.ctx.exception(path, "Error while saving.", e);
        }
        this.files = new FileList(this, this.entries);
    }

    public void uncontrol() throws VltException {
        if (this.metaDir.exists()) {
            try {
                this.metaDir.delete();
            }
            catch (IOException e) {
                throw this.ctx.exception(this.getPath(), "Error while deleting meta directory", e);
            }
        }
        this.entries = null;
        this.files = null;
    }

    public MetaDirectory getMetaDirectory() {
        return this.metaDir;
    }

    public File getDirectory() {
        return this.dir;
    }

    public String getPath() {
        return this.dir.getPath();
    }

    public VltEntries getEntries() {
        return this.entries;
    }

    public VaultFile getRemoteDirectory(VltContext ctx) throws VltException {
        this.assertControlled();
        try {
            VaultFileSystem fs = ctx.getFileSystem(ctx.getMountpoint());
            return fs.getFile(this.entries.getPath());
        }
        catch (IOException e) {
            throw new VltException("Unable to get remote directory.", e);
        }
        catch (RepositoryException e) {
            throw new VltException("Unable to get remote directory.", e);
        }
    }

    public void prepareCommit(VaultFsTransaction tx, Collection<String> names, boolean nonRecursive, boolean force) throws VltException {
        this.assertControlled();
        VaultFile remoteDir = this.getRemoteDirectory(this.ctx);
        if (remoteDir == null) {
            throw this.ctx.error(this.getPath(), "Remote directory does not exist.");
        }
        if (names.isEmpty()) {
            for (VltFile file : this.getFiles()) {
                this.prepareCommit(tx, remoteDir, file, nonRecursive, force);
            }
        } else {
            for (String name : names) {
                VltFile file = this.files.getFile(name);
                if (file == null) {
                    throw this.ctx.error(name, "no such file or directory.");
                }
                this.prepareCommit(tx, remoteDir, file, nonRecursive, force);
            }
        }
        this.saveEntries();
    }

    public void updateComitted(String path, String fileName) throws VltException {
        VaultFile remote;
        this.assertControlled();
        VltFile file = this.files().getFile(fileName);
        try {
            VaultFile rd = this.getRemoteDirectory(this.ctx);
            remote = rd == null ? null : rd.getChild(fileName);
        }
        catch (RepositoryException e) {
            throw this.ctx.exception(this.dir.getPath(), "Error while retrieving remote directory.", e);
        }
        if (file == null && remote == null) {
            this.ctx.printAction(this.getPath() + Constants.FS_NATIVE + fileName, FileAction.DELETED, null);
        } else if (file == null) {
            this.update(remote, fileName);
        } else {
            FileAction a = file.commit(remote);
            if (a != FileAction.VOID) {
                this.entries.update(file);
                this.saveEntries();
                this.ctx.printAction(file, a);
            }
        }
    }

    private void update(VaultFile remote, String name) throws VltException {
        VltFile file = new VltFile(this, name, null);
        this.files.addFile(file);
        FileAction action = file.update(remote, false);
        this.entries.update(file);
        this.saveEntries();
        this.ctx.printAction(file, action);
        this.sync();
    }

    private void prepareCommit(VaultFsTransaction tx, VaultFile remoteDir, VltFile file, boolean nonRecursive, boolean force) throws VltException {
        VaultFile remoteFile;
        try {
            remoteFile = remoteDir == null ? null : remoteDir.getChild(file.getName());
        }
        catch (RepositoryException e) {
            throw this.ctx.exception(file.getPath(), "Error while retrieving status", e);
        }
        if (file.status(remoteFile) != FileAction.VOID && !force) {
            throw this.ctx.error(file.getPath(), "Some files need to be updated first. Specify --force to overwrite remote files.");
        }
        try {
            switch (file.getStatus()) {
                case MODIFIED: {
                    FileInputSource fis = new FileInputSource(file.getFile());
                    if (file.isBinary()) {
                        fis.setLineSeparator(LineOutputStream.LS_BINARY);
                    }
                    tx.modify(remoteFile, (VaultInputSource)fis);
                    this.ctx.printMessage("sending....", file);
                    break;
                }
                case DELETED: {
                    tx.delete(remoteFile);
                    this.ctx.printMessage("deleting...", file);
                    break;
                }
                case ADDED: {
                    FileInputSource fis;
                    String path = this.getEntries().getPath();
                    path = path.endsWith("/") ? path + file.getName() : path + "/" + file.getName();
                    if (file.canDescend()) {
                        tx.mkdir(path);
                    } else {
                        fis = new FileInputSource(file.getFile());
                        if (file.isBinary()) {
                            fis.setLineSeparator(LineOutputStream.LS_BINARY);
                        }
                        VaultFileOutput out = tx.add(path, (VaultInputSource)fis);
                        out.setContentType(file.getContentType());
                    }
                    this.ctx.printMessage("adding.....", file);
                    break;
                }
            }
        }
        catch (IOException e) {
            this.ctx.exception(file.getPath(), "Error while preparing commit.", e);
        }
        catch (RepositoryException e) {
            this.ctx.exception(file.getPath(), "Error while preparing commit.", e);
        }
        if (file.canDescend() && !nonRecursive) {
            VltDirectory dir = file.descend();
            if (dir.isControlled()) {
                VaultFile remDir = dir.getRemoteDirectory(this.ctx);
                for (VltFile child : dir.getFiles()) {
                    dir.prepareCommit(tx, remDir, child, nonRecursive, force);
                }
                dir.saveEntries();
            }
            dir.close();
        }
    }

    public Collection<VltFile> getFiles() {
        if (this.files == null) {
            return Collections.emptySet();
        }
        return this.files.getFiles();
    }

    public void apply(Action action, String name, boolean nonRecursive) throws VltException {
        this.apply(action, Arrays.asList(name), nonRecursive);
    }

    public void apply(Action action, Collection<String> names, boolean nonRecursive) throws VltException {
        if (!action.run(this, null)) {
            return;
        }
        if (names.isEmpty()) {
            for (VltFile file : this.getFiles()) {
                this.apply(action, file, nonRecursive);
            }
        } else {
            for (String name : names) {
                VltFile file;
                if (this.ctx.getExportRoot().getJcrRoot().getParentFile().equals(this.dir)) {
                    file = new VltFile(this, name, null);
                } else {
                    this.assertControlled();
                    file = this.files.getFile(name);
                }
                if (file == null) {
                    throw this.ctx.error(name, "no such file or directory.");
                }
                this.apply(action, file, nonRecursive);
            }
        }
    }

    private void apply(Action action, VltFile file, boolean nonRecursive) throws VltException {
        action.run(this, file, null);
        if (this.entries != null) {
            this.entries.update(file);
            this.sync();
        }
        if (file.canDescend() && !nonRecursive) {
            VltDirectory dir = file.descend();
            dir.apply(action, Collections.emptyList(), nonRecursive);
            dir.close();
        }
    }

    public void sync() throws VltException {
        this.saveEntries();
        this.files = new FileList(this, this.entries);
    }

    public void applyWithRemote(Action action, Collection<String> names, boolean nonRecursive) throws VltException {
        this.applyWithRemote(action, this.getRemoteDirectory(this.ctx), names, nonRecursive);
    }

    public void applyWithRemote(Action action, String name, boolean nonRecursive) throws VltException {
        this.applyWithRemote(action, this.getRemoteDirectory(this.ctx), Arrays.asList(name), nonRecursive);
    }

    public void applyWithRemote(Action action, VaultFile remoteDir, Collection<String> names, boolean nonRecursive) throws VltException {
        if (!action.run(this, remoteDir)) {
            return;
        }
        if (names.isEmpty()) {
            HashSet<String> processed = new HashSet<String>();
            if (remoteDir != null && this.files != null) {
                Collection remoteFiles;
                try {
                    remoteFiles = remoteDir.getChildren();
                }
                catch (RepositoryException e) {
                    throw new VltException("Error while retrieving file.", e);
                }
                Iterator e = remoteFiles.iterator();
                while (e.hasNext()) {
                    VaultFile remoteFile = (VaultFile)e.next();
                    String name = remoteFile.getName();
                    processed.add(name);
                    this.applyWithRemote(action, this.files.getFile(name), remoteFile, nonRecursive);
                }
            }
            for (VltFile file : this.getFiles()) {
                if (processed.contains(file.getName())) continue;
                this.applyWithRemote(action, file, null, nonRecursive);
            }
        } else {
            try {
                for (String name : names) {
                    VltFile file = this.files.getFile(name);
                    VaultFile remoteFile = remoteDir.getChild(name);
                    this.applyWithRemote(action, file, remoteFile, nonRecursive);
                }
            }
            catch (RepositoryException e) {
                throw new VltException("Error while retrieving file.", e);
            }
        }
    }

    public void applyWithRemote(Action action, VltFile file, VaultFile remoteFile, boolean nonRecursive) throws VltException {
        VltDirectory dir;
        if (remoteFile == null && file != null && file.canDescend() && !nonRecursive) {
            dir = file.descend();
            dir.applyWithRemote(action, remoteFile, Collections.emptyList(), nonRecursive);
            dir.close();
        }
        action.run(this, file, remoteFile);
        this.saveEntries();
        if (remoteFile != null) {
            if (file == null) {
                file = this.files.getFile(remoteFile.getName());
            }
            if (file != null && file.canDescend() && !nonRecursive) {
                dir = file.descend();
                dir.applyWithRemote(action, remoteFile, Collections.emptyList(), nonRecursive);
                dir.close();
            }
        }
    }

    private void saveEntries() throws VltException {
        try {
            this.metaDir.sync();
        }
        catch (IOException e) {
            throw this.ctx.error(this.getPath(), "Error while saving entries: " + e);
        }
    }

    public FileList files() throws VltException {
        this.assertControlled();
        return this.files;
    }
}

