/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.VaultFileCopy;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.util.LineOutputStream;
import org.apache.jackrabbit.vault.util.MD5;
import org.apache.jackrabbit.vault.util.MimeTypes;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.apache.jackrabbit.vault.util.diff.DiffWriter;
import org.apache.jackrabbit.vault.util.diff.Document;
import org.apache.jackrabbit.vault.util.diff.DocumentDiff;
import org.apache.jackrabbit.vault.util.diff.DocumentDiff3;
import org.apache.jackrabbit.vault.util.diff.DocumentSource;
import org.apache.jackrabbit.vault.util.diff.ElementsFactory;
import org.apache.jackrabbit.vault.util.diff.FileDocumentSource;
import org.apache.jackrabbit.vault.util.diff.Hunk3;
import org.apache.jackrabbit.vault.util.diff.LineElementsFactory;
import org.apache.jackrabbit.vault.vlt.FileAction;
import org.apache.jackrabbit.vault.vlt.VltDirectory;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.meta.MetaFile;
import org.apache.jackrabbit.vault.vlt.meta.MetaFileDocSource;
import org.apache.jackrabbit.vault.vlt.meta.VltEntry;
import org.apache.jackrabbit.vault.vlt.meta.VltEntryInfo;

public class VltFile
implements DocumentSource {
    public static final String PROP_CONTENT_TYPE = "vlt:mime-type";
    private final VltDirectory parent;
    private final File file;
    private final String name;
    private VltEntry entry;

    public VltFile(VltDirectory parent, String name, VltEntry entry) throws VltException {
        this.parent = parent;
        this.name = name;
        this.entry = entry;
        this.file = new File(parent.getDirectory(), name);
    }

    public Properties getProperties() throws VltException {
        VltEntryInfo info;
        String ct;
        Properties props = new Properties();
        if (this.entry != null && (ct = (info = this.entry.work()).getContentType()) != null) {
            props.put(PROP_CONTENT_TYPE, ct);
        }
        return props;
    }

    public String getProperty(String name) throws VltException {
        if (this.entry != null) {
            VltEntryInfo info = this.entry.work();
            if (name.equals(PROP_CONTENT_TYPE)) {
                return info.getContentType();
            }
        }
        return null;
    }

    public void setProperty(String name, String value) throws VltException {
        if (this.entry == null) {
            throw this.error("Can't set property to non controlled file.");
        }
        VltEntryInfo info = this.entry.work();
        if (info == null) {
            throw this.error("Can't set property to non controlled file.");
        }
        if (name.equals(PROP_CONTENT_TYPE)) {
            if (!this.file.isDirectory()) {
                info.setContentType(value);
                this.parent.getContext().printMessage(this, name + "=" + value);
            }
        } else {
            throw this.error("Generic properies not supported, yet");
        }
    }

    public State getStatus() throws VltException {
        State state = State.VOID;
        if (this.entry == null) {
            state = this.file.exists() ? (this.file.equals(this.parent.getContext().getExportRoot().getJcrRoot()) ? State.CLEAN : State.UNKNOWN) : State.VOID;
        } else {
            switch (this.entry.getState()) {
                case CLEAN: {
                    if (this.file.exists()) {
                        if (this.file.isDirectory()) {
                            VltDirectory dir = this.descend();
                            if (dir.isControlled()) {
                                state = State.CLEAN;
                                break;
                            }
                            state = State.OBSTRUCTED;
                            break;
                        }
                        VltEntryInfo work = this.entry.work();
                        VltEntryInfo base = this.entry.base();
                        assert (work != null);
                        assert (base != null);
                        try {
                            work.update(this.file, false);
                        }
                        catch (IOException e) {
                            throw this.exception("Error while calculating status.", e);
                        }
                        state = work.isSame(base) ? State.CLEAN : State.MODIFIED;
                        break;
                    }
                    state = State.MISSING;
                    break;
                }
                case ADDED: {
                    if (this.file.exists()) {
                        state = State.ADDED;
                        break;
                    }
                    state = State.MISSING;
                    break;
                }
                case CONFLICT: {
                    state = State.CONFLICTED;
                    break;
                }
                case DELETED: {
                    state = State.DELETED;
                }
            }
        }
        return state;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public MetaFile getBaseFile(boolean create) throws VltException {
        try {
            return this.parent.getMetaDirectory().getBaseFile(this.name, create);
        }
        catch (IOException e) {
            throw new VltException(this.getPath(), "Error opening base file.", e);
        }
    }

    public String getContentType() {
        VltEntryInfo work;
        if (this.entry != null && !this.file.isDirectory() && (work = this.entry.work()) != null) {
            return work.getContentType();
        }
        return null;
    }

    public boolean isBinary() {
        return MimeTypes.isBinary((String)this.getContentType());
    }

    public MetaFile getTmpFile() throws VltException {
        try {
            return this.parent.getMetaDirectory().getTmpFile(this.name, true);
        }
        catch (IOException e) {
            throw new VltException(this.getPath(), "Error opening tmp file.", e);
        }
    }

    public boolean canDescend() {
        return this.file.isDirectory();
    }

    public VltDirectory descend() throws VltException {
        if (!this.canDescend()) {
            throw new VltException("Cannot descend into non directory.");
        }
        return new VltDirectory(this.parent.getContext(), this.file);
    }

    public VltEntry getEntry() {
        return this.entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff() throws VltException {
        State state = this.getStatus();
        if (this.entry == null || this.entry.isDirectory()) {
            return;
        }
        VltEntryInfo work = this.entry.work();
        VltEntryInfo base = this.entry.base();
        if (work == null || base == null) {
            return;
        }
        switch (state) {
            case ADDED: 
            case CONFLICTED: 
            case DELETED: 
            case MODIFIED: {
                break;
            }
            case IGNORED: 
            case MISSING: 
            case OBSTRUCTED: 
            case REPLACED: 
            case UNKNOWN: 
            case VOID: 
            case CLEAN: {
                return;
            }
        }
        if (MimeTypes.isBinary((String)work.getContentType()) || MimeTypes.isBinary((String)base.getContentType())) {
            PrintStream s = this.parent.getContext().getStdout();
            s.printf("Index: %s%n", this.getName());
            s.println("===================================================================");
            s.println("Cannot display: file marked as binary type.");
            s.printf("vlt:mime-type = %s%n", work.getContentType());
            s.flush();
            return;
        }
        try {
            DocumentDiff diff;
            PrintStream s = this.parent.getContext().getStdout();
            DiffWriter out = new DiffWriter((Writer)new OutputStreamWriter((OutputStream)s, "utf-8"));
            out.write("Index: ");
            out.write(this.getName());
            out.writeNewLine();
            out.write("===================================================================");
            out.writeNewLine();
            Reader r0 = this.getBaseFile(false) == null ? null : this.getBaseFile(false).getReader();
            Document d0 = new Document((DocumentSource)this, (ElementsFactory)LineElementsFactory.create((DocumentSource)this, (Reader)r0, (boolean)false));
            InputStreamReader r1 = this.file.exists() ? new InputStreamReader((InputStream)FileUtils.openInputStream((File)this.file), "utf-8") : null;
            Document d1 = new Document((DocumentSource)this, (ElementsFactory)LineElementsFactory.create((DocumentSource)this, (Reader)r1, (boolean)false));
            try {
                diff = d0.diff(d1);
            }
            finally {
                IOUtils.closeQuietly((Reader)r0);
                IOUtils.closeQuietly((Reader)r1);
            }
            diff.write(out, 3);
            out.flush();
        }
        catch (IOException e) {
            throw this.exception("Error while writing diff.", e);
        }
    }

    public FileAction delete(boolean force) throws VltException {
        State state = this.getStatus();
        switch (state) {
            case ADDED: 
            case CONFLICTED: 
            case MODIFIED: 
            case REPLACED: {
                if (force) break;
                this.parent.getContext().printMessage(this, "has local modification. use --force to delete anyway");
                return FileAction.VOID;
            }
            case DELETED: 
            case MISSING: 
            case CLEAN: {
                break;
            }
            case IGNORED: 
            case OBSTRUCTED: 
            case UNKNOWN: 
            case VOID: {
                if (force) break;
                this.parent.getContext().printMessage(this, "is not under version control. use --force to delete anyway");
                return FileAction.VOID;
            }
        }
        if (this.entry != null && this.entry.delete(this.file)) {
            this.entry = null;
        }
        return FileAction.DELETED;
    }

    public FileAction commit(VaultFile remoteFile) throws VltException {
        if (remoteFile == null) {
            return this.doDelete(false);
        }
        return this.doUpdate(remoteFile, false);
    }

    public boolean revert() throws VltException {
        State state = this.getStatus();
        switch (state) {
            case ADDED: {
                this.doDelete(true);
                this.entry = null;
                return true;
            }
            case CONFLICTED: {
                this.resolved(true);
            }
            case DELETED: 
            case MODIFIED: 
            case MISSING: {
                this.doRevert();
                return true;
            }
        }
        return false;
    }

    public boolean resolved(boolean force) throws VltException {
        if (this.getStatus() != State.CONFLICTED) {
            return false;
        }
        if (!force) {
            boolean mayContainMarker = false;
            try (BufferedReader in = new BufferedReader(new FileReader(this.file));){
                String line;
                while ((line = in.readLine()) != null) {
                    if (!line.startsWith(Hunk3.MARKER_B[0]) && !line.startsWith(Hunk3.MARKER_L[0]) && !line.startsWith(Hunk3.MARKER_R[0]) && !line.startsWith(Hunk3.MARKER_M[0])) continue;
                    mayContainMarker = true;
                    break;
                }
            }
            catch (IOException e) {
                throw this.exception("Error while reading file.", e);
            }
            if (mayContainMarker) {
                throw this.error("File still contains conflict markers. use --force to force resolve.");
            }
        }
        try {
            this.entry.resolved(this.getTmpFile(), this.file, this.getBaseFile(false));
        }
        catch (IOException e) {
            throw this.exception("Error while copying files.", e);
        }
        return true;
    }

    public FileAction update(VaultFile remoteFile, boolean force) throws VltException {
        State state = this.getStatus();
        switch (state) {
            case IGNORED: 
            case OBSTRUCTED: 
            case REPLACED: {
                if (!force || remoteFile == null) {
                    throw this.error("update not possible. file is " + state.name().toLowerCase() + ". Specify --force to overwrite existing files.");
                }
                return this.doUpdate(remoteFile, false);
            }
            case ADDED: {
                if (remoteFile != null) {
                    if (this.mergeableWithRemote(remoteFile) != FileAction.VOID) {
                        throw this.error("Failed to add file: object of the same name already exists.");
                    }
                    return this.doUpdate(remoteFile, false);
                }
                return FileAction.VOID;
            }
            case CLEAN: {
                if (remoteFile == null) {
                    return this.doDelete(false);
                }
                if (this.file.isDirectory()) {
                    return FileAction.VOID;
                }
                return this.doUpdate(remoteFile, false);
            }
            case CONFLICTED: {
                if (remoteFile == null) {
                    try {
                        if (!this.entry.revertConflict(this.file)) {
                            return FileAction.CONFLICTED;
                        }
                    }
                    catch (IOException e) {
                        throw this.exception("Error during update.", e);
                    }
                    return this.doDelete(this.getStatus() != State.CLEAN);
                }
                try {
                    if (!this.entry.revertConflict(this.file)) {
                        return this.doMerge(remoteFile, FileAction.CONFLICTED);
                    }
                    return this.doMerge(remoteFile, FileAction.UPDATED);
                }
                catch (IOException e) {
                    throw this.exception("Error during update.", e);
                }
            }
            case DELETED: {
                if (remoteFile == null) {
                    return this.doDelete(false);
                }
                return this.doUpdate(remoteFile, true);
            }
            case MISSING: {
                if (remoteFile == null) {
                    return this.doDelete(false);
                }
                this.entry = null;
                return this.doUpdate(remoteFile, false);
            }
            case MODIFIED: {
                if (remoteFile == null) {
                    return this.doDelete(true);
                }
                return this.doMerge(remoteFile, FileAction.VOID);
            }
            case UNKNOWN: {
                if (remoteFile == null) {
                    return FileAction.VOID;
                }
                if (this.file.exists() && !force) {
                    throw this.error("Failed to update: object of the same name already exists. Specify --force to overwrite existing files.");
                }
                return this.doUpdate(remoteFile, false);
            }
            case VOID: {
                return this.doUpdate(remoteFile, false);
            }
        }
        throw this.exception("illegal state: " + (Object)((Object)state), null);
    }

    public FileAction status(VaultFile remoteFile) throws VltException {
        State state = this.getStatus();
        switch (state) {
            case IGNORED: 
            case OBSTRUCTED: 
            case REPLACED: {
                return FileAction.CONFLICTED;
            }
            case ADDED: {
                if (remoteFile != null) {
                    return FileAction.CONFLICTED;
                }
                return FileAction.VOID;
            }
            case CLEAN: {
                if (remoteFile == null) {
                    return FileAction.DELETED;
                }
                if (this.file.isDirectory()) {
                    return FileAction.VOID;
                }
                return this.equalsToRemote(remoteFile) ? FileAction.VOID : FileAction.UPDATED;
            }
            case CONFLICTED: {
                return FileAction.CONFLICTED;
            }
            case DELETED: {
                return FileAction.VOID;
            }
            case MISSING: {
                return FileAction.ADDED;
            }
            case MODIFIED: {
                if (remoteFile == null) {
                    return FileAction.DELETED;
                }
                return this.mergeableWithRemote(remoteFile);
            }
            case UNKNOWN: {
                if (remoteFile == null) {
                    return FileAction.VOID;
                }
                return FileAction.UPDATED;
            }
            case VOID: {
                return FileAction.ADDED;
            }
        }
        throw this.exception("illegal state: " + (Object)((Object)state), null);
    }

    public FileAction add(boolean force) throws VltException {
        State state = this.getStatus();
        switch (state) {
            case ADDED: 
            case CONFLICTED: 
            case MODIFIED: 
            case MISSING: 
            case OBSTRUCTED: 
            case REPLACED: 
            case CLEAN: {
                this.parent.getContext().printMessage(this, "is already under version control");
                break;
            }
            case DELETED: {
                this.parent.getContext().printMessage(this, "replace not supported yet");
                break;
            }
            case IGNORED: {
                this.parent.getContext().printMessage(this, "failed to add. is ignored.");
                break;
            }
            case UNKNOWN: 
            case VOID: {
                return this.doAdd(force);
            }
        }
        return FileAction.VOID;
    }

    private FileAction doAdd(boolean force) throws VltException {
        assert (this.entry == null);
        this.entry = this.parent.getEntries().update(this.getName(), null, null);
        VltEntryInfo work = this.entry.create(VltEntryInfo.Type.WORK);
        try {
            work.update(this.file, true);
        }
        catch (IOException e) {
            throw this.exception("Error while adding file", e);
        }
        String contentType = MimeTypes.getMimeType((String)this.file.getName(), (String)"application/octet-stream");
        work.setContentType(contentType);
        this.entry.put(work);
        return FileAction.ADDED;
    }

    private FileAction doDelete(boolean keepFile) throws VltException {
        if (this.file.isDirectory()) {
            VltDirectory dir = new VltDirectory(this.parent.getContext(), this.file);
            dir.uncontrol();
        } else {
            try {
                if (this.getBaseFile(false) != null) {
                    this.getBaseFile(false).delete();
                }
            }
            catch (IOException e) {
                throw new VltException(this.getPath(), "Error while deleting base file.", e);
            }
        }
        if (!keepFile) {
            this.file.delete();
        }
        this.entry = null;
        return FileAction.DELETED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileAction doMerge(VaultFile remoteFile, FileAction action) throws VltException {
        if (remoteFile.isDirectory()) {
            throw this.exception("Error while merging. remote is a directory.", null);
        }
        if (action == FileAction.CONFLICTED) {
            return action;
        }
        MetaFile baseFile = this.getBaseFile(false);
        MetaFile tmpFile = this.getTmpFile();
        VltEntryInfo base = this.entry.base();
        VltEntryInfo work = this.entry.work();
        byte[] lineFeed = MimeTypes.isBinary((String)remoteFile.getContentType()) ? null : LineOutputStream.LS_NATIVE;
        VaultFileCopy copy = null;
        boolean remoteUpdated = true;
        try {
            if (!base.checkModified(remoteFile)) {
                remoteUpdated = false;
            } else {
                File temp = tmpFile.openTempFile();
                copy = VaultFileCopy.copy((VaultFile)remoteFile, (File)temp, (byte[])lineFeed);
                if (copy.getMd5().equals((Object)base.getMd5())) {
                    tmpFile.closeTempFile(tmpFile.length() >= 0L);
                    remoteUpdated = false;
                } else {
                    tmpFile.closeTempFile(false);
                }
            }
        }
        catch (IOException e) {
            throw this.exception("Error while copying files.", e);
        }
        if (!remoteUpdated) {
            if (work.getMd5().equals((Object)base.getMd5())) {
                base.setSize(work.getSize());
                base.setDate(work.getDate());
                return FileAction.VOID;
            }
            if (remoteFile.lastModified() > 0L) {
                return action;
            }
        }
        try {
            DocumentDiff3 diff;
            boolean remoteBT = this.getRemoteBinaryType(remoteFile, copy);
            boolean localBT = MimeTypes.isBinary((String)base.getContentType());
            if (remoteBT || localBT) {
                this.parent.getContext().printMessage(this, "can't merge. binary content");
                this.entry.conflict(this.file, baseFile, tmpFile);
                return FileAction.CONFLICTED;
            }
            Reader r0 = baseFile.getReader();
            Reader r1 = tmpFile.getReader();
            Document baseDoc = new Document(null, (ElementsFactory)LineElementsFactory.create((DocumentSource)new MetaFileDocSource(baseFile), (Reader)r0, (boolean)false));
            Document leftDoc = new Document(null, (ElementsFactory)LineElementsFactory.create((FileDocumentSource)new FileDocumentSource(this.file), (boolean)false, (String)"utf-8"));
            Document rightDoc = new Document(null, (ElementsFactory)LineElementsFactory.create((DocumentSource)new MetaFileDocSource(tmpFile), (Reader)r1, (boolean)false));
            try {
                diff = baseDoc.diff3(leftDoc, rightDoc);
            }
            finally {
                IOUtils.closeQuietly((Reader)r0);
                IOUtils.closeQuietly((Reader)r1);
            }
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)FileUtils.openOutputStream((File)this.file), "utf-8");
            try {
                diff.write(new DiffWriter((Writer)out), false);
            }
            catch (IOException e) {
                IOUtils.closeQuietly((Writer)out);
            }
            if (diff.hasConflicts()) {
                this.entry.conflict(this.file, baseFile, tmpFile);
                action = FileAction.CONFLICTED;
            } else {
                tmpFile.moveTo(baseFile);
                base.update(baseFile, true);
                action = FileAction.MERGED;
            }
            MD5 oldMd5 = work.getMd5();
            work.update(this.file, true);
            if (oldMd5.equals((Object)work.getMd5())) {
                action = FileAction.VOID;
            }
            if (remoteFile.lastModified() == 0L) {
                if (work.getMd5().equals((Object)base.getMd5())) {
                    base.setDate(work.getDate());
                } else {
                    base.setDate(System.currentTimeMillis());
                }
            }
        }
        catch (IOException e) {
            throw this.exception("Error during merge operation.", e);
        }
        return action;
    }

    private boolean getRemoteBinaryType(VaultFile remoteFile, VaultFileCopy copy) {
        boolean remoteBT = MimeTypes.isBinary((String)remoteFile.getContentType());
        if (copy != null && remoteBT != copy.isBinary()) {
            this.parent.getContext().printMessage(this, "Remote Binary type differs from actual data. Content Type: " + remoteFile.getContentType() + " Data is binary: " + copy.isBinary() + ". Using data type.");
            remoteBT = copy.isBinary();
        }
        return remoteBT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileAction mergeableWithRemote(VaultFile remoteFile) throws VltException {
        VaultFileCopy copy;
        if (remoteFile.isDirectory() != this.file.isDirectory()) {
            return FileAction.CONFLICTED;
        }
        if (this.file.isDirectory()) {
            return FileAction.VOID;
        }
        MetaFile tmpFile = this.getTmpFile();
        VltEntryInfo base = this.entry.base();
        byte[] lineFeed = MimeTypes.isBinary((String)remoteFile.getContentType()) ? null : LineOutputStream.LS_NATIVE;
        try {
            File temp = tmpFile.openTempFile();
            copy = VaultFileCopy.copy((VaultFile)remoteFile, (File)temp, (byte[])lineFeed);
            if (base == null) {
                tmpFile.closeTempFile(true);
                VltEntryInfo work = this.entry.work();
                if (copy.getMd5().equals((Object)work.getMd5())) {
                    return FileAction.VOID;
                }
                return FileAction.CONFLICTED;
            }
            if (copy.getMd5().equals((Object)base.getMd5())) {
                tmpFile.closeTempFile(true);
                return FileAction.VOID;
            }
            tmpFile.closeTempFile(false);
        }
        catch (IOException e) {
            throw this.exception("Error while copying files.", e);
        }
        boolean remoteBT = this.getRemoteBinaryType(remoteFile, copy);
        if (remoteBT || MimeTypes.isBinary((String)base.getContentType())) {
            return FileAction.CONFLICTED;
        }
        try {
            DocumentDiff3 diff;
            MetaFile baseFile = this.getBaseFile(false);
            Reader r0 = baseFile.getReader();
            Reader r1 = tmpFile.getReader();
            Document baseDoc = new Document(null, (ElementsFactory)LineElementsFactory.create((DocumentSource)new MetaFileDocSource(baseFile), (Reader)r0, (boolean)false));
            Document leftDoc = new Document(null, (ElementsFactory)LineElementsFactory.create((FileDocumentSource)new FileDocumentSource(this.file), (boolean)false, (String)"utf-8"));
            Document rightDoc = new Document(null, (ElementsFactory)LineElementsFactory.create((DocumentSource)new MetaFileDocSource(tmpFile), (Reader)r1, (boolean)false));
            try {
                diff = baseDoc.diff3(leftDoc, rightDoc);
            }
            finally {
                IOUtils.closeQuietly((Reader)r0);
                IOUtils.closeQuietly((Reader)r1);
            }
            if (diff.hasConflicts()) {
                return FileAction.CONFLICTED;
            }
            return FileAction.MERGED;
        }
        catch (IOException e) {
            throw this.exception("Error during merge operation.", e);
        }
    }

    private void doRevert() throws VltException {
        if (this.entry.isDirectory()) {
            this.file.mkdir();
        } else {
            try {
                this.getBaseFile(false).copyTo(this.getFile(), true);
            }
            catch (IOException e) {
                throw this.exception("Error while copying files.", e);
            }
        }
        VltEntryInfo base = this.entry.base();
        this.entry.put(base.copyAs(VltEntryInfo.Type.WORK));
    }

    private boolean equalsToRemote(VaultFile remoteFile) throws VltException {
        VaultFileCopy copy;
        MetaFile tmpFile = this.getTmpFile();
        byte[] lineFeed = MimeTypes.isBinary((String)remoteFile.getContentType()) ? null : LineOutputStream.LS_NATIVE;
        File temp = null;
        try {
            temp = tmpFile.openTempFile();
            copy = VaultFileCopy.copy((VaultFile)remoteFile, (File)temp, (byte[])lineFeed);
        }
        catch (IOException e) {
            throw this.exception("Error while copying files.", e);
        }
        finally {
            if (tmpFile != null) {
                try {
                    tmpFile.closeTempFile(true);
                }
                catch (IOException iOException) {}
            }
        }
        VltEntryInfo base = this.entry.base();
        return copy.getMd5().equals((Object)base.getMd5());
    }

    private FileAction doUpdate(VaultFile remoteFile, boolean baseOnly) throws VltException {
        VltEntryInfo base;
        FileAction action;
        if (this.entry == null || this.entry.base() == null) {
            action = FileAction.ADDED;
            this.entry = this.parent.getEntries().update(this.getName(), remoteFile.getAggregatePath(), remoteFile.getRepoRelPath());
            base = this.entry.create(VltEntryInfo.Type.BASE);
            this.entry.put(base);
        } else {
            action = FileAction.UPDATED;
            base = this.entry.base();
            if (!base.checkModified(remoteFile)) {
                return FileAction.VOID;
            }
        }
        long lastMod = remoteFile.lastModified();
        if (lastMod == 0L) {
            lastMod = System.currentTimeMillis();
        }
        base.setDate(lastMod);
        if (remoteFile.isDirectory()) {
            if (!baseOnly) {
                if (this.entry.work() != null) {
                    action = FileAction.VOID;
                } else {
                    this.entry.put(base.copyAs(VltEntryInfo.Type.WORK));
                }
                this.file.mkdir();
                this.file.setLastModified(base.getDate());
                VltDirectory dir = new VltDirectory(this.parent.getContext(), this.file);
                if (!dir.isControlled()) {
                    dir.control(remoteFile.getPath(), remoteFile.getControllingAggregate().getPath());
                    action = FileAction.ADDED;
                }
            }
        } else {
            VaultFileCopy copy;
            MetaFile baseFile = this.getBaseFile(true);
            byte[] lineFeed = MimeTypes.isBinary((String)remoteFile.getContentType()) ? null : LineOutputStream.LS_NATIVE;
            try {
                File temp = baseFile.openTempFile();
                copy = VaultFileCopy.copy((VaultFile)remoteFile, (File)temp, (byte[])lineFeed);
                baseFile.closeTempFile(false);
            }
            catch (IOException e) {
                throw this.exception("Error while copying files.", e);
            }
            if (copy.getMd5().equals((Object)base.getMd5())) {
                action = FileAction.VOID;
            }
            if (!(action != FileAction.VOID || base.getContentType() == null && remoteFile.getContentType() == null || base.getContentType() != null && base.getContentType().equals(remoteFile.getContentType()))) {
                action = FileAction.UPDATED;
            }
            VltEntryInfo work = this.entry.work();
            base.setContentType(remoteFile.getContentType());
            base.setSize(copy.getLength());
            base.setMd5(copy.getMd5());
            if (!(baseOnly || work != null && work.getMd5().equals((Object)copy.getMd5()) && this.getFile().exists())) {
                try {
                    baseFile.copyTo(this.getFile(), true);
                    this.entry.put(base.copyAs(VltEntryInfo.Type.WORK));
                }
                catch (IOException e) {
                    throw this.exception("Error while copying files.", e);
                }
            }
        }
        return action;
    }

    private VltException exception(String msg, Throwable cause) {
        return this.parent.getContext().exception(this.getPath(), msg, cause);
    }

    private VltException error(String msg) {
        return this.parent.getContext().error(this.getPath(), msg);
    }

    public String getLabel() {
        return this.getName();
    }

    public String getLocation() {
        File cwd = this.parent.getContext().getCwd();
        return PathUtil.getRelativeFilePath((String)cwd.getPath(), (String)this.file.getPath());
    }

    public static enum State {
        CLEAN(" "),
        ADDED("A"),
        CONFLICTED("C"),
        DELETED("D"),
        IGNORED("I"),
        MODIFIED("M"),
        REPLACED("R"),
        UNKNOWN("?"),
        MISSING("!"),
        OBSTRUCTED("~"),
        VOID(" ");

        public final String letter;

        private State(String letter) {
            this.letter = letter;
        }

        public String toString() {
            return this.name().toLowerCase() + " (" + this.letter + ")";
        }
    }
}

