/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.actions;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.jackrabbit.vault.vlt.VltContext;
import org.apache.jackrabbit.vault.vlt.VltDirectory;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.actions.AbstractAction;
import org.apache.jackrabbit.vault.vlt.actions.Action;
import org.apache.jackrabbit.vault.vlt.actions.VltTree;
import org.apache.jackrabbit.vault.vlt.meta.Ignored;

public class BaseAction
extends AbstractAction {
    private final File localDir;
    private final List<File> localFiles;
    private final boolean nonRecursive;
    private boolean dirsAsFiles;
    private boolean withRemote;

    public BaseAction(File localDir, List<File> localFiles, boolean nonRecursive) {
        this.localDir = localDir;
        this.localFiles = localFiles == null ? new LinkedList() : localFiles;
        this.nonRecursive = nonRecursive;
    }

    public boolean isWithRemote() {
        return this.withRemote;
    }

    public void setWithRemote(boolean withRemote) {
        this.withRemote = withRemote;
    }

    public void setDirsAsFiles(boolean dirsAsFiles) {
        this.dirsAsFiles = dirsAsFiles;
    }

    public void run(VltContext ctx, VltTree infos) throws VltException {
        if (this.withRemote) {
            for (VltTree.Info i : infos.infos()) {
                i.dir.applyWithRemote((Action)this, i.names, this.nonRecursive);
            }
        } else {
            for (VltTree.Info i : infos.infos()) {
                if (!ctx.getExportRoot().getJcrRoot().getParentFile().equals(i.dir.getDirectory())) {
                    i.dir.assertControlled();
                }
                i.dir.apply((Action)this, i.names, this.nonRecursive);
            }
        }
    }

    @Override
    public void run(VltContext ctx) throws VltException {
        VltTree infos = new VltTree(ctx, this.nonRecursive);
        infos.setDirsAsFiles(this.dirsAsFiles);
        try {
            if (this.localFiles.isEmpty()) {
                infos.add(this.localDir);
            } else {
                infos.addAll(this.localFiles);
            }
        }
        catch (IOException e) {
            throw new VltException("Unable to perform command.", e);
        }
        VltDirectory root = new VltDirectory(ctx, new File(infos.getRootPath()));
        if (root.isControlled()) {
            ctx.setFsRoot(root);
        }
        ctx.setGlobalIgnored(new Ignored(ctx, root.getDirectory()));
        this.run(ctx, infos);
    }
}

