/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.actions;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.apache.jackrabbit.vault.vlt.VltContext;
import org.apache.jackrabbit.vault.vlt.VltDirectory;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.actions.AbstractAction;
import org.apache.jackrabbit.vault.vlt.actions.Action;
import org.apache.jackrabbit.vault.vlt.actions.Update;

public class Checkout
extends AbstractAction {
    private RepositoryAddress mountPoint;
    private String remoteDir;
    private File localDir;
    private boolean force;

    public Checkout(RepositoryAddress mountPoint, String remoteDir, File localDir) {
        this.mountPoint = mountPoint;
        this.remoteDir = remoteDir;
        this.localDir = localDir;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(VltContext ctx) throws VltException {
        if (!this.localDir.exists() && !this.localDir.mkdir()) {
            throw ctx.error(this.localDir.getPath(), "could not create directory");
        }
        if (ctx.getExportRoot().isValid()) {
            String path = ctx.getExportRoot().getJcrRoot().getPath();
            if (!this.force) throw ctx.error(this.localDir.getPath(), "there seems to be already a checkout at " + path + ". Use --force option to overwrite local files with remote.");
            ctx.printMessage("Checkout " + this.mountPoint.resolve(this.remoteDir) + " with local files using root at " + path);
            this.localDir = ctx.getExportRoot().getJcrRoot();
        } else {
            if (this.force) {
                ctx.printMessage("Warning: --force was specified but no prior checkout detected. disabling it.");
                this.force = false;
            }
            try {
                ctx.getExportRoot().create();
                this.localDir = ctx.getExportRoot().getJcrRoot();
            }
            catch (IOException e) {
                throw ctx.exception(this.localDir.getPath(), "Error while creating meta-info", e);
            }
        }
        try {
            VaultFile vaultFile;
            if (this.remoteDir == null) {
                this.remoteDir = "/";
            }
            if (ctx.getDefaultFilter() != null) {
                ((DefaultMetaInf)ctx.getExportRoot().getMetaInf()).setFilter(null);
            }
            if ((vaultFile = ctx.getFileSystem(this.mountPoint).getFile(this.remoteDir)) == null) {
                throw new VltException(this.remoteDir, "Error during checkout. Remote directory does not exit.");
            }
            DefaultMetaInf inf = (DefaultMetaInf)ctx.getMetaInf();
            inf.setConfig(vaultFile.getFileSystem().getConfig());
            inf.setFilter(vaultFile.getFileSystem().getWorkspaceFilter());
            if (!this.force) {
                inf.save(ctx.getExportRoot().getMetaDir());
            }
            if (ctx.isVerbose()) {
                DumpContext dc = new DumpContext(new PrintWriter(ctx.getStdout()));
                dc.println("Filter");
                ctx.getMetaInf().getFilter().dump(dc, true);
                dc.outdent();
                dc.flush();
            }
            String path = PathUtil.getRelativeFilePath((String)ctx.getCwd().getPath(), (String)this.localDir.getPath());
            ctx.printMessage("Checking out " + vaultFile.getPath() + " to " + path);
            VltDirectory dir = new VltDirectory(ctx, this.localDir);
            if (dir.isControlled()) {
                if (!this.force) {
                    throw dir.getContext().error(dir.getPath(), "already under vault control.");
                }
            } else {
                dir.control(vaultFile.getPath(), vaultFile.getAggregate().getPath());
            }
            ctx.setMountpoint(vaultFile.getAggregate().getManager().getMountpoint());
            dir = new VltDirectory(ctx, this.localDir);
            Update up = new Update(this.localDir, null, false);
            up.setOnlyControlled(true);
            up.setForce(this.force);
            dir.applyWithRemote((Action)up, Collections.emptyList(), false);
            ctx.printMessage("Checkout done.");
            return;
        }
        catch (IOException e) {
            throw new VltException(this.localDir.getPath(), "Error during checkout", e);
        }
        catch (RepositoryException e) {
            throw new VltException(this.remoteDir, "Error during checkout", e);
        }
    }
}

