/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.VaultFsTransaction;
import org.apache.jackrabbit.vault.util.PathComparator;
import org.apache.jackrabbit.vault.vlt.FileAction;
import org.apache.jackrabbit.vault.vlt.VltContext;
import org.apache.jackrabbit.vault.vlt.VltDirectory;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.actions.AbstractAction;
import org.apache.jackrabbit.vault.vlt.actions.Action;
import org.apache.jackrabbit.vault.vlt.actions.Update;
import org.apache.jackrabbit.vault.vlt.actions.VltTree;

public class Commit
extends AbstractAction {
    private File localDir;
    private List<File> localFiles;
    private boolean nonRecursive;
    private boolean force;

    public Commit(File localDir, List<File> localFiles, boolean nonRecursive, boolean force) {
        this.localDir = localDir;
        this.localFiles = localFiles;
        this.nonRecursive = nonRecursive;
        this.force = force;
    }

    @Override
    public void run(VltContext ctx) throws VltException {
        ArrayList txInfos;
        VltTree infos = new VltTree(ctx, this.nonRecursive);
        try {
            if (this.localFiles.isEmpty()) {
                infos.add(this.localDir);
            } else {
                infos.setDirsAsFiles(true);
                infos.addAll(this.localFiles);
            }
        }
        catch (IOException e) {
            throw new VltException("Unable to commit changes.", e);
        }
        String localRoot = infos.getRootPath();
        VltDirectory root = new VltDirectory(ctx, new File(localRoot));
        if (root.isControlled()) {
            ctx.setFsRoot(root);
        }
        int rootLen = ctx.getFsRoot().length();
        VaultFsTransaction tx = ctx.getFileSystem(ctx.getMountpoint()).startTransaction();
        ctx.printMessage("Collecting commit information...");
        for (VltTree.Info i : infos.infos()) {
            i.dir.prepareCommit(tx, i.names, this.nonRecursive, this.force);
        }
        ctx.printMessage("Transmitting file data...");
        try {
            txInfos = new ArrayList(tx.commit());
        }
        catch (Exception e) {
            throw new VltException("Error while committing", e);
        }
        Collections.sort(txInfos, new Comparator<VaultFsTransaction.Info>(){
            private final PathComparator pc = new PathComparator();

            @Override
            public int compare(VaultFsTransaction.Info o1, VaultFsTransaction.Info o2) {
                return -this.pc.compare(o1.getPath(), o2.getPath());
            }
        });
        infos.clear();
        for (VaultFsTransaction.Info info : txInfos) {
            if (info.getType() == VaultFsTransaction.Type.ERROR) {
                ctx.printMessage("Could not process " + info.getPath());
                continue;
            }
            String fileName = Text.getName((String)info.getPath());
            String dirPath = Text.getRelativeParent((String)info.getPath(), (int)1);
            if (dirPath.length() > rootLen && !localRoot.endsWith(dirPath)) {
                dirPath = dirPath.substring(rootLen + 1);
            } else if (dirPath.length() < rootLen) {
                dirPath = "";
                fileName = "";
            } else {
                dirPath = "";
            }
            File localDir = new File(localRoot, dirPath);
            if (!localDir.exists()) {
                File file = new File(localDir, fileName);
                ctx.printAction(file.getPath(), FileAction.DELETED, null);
                continue;
            }
            VltDirectory dir = new VltDirectory(ctx, localDir);
            File localFile = new File(localDir, fileName);
            if (localFile.isDirectory()) {
                dir = new VltDirectory(ctx, localFile);
            } else {
                dir.updateComitted(info.getPath(), fileName);
            }
            infos.put(dir);
        }
        Update upd = new Update(this.localDir, null, this.nonRecursive);
        infos.put(root);
        upd.setOnlyControlled(true);
        for (VltTree.Info i : infos.infos()) {
            i.dir.applyWithRemote((Action)upd, Collections.emptyList(), this.nonRecursive);
        }
        ctx.printMessage("done.");
    }
}

