/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.actions;

import java.io.File;
import java.io.PrintStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.vlt.VltDirectory;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.VltFile;
import org.apache.jackrabbit.vault.vlt.actions.BaseAction;
import org.apache.jackrabbit.vault.vlt.meta.VltEntry;
import org.apache.jackrabbit.vault.vlt.meta.VltEntryInfo;

public class Info
extends BaseAction {
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ofPattern("dd MMM yyyy HH:mm:ss");

    public Info(File localDir, List<File> localFiles, boolean nonRecursive) {
        super(localDir, localFiles, nonRecursive);
    }

    @Override
    public void run(VltDirectory dir, VltFile file, VaultFile remoteFile) throws VltException {
        if (file == null) {
            return;
        }
        PrintStream out = dir.getContext().getStdout();
        VltEntry e = file.getEntry();
        out.printf("  Path: %s%n", dir.getContext().getCwdRelativePath(file.getPath()));
        out.printf("Status: %s%n", file.getStatus().name().toLowerCase());
        if (e != null) {
            RepositoryAddress root = dir.getContext().getMountpoint();
            RepositoryAddress addr = root.resolve(e.getAggregatePath());
            addr = addr.resolve(e.getRepoRelPath());
            out.printf("   URL: %s%n", addr.toString());
            Info.print(out, "  Work", e.work());
            Info.print(out, "  Base", e.base());
            Info.print(out, "  Mine", e.mine());
            Info.print(out, "Theirs", e.theirs());
        }
        out.println();
    }

    private static void print(PrintStream out, String name, VltEntryInfo info) {
        if (info == null) {
            return;
        }
        out.printf("%s: %s, %s, %d, %s%n", name, DATE_FMT.format(Instant.ofEpochMilli(info.getDate())), info.getContentType(), info.getSize(), info.getMd5());
    }
}

