/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.actions;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.vlt.VltDirectory;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.VltFile;
import org.apache.jackrabbit.vault.vlt.actions.BaseAction;

public class PropList
extends BaseAction {
    public PropList(File localDir, List<File> localFiles, boolean nonRecursive) {
        super(localDir, localFiles, nonRecursive);
    }

    @Override
    public void run(VltDirectory dir, VltFile file, VaultFile remoteFile) throws VltException {
        if (file == null) {
            return;
        }
        Properties props = file.getProperties();
        if (props.isEmpty()) {
            dir.getContext().printMessage("  (empty properties)");
        } else {
            for (Object name : props.keySet()) {
                String value = (String)props.get(name);
                dir.getContext().printMessage("  " + name + "=" + value);
            }
        }
    }
}

