/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.actions;

import java.io.File;
import java.util.List;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.vlt.FileAction;
import org.apache.jackrabbit.vault.vlt.VltDirectory;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.VltFile;
import org.apache.jackrabbit.vault.vlt.actions.BaseAction;

public class RemoteStatus
extends BaseAction {
    public RemoteStatus(File localDir, List<File> localFiles, boolean nonRecursive) {
        super(localDir, localFiles, nonRecursive);
        this.setWithRemote(true);
    }

    @Override
    public void run(VltDirectory dir, VltFile file, VaultFile remoteFile) throws VltException {
        FileAction action;
        if (remoteFile == null && file == null) {
            return;
        }
        if (file == null) {
            file = new VltFile(dir, remoteFile.getName(), null);
            action = FileAction.ADDED;
        } else {
            action = file.status(remoteFile);
        }
        dir.getContext().printRemoteStatus(file, action);
    }
}

