/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.sync.impl.VaultSyncServiceImpl;
import org.apache.jackrabbit.vault.vlt.VltContext;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.actions.AbstractAction;

public class Sync
extends AbstractAction {
    private static final String[] INSTALL_ROOT = new String[]{"libs", "crx", "vault", "install"};
    private static final String CFG_NODE_NAME = VaultSyncServiceImpl.class.getName();
    private static final String CFG_NODE_PATH = "/libs/crx/vault/config/" + CFG_NODE_NAME;
    private static final String CFG_ROOTS = "vault.sync.syncroots";
    private static final String CFG_ENABLED = "vault.sync.enabled";
    private RepositoryAddress mountPoint;
    private File localDir;
    private final Command cmd;
    private boolean force;

    public Sync(Command cmd, RepositoryAddress mountPoint, File localDir) {
        this.cmd = cmd;
        this.mountPoint = mountPoint;
        this.localDir = localDir;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run(VltContext ctx) throws VltException {
        if (this.mountPoint == null) {
            this.mountPoint = ctx.getMountpoint();
        }
        if (this.mountPoint == null) {
            throw ctx.error(ctx.getCwd().getAbsolutePath(), "No remote specified and not in vlt checkout.");
        }
        Session s = null;
        try {
            s = ctx.login(this.mountPoint);
            switch (this.cmd) {
                case STATUS: 
                case ST: {
                    this.status(ctx, s);
                    return;
                }
                case REGISTER: {
                    this.register(ctx, s, null);
                    return;
                }
                case UNREGISTER: {
                    this.unregister(ctx, s);
                    return;
                }
                case INSTALL: {
                    this.install(ctx, s);
                    return;
                }
                case INIT: {
                    this.init(ctx, s);
                    return;
                }
            }
            return;
        }
        catch (RepositoryException e) {
            throw new VltException("Error while performing command", e);
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    private void init(VltContext ctx, Session s) throws VltException, RepositoryException {
        if (ctx.getExportRoot().isValid()) {
            ctx.getStdout().printf("Starting initialization of sync service in existing vlt checkout %s for %s%n", ctx.getExportRoot().getJcrRoot().getAbsolutePath(), this.mountPoint);
            Config cfg = new Config(s);
            if (!cfg.load(ctx)) {
                this.force = true;
                this.install(ctx, s);
            }
            this.register(ctx, s, true);
            ctx.getStdout().printf("%nThe directory %1$s is now enabled for syncing.%nYou might perform a 'sync-once' by setting the%nappropriate flag in the %1$s/.vlt-sync-config.properties file.%n%n", this.localDir.getAbsolutePath());
        } else {
            ctx.getStdout().printf("Starting initialization of sync service in a non vlt checkout directory %s for %s%n", this.localDir.getAbsolutePath(), this.mountPoint);
            if (this.localDir.listFiles().length > 0) {
                throw new VltException("Aborting initialization since directory is not empty.");
            }
            Config cfg = new Config(s);
            if (!cfg.load(ctx)) {
                this.force = true;
                this.install(ctx, s);
            }
            this.register(ctx, s, true);
            ctx.getStdout().printf("%nThe directory %1$s is now enabled for syncing.%nYou need to configure the filter %1$s/.vlt-sync-filter.xml to setup the%nproper paths. You might also perform a 'sync-once' by setting the%nappropriate flag in the %1$s/.vlt-sync-config.properties file.%n%n", this.localDir.getAbsolutePath());
        }
    }

    private void status(VltContext ctx, Session s) throws RepositoryException {
        Config cfg = new Config(s);
        if (!cfg.load(ctx)) {
            ctx.getStdout().println("No sync-service configured at " + CFG_NODE_PATH);
            return;
        }
        ctx.getStdout().println("Listing sync status for " + this.mountPoint);
        ctx.getStdout().println("- Sync service is " + (cfg.enabled ? "enabled." : "disabled."));
        if (cfg.roots.isEmpty()) {
            ctx.getStdout().println("- No sync directories configured.");
        } else {
            for (String path : cfg.roots) {
                ctx.getStdout().println("- syncing directory: " + path);
            }
        }
    }

    private void register(VltContext ctx, Session s, Boolean enable) throws RepositoryException {
        Config cfg = new Config(s);
        if (!cfg.load(ctx)) {
            ctx.getStdout().println("No sync-service configured at " + CFG_NODE_PATH);
            return;
        }
        for (String path : cfg.roots) {
            try {
                File f = new File(path).getCanonicalFile();
                if (!f.equals(this.localDir)) continue;
                ctx.getStdout().println("Directory is already synced: " + this.localDir.getAbsolutePath());
                return;
            }
            catch (IOException iOException) {
            }
        }
        cfg.roots.add(this.localDir.getAbsolutePath());
        if (enable != null) {
            cfg.enabled = enable;
        }
        cfg.save(ctx);
        ctx.getStdout().println("Added new sync directory: " + this.localDir.getAbsolutePath());
    }

    private void unregister(VltContext ctx, Session s) throws RepositoryException {
        Config cfg = new Config(s);
        if (!cfg.load(ctx)) {
            ctx.getStdout().println("No sync-service configured at " + CFG_NODE_PATH);
            return;
        }
        boolean found = false;
        for (String path : cfg.roots) {
            try {
                File f = new File(path).getCanonicalFile();
                if (!f.equals(this.localDir)) continue;
                found = true;
                break;
            }
            catch (IOException iOException) {
            }
        }
        if (!found) {
            ctx.getStdout().println("Directory is not registered: " + this.localDir.getAbsolutePath());
            return;
        }
        cfg.roots.remove(this.localDir.getAbsolutePath());
        cfg.save(ctx);
        ctx.getStdout().println("Removed sync directory: " + this.localDir.getAbsolutePath());
    }

    private void install(VltContext ctx, Session s) throws RepositoryException, VltException {
        URLClassLoader cl = (URLClassLoader)VaultSyncServiceImpl.class.getClassLoader();
        URL resource = null;
        for (URL url : cl.getURLs()) {
            if (!url.getPath().matches(".*/vault-sync-.*\\.jar")) continue;
            resource = url;
            break;
        }
        if (resource == null) {
            throw new VltException("Unable to find vault-sync.jar library.");
        }
        String jarName = Text.getName((String)resource.getPath());
        ctx.getStdout().println("Preparing to install " + jarName + "...");
        Node root = s.getRootNode();
        for (String name : INSTALL_ROOT) {
            root = JcrUtils.getOrAddFolder((Node)root, (String)name);
        }
        for (Node child : JcrUtils.getChildNodes((Node)root)) {
            if (!child.getName().startsWith("vault-sync-")) continue;
            if (this.force) {
                ctx.getStdout().println("Detected existing bundle: " + child.getName() + ". Updating");
                break;
            }
            ctx.getStdout().println("Detected existing bundle: " + child.getName() + ". Aborting installation. Specify --force to update.");
            return;
        }
        InputStream in = null;
        try {
            in = resource.openStream();
            if (root.hasNode(jarName)) {
                root.getNode(jarName).remove();
            }
            JcrUtils.putFile((Node)root, (String)jarName, (String)"application/octet-stream", (InputStream)in, (Calendar)Calendar.getInstance());
        }
        catch (IOException e) {
            throw new VltException("Error while installing bundle", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        ctx.getStdout().println("Updated bundle: " + jarName);
        root = JcrUtils.getOrAddFolder((Node)root.getParent(), (String)"config");
        if (!root.hasNode(CFG_NODE_NAME)) {
            root.addNode(CFG_NODE_NAME, "sling:OsgiConfig");
            Config cfg = new Config(s);
            cfg.enabled = true;
            cfg.save(ctx);
            ctx.getStdout().println("Created new config at " + CFG_NODE_PATH);
        }
        s.save();
    }

    private static class Config {
        private final Session s;
        private boolean enabled = false;
        private Set<String> roots = new LinkedHashSet<String>();

        private Config(Session s) {
            this.s = s;
        }

        public boolean load(VltContext ctx) throws RepositoryException {
            if (!this.s.nodeExists(CFG_NODE_PATH)) {
                return false;
            }
            Node cfgNode = this.s.getNode(CFG_NODE_PATH);
            if (cfgNode.hasProperty(Sync.CFG_ENABLED)) {
                this.enabled = cfgNode.getProperty(Sync.CFG_ENABLED).getBoolean();
            }
            if (cfgNode.hasProperty(Sync.CFG_ROOTS)) {
                Property roots = cfgNode.getProperty(Sync.CFG_ROOTS);
                for (Value v : roots.getValues()) {
                    this.roots.add(v.getString());
                }
            }
            return true;
        }

        public void save(VltContext ctx) throws RepositoryException {
            Node cfgNode = this.s.getNode(CFG_NODE_PATH);
            cfgNode.setProperty(Sync.CFG_ENABLED, this.enabled);
            Value[] vals = new Value[this.roots.size()];
            int i = 0;
            for (String path : this.roots) {
                vals[i++] = this.s.getValueFactory().createValue(path);
            }
            cfgNode.setProperty(Sync.CFG_ROOTS, vals);
            this.s.save();
        }
    }

    public static enum Command {
        STATUS,
        ST,
        REGISTER,
        UNREGISTER,
        INIT,
        INSTALL;

    }
}

