/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.actions;

import java.io.File;
import java.util.List;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.vlt.FileAction;
import org.apache.jackrabbit.vault.vlt.VltDirectory;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.VltFile;
import org.apache.jackrabbit.vault.vlt.actions.BaseAction;

public class Update
extends BaseAction {
    private boolean force;

    public Update(File localDir, List<File> localFiles, boolean nonRecursive) {
        super(localDir, localFiles, nonRecursive);
        this.setWithRemote(true);
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public void run(VltDirectory dir, VltFile file, VaultFile remoteFile) throws VltException {
        if (file == null) {
            if (remoteFile == null) {
                return;
            }
            file = new VltFile(dir, remoteFile.getName(), null);
        }
        FileAction action = file.update(remoteFile, this.force);
        dir.getEntries().update(file);
        dir.sync();
        dir.getContext().printAction(file, action);
    }
}

