/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.actions;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.vault.util.Constants;
import org.apache.jackrabbit.vault.util.Tree;
import org.apache.jackrabbit.vault.vlt.VltContext;
import org.apache.jackrabbit.vault.vlt.VltDirectory;
import org.apache.jackrabbit.vault.vlt.VltException;

public class VltTree {
    private final VltContext ctx;
    private final boolean nonRecursive;
    private boolean dirsAsFiles;
    private final Tree<Info> infos = new Tree(Constants.FS_NATIVE.charAt(0));

    public VltTree(VltContext ctx, boolean nonRecursive) {
        this.ctx = ctx;
        this.nonRecursive = nonRecursive;
    }

    public String getRootPath() {
        return this.infos.getRootPath();
    }

    public void setDirsAsFiles(boolean dirsAsFiles) {
        this.dirsAsFiles = dirsAsFiles;
    }

    public void clear() {
        this.infos.clear();
    }

    public void add(File file) throws VltException, IOException {
        File dir;
        if (file.isDirectory() && !this.nonRecursive && !this.dirsAsFiles) {
            dir = file;
            file = null;
        } else {
            dir = file.getParentFile();
        }
        String path = dir.getCanonicalPath();
        Info info = (Info)this.infos.get(path);
        if (info == null) {
            info = new Info(new VltDirectory(this.ctx, dir));
            this.infos.put(path, (Object)info);
        }
        if (file != null) {
            info.names.add(file.getName());
        }
    }

    public void addAll(Collection<File> localFiles) throws IOException, VltException {
        for (File file : localFiles) {
            this.add(file);
        }
    }

    public void put(VltDirectory dir) {
        Info di = (Info)this.infos.get(dir.getPath());
        if (di == null) {
            di = new Info(dir);
            this.infos.put(di.path, (Object)di);
        }
    }

    public List<Info> infos() {
        if (!this.nonRecursive) {
            for (Map.Entry e : this.infos.map().entrySet()) {
                if (!((Info)e.getValue()).names.isEmpty()) continue;
                this.infos.removeChildren((String)e.getKey());
            }
        }
        LinkedList<Info> dirs = new LinkedList<Info>();
        dirs.addAll(this.infos.map().values());
        return dirs;
    }

    public static class Info {
        final Set<String> names = new HashSet<String>();
        final VltDirectory dir;
        final String path;
        final String ePath;

        private Info(VltDirectory dir) {
            this.dir = dir;
            this.path = dir.getPath();
            this.ePath = this.path + Constants.FS_NATIVE;
        }

        private void dump(VltContext ctx) {
            ctx.printMessage("dir: " + this.path);
            for (String n : this.names) {
                ctx.printMessage("   ./" + n);
            }
        }
    }
}

