/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.meta;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.PathFilter;
import org.apache.jackrabbit.vault.fs.api.PathMapping;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.VaultSettings;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.jackrabbit.vault.vlt.VltContext;
import org.apache.jackrabbit.vault.vlt.VltDirectory;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ignored
implements PathFilter {
    private static final Logger log = LoggerFactory.getLogger(Ignored.class);
    public static final String FILE_NAME = ".vltignore";
    private final VaultSettings settings;
    private final VltContext ctx;
    private final int rootLength;
    private final File scanRoot;
    private List<PathFilter> ignored;

    public Ignored(VltContext ctx, File scanRoot) {
        this.ctx = ctx;
        this.settings = ctx.getExportRoot().getMetaInf().getSettings();
        this.scanRoot = scanRoot;
        this.rootLength = ctx.getExportRoot().getJcrRoot().getAbsolutePath().length();
    }

    public List<PathFilter> getIgnored() {
        if (this.ignored == null) {
            long now = System.currentTimeMillis();
            this.ignored = new LinkedList<PathFilter>();
            try {
                this.scan(this.scanRoot);
            }
            catch (IOException | ConfigurationException | VltException e) {
                log.error("Error while scanning for .vltignore", e);
            }
            log.info("scanned for .vltignore files below {} in {}ms", (Object)this.scanRoot, (Object)(System.currentTimeMillis() - now));
        }
        return this.ignored;
    }

    public boolean matches(String path) {
        for (PathFilter p : this.getIgnored()) {
            if (!p.matches(path)) continue;
            return true;
        }
        return false;
    }

    public Ignored scan(File dir) throws VltException, IOException, ConfigurationException {
        for (File file : dir.listFiles()) {
            String name = file.getName();
            if (this.settings != null && this.settings.isIgnored(name)) continue;
            if (file.isDirectory()) {
                this.scan(file);
                continue;
            }
            if (!name.equals(FILE_NAME)) continue;
            this.addIgnores(dir, file);
        }
        return this;
    }

    private void addIgnores(File dir, File file) throws VltException, IOException, ConfigurationException {
        VltDirectory d = new VltDirectory(this.ctx, dir);
        String root = d.getAggregatePath();
        if (root == null) {
            root = dir.getAbsolutePath().substring(this.rootLength);
            root = PlatformNameFormat.getRepositoryPath((String)root);
            log.info("Unable to detect correct repository path for {}. guessed: {}", (Object)dir.getPath(), (Object)root);
        }
        for (Object o : FileUtils.readLines((File)file, (String)"utf-8")) {
            this.addIgnored(root, o.toString());
        }
    }

    private void addIgnored(String root, String pattern) throws ConfigurationException {
        if (pattern.startsWith("#")) {
            return;
        }
        root = root.replace('\\', '/');
        StringBuffer reg = new StringBuffer("^");
        reg.append(root).append("/");
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '*') {
                reg.append(".*");
                continue;
            }
            if (c == '?') {
                reg.append(".");
                continue;
            }
            if (c == '.') {
                reg.append("\\.");
                continue;
            }
            reg.append(c);
        }
        reg.append("$");
        log.info("Adding ignored path: {}", (Object)reg.toString());
        this.ignored.add((PathFilter)new DefaultPathFilter(reg.toString()));
    }

    public boolean isAbsolute() {
        return true;
    }

    public void dump(DumpContext ctx, boolean isLast) {
        ctx.printf(isLast, "%s:", new Object[]{this.getClass().getSimpleName()});
        ctx.indent(isLast);
        Iterator<PathFilter> iter = this.getIgnored().iterator();
        while (iter.hasNext()) {
            PathFilter e = iter.next();
            e.dump(ctx, !iter.hasNext());
        }
        ctx.outdent();
    }

    public PathFilter translate(PathMapping mapping) {
        return this;
    }
}

