/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.meta.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.jackrabbit.vault.util.xml.serialize.FormattingXmlStreamWriter;
import org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.VltFile;
import org.apache.jackrabbit.vault.vlt.meta.VltEntries;
import org.apache.jackrabbit.vault.vlt.meta.VltEntry;
import org.apache.jackrabbit.vault.vlt.meta.xml.XmlEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlEntries
implements VltEntries {
    public static final String EN_ENTRIES = "entries";
    public static final String AN_PATH = "path";
    public static final String AN_AGGREGATE_PATH = "aggregatePath";
    private final String path;
    private Map<String, VltEntry> entries = new HashMap<String, VltEntry>();
    private boolean dirty;

    public XmlEntries(String path) {
        this.path = path;
    }

    public XmlEntries(String path, boolean dirty) {
        this.path = path;
        this.dirty = dirty;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public static XmlEntries load(InputStream in) throws VltException {
        InputSource source = new InputSource(in);
        return XmlEntries.load(source);
    }

    public static XmlEntries load(InputSource source) throws VltException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(source);
            Element doc = document.getDocumentElement();
            if (!doc.getNodeName().equals(EN_ENTRIES)) {
                throw new VltException(source.getSystemId(), "<entries> expected.");
            }
            String path = doc.getAttribute(AN_PATH);
            XmlEntries entries = new XmlEntries(path);
            NodeList nodes = doc.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element)) continue;
                Element elem = (Element)node;
                if (elem.getNodeName().equals("entry")) {
                    XmlEntry entry = XmlEntry.load(elem);
                    entries.entries.put(entry.getName(), entry);
                    continue;
                }
                throw new VltException(source.getSystemId(), "<entry> expected in <entries> element.");
            }
            entries.dirty = false;
            return entries;
        }
        catch (ParserConfigurationException e) {
            throw new VltException(source.getSystemId(), "Unable to create configuration XML parser", e);
        }
        catch (SAXException e) {
            throw new VltException(source.getSystemId(), "Configuration file syntax error.", e);
        }
        catch (IOException e) {
            throw new VltException(source.getSystemId(), "Configuration file could not be read.", e);
        }
    }

    public void save(OutputStream out) throws IOException {
        try (FormattingXmlStreamWriter writer = FormattingXmlStreamWriter.create((OutputStream)out, (OutputFormat)new OutputFormat(2, false));){
            this.write((XMLStreamWriter)writer);
        }
        catch (XMLStreamException e) {
            throw new IOException(e.toString());
        }
    }

    private void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument();
        writer.writeStartElement(EN_ENTRIES);
        writer.writeAttribute(AN_PATH, this.path);
        for (VltEntry e : this.entries.values()) {
            ((XmlEntry)e).write(writer);
        }
        writer.writeEndElement();
        writer.writeEndDocument();
        this.dirty = false;
    }

    @Override
    public void update(VltFile file) {
        VltEntry e = file.getEntry();
        if (e == null) {
            this.entries.remove(file.getName());
            this.dirty = true;
        } else {
            this.putEntry(e);
        }
    }

    public void putEntry(VltEntry e) {
        if (this.entries.get(e.getName()) != e) {
            this.dirty = true;
            this.entries.put(e.getName(), e);
        }
    }

    @Override
    public VltEntry getEntry(String localName) {
        return this.entries.get(localName);
    }

    @Override
    public VltEntry update(String localName, String aggregatePath, String repoRelPath) {
        XmlEntry e = new XmlEntry(localName, aggregatePath, repoRelPath);
        VltEntry old = this.entries.remove(localName);
        if (old != null) {
            e.put(old.work());
            e.put(old.base());
            e.put(old.mine());
            e.put(old.theirs());
        }
        this.putEntry(e);
        return e;
    }

    @Override
    public boolean hasEntry(String localName) {
        return this.entries.containsKey(localName);
    }

    @Override
    public Collection<VltEntry> entries() {
        return this.entries.values();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        for (VltEntry e : this.entries.values()) {
            if (!e.isDirty()) continue;
            this.dirty = true;
            return true;
        }
        return false;
    }
}

