/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.meta.xml;

import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.vault.util.MimeTypes;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.meta.MetaFile;
import org.apache.jackrabbit.vault.vlt.meta.VltEntry;
import org.apache.jackrabbit.vault.vlt.meta.VltEntryInfo;
import org.apache.jackrabbit.vault.vlt.meta.xml.XmlEntryInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlEntry
implements VltEntry {
    public static final String CONFLICT_NAME_BASE = ".base";
    public static final String CONFLICT_NAME_MINE = ".mine";
    public static final String CONFLICT_NAME_THEIRS = ".theirs";
    public static final String EN_ENTRY = "entry";
    public static final String AN_NAME = "name";
    public static final String AN_PATH = "rp";
    public static final String AN_AGGREGATE_PATH = "ap";
    private final String name;
    private final String repoRelPath;
    private final String aggregatePath;
    private boolean dirty;
    private Map<VltEntryInfo.Type, VltEntryInfo> infos = new EnumMap<VltEntryInfo.Type, VltEntryInfo>(VltEntryInfo.Type.class);

    protected XmlEntry(String name, String aggPath, String repoRelPath) {
        this.name = name;
        this.aggregatePath = aggPath;
        this.repoRelPath = repoRelPath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRepoRelPath() {
        return this.repoRelPath;
    }

    @Override
    public String getAggregatePath() {
        return this.aggregatePath;
    }

    @Override
    public VltEntryInfo create(VltEntryInfo.Type type) {
        return new XmlEntryInfo(type);
    }

    @Override
    public void put(VltEntryInfo info) {
        if (info != null) {
            this.dirty = true;
            this.infos.put(info.getType(), info);
        }
    }

    @Override
    public VltEntryInfo work() {
        return this.infos.get((Object)VltEntryInfo.Type.WORK);
    }

    @Override
    public VltEntryInfo base() {
        return this.infos.get((Object)VltEntryInfo.Type.BASE);
    }

    @Override
    public VltEntryInfo mine() {
        return this.infos.get((Object)VltEntryInfo.Type.MINE);
    }

    @Override
    public VltEntryInfo theirs() {
        return this.infos.get((Object)VltEntryInfo.Type.THEIRS);
    }

    @Override
    public VltEntryInfo remove(VltEntryInfo.Type type) {
        this.dirty = true;
        return this.infos.remove((Object)type);
    }

    @Override
    public VltEntry.State getState() {
        if (this.infos.containsKey((Object)VltEntryInfo.Type.MINE)) {
            return VltEntry.State.CONFLICT;
        }
        if (!this.infos.containsKey((Object)VltEntryInfo.Type.BASE)) {
            return VltEntry.State.ADDED;
        }
        if (!this.infos.containsKey((Object)VltEntryInfo.Type.WORK)) {
            return VltEntry.State.DELETED;
        }
        return VltEntry.State.CLEAN;
    }

    @Override
    public void resolved(MetaFile fileTmp, File fileWork, MetaFile fileBase) throws IOException {
        XmlEntryInfo mine = (XmlEntryInfo)this.mine();
        XmlEntryInfo base = (XmlEntryInfo)this.base();
        XmlEntryInfo theirs = (XmlEntryInfo)this.theirs();
        XmlEntryInfo work = (XmlEntryInfo)this.work();
        new File(fileWork.getParentFile(), base.getName()).delete();
        new File(fileWork.getParentFile(), mine.getName()).delete();
        new File(fileWork.getParentFile(), theirs.getName()).delete();
        File tmp = fileBase.openTempFile();
        fileTmp.copyTo(tmp, true);
        fileBase.closeTempFile(false);
        base.update(theirs);
        base.setName(null);
        work.update(fileWork, true);
        this.remove(mine.getType());
        this.remove(theirs.getType());
    }

    @Override
    public boolean delete(File fileWork) {
        XmlEntryInfo mine = (XmlEntryInfo)this.mine();
        XmlEntryInfo base = (XmlEntryInfo)this.base();
        XmlEntryInfo theirs = (XmlEntryInfo)this.theirs();
        if (mine != null) {
            new File(fileWork.getParentFile(), mine.getName()).delete();
        }
        if (theirs != null) {
            new File(fileWork.getParentFile(), theirs.getName()).delete();
        }
        if (base != null && base.getName() != null) {
            new File(fileWork.getParentFile(), base.getName()).delete();
        }
        fileWork.delete();
        if (base != null) {
            base.setName(null);
        }
        this.remove(VltEntryInfo.Type.MINE);
        this.remove(VltEntryInfo.Type.THEIRS);
        this.remove(VltEntryInfo.Type.WORK);
        return this.infos.isEmpty();
    }

    @Override
    public boolean revertConflict(File work) throws IOException {
        File dir = work.getParentFile();
        XmlEntryInfo mine = (XmlEntryInfo)this.mine();
        XmlEntryInfo theirs = (XmlEntryInfo)this.theirs();
        XmlEntryInfo base = (XmlEntryInfo)this.base();
        File fileMine = new File(dir, mine.getName());
        if (!fileMine.exists()) {
            return false;
        }
        FileUtils.copyFile((File)fileMine, (File)work);
        fileMine.delete();
        new File(dir, theirs.getName()).delete();
        new File(dir, base.getName()).delete();
        this.remove(mine.getType());
        this.remove(theirs.getType());
        base.setName(null);
        if (mine.getContentType() == null && base.getContentType() == null) {
            VltEntryInfo workInfo = this.work();
            if (workInfo.getContentType() == null) {
                workInfo.setContentType(MimeTypes.getMimeType((String)work.getName()));
            }
            base.setContentType(workInfo.getContentType());
        }
        return true;
    }

    @Override
    public void conflict(File work, MetaFile base, MetaFile tmp) throws IOException {
        File dir = work.getParentFile();
        File fileMine = new File(dir, this.name + CONFLICT_NAME_MINE);
        File fileBase = new File(dir, this.name + CONFLICT_NAME_BASE);
        File fileTheirs = new File(dir, this.name + CONFLICT_NAME_THEIRS);
        FileUtils.copyFile((File)work, (File)fileMine);
        base.copyTo(fileBase, true);
        tmp.copyTo(fileTheirs, true);
        ((XmlEntryInfo)this.base()).setName(fileBase.getName());
        String contentType = this.base().getContentType();
        XmlEntryInfo mine = new XmlEntryInfo(VltEntryInfo.Type.MINE);
        mine.update(fileMine, true);
        mine.setName(fileMine.getName());
        mine.setContentType(contentType);
        this.put(mine);
        XmlEntryInfo theirs = new XmlEntryInfo(VltEntryInfo.Type.THEIRS);
        theirs.update(fileTheirs, true);
        theirs.setName(fileTheirs.getName());
        theirs.setContentType(contentType);
        this.put(theirs);
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(EN_ENTRY);
        writer.writeAttribute(AN_NAME, this.name);
        if (this.repoRelPath != null) {
            writer.writeAttribute(AN_PATH, this.repoRelPath);
        }
        if (this.aggregatePath != null) {
            writer.writeAttribute(AN_AGGREGATE_PATH, this.aggregatePath);
        }
        for (VltEntryInfo info : this.infos.values()) {
            ((XmlEntryInfo)info).write(writer);
        }
        writer.writeEndElement();
        this.dirty = false;
    }

    @Override
    public boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        for (VltEntryInfo info : this.infos.values()) {
            if (!((XmlEntryInfo)info).isDirty()) continue;
            this.dirty = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDirectory() {
        VltEntryInfo base = this.infos.get((Object)VltEntryInfo.Type.BASE);
        if (base != null) {
            return base.isDirectory();
        }
        VltEntryInfo work = this.infos.get((Object)VltEntryInfo.Type.WORK);
        return work != null && work.isDirectory();
    }

    protected static XmlEntry load(Element elem) throws VltException {
        assert (elem.getNodeName().equals(EN_ENTRY));
        String name = elem.getAttribute(AN_NAME);
        if (name == null) {
            throw new VltException("entry has no 'name' attribute");
        }
        String path = elem.hasAttribute(AN_PATH) ? elem.getAttribute(AN_PATH) : null;
        String ap = elem.hasAttribute(AN_AGGREGATE_PATH) ? elem.getAttribute(AN_AGGREGATE_PATH) : null;
        XmlEntry entry = new XmlEntry(name, ap, path);
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            entry.put(XmlEntryInfo.load((Element)node));
        }
        entry.dirty = false;
        return entry;
    }
}

