/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.meta.xml;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.util.MD5;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.meta.MetaFile;
import org.apache.jackrabbit.vault.vlt.meta.VltEntryInfo;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class XmlEntryInfo
implements VltEntryInfo {
    private static final String AN_NAME = "name";
    private static final String AN_DATE = "date";
    private static final String AN_MD5 = "md5";
    private static final String AN_CONTENT_TYPE = "contentType";
    private static final String AN_SIZE = "size";
    private final VltEntryInfo.Type type;
    private String name;
    private long date;
    private MD5 md5;
    private String contentType;
    private long size;
    private boolean dirty;

    public XmlEntryInfo(VltEntryInfo.Type type) {
        this.type = type;
    }

    @Override
    public VltEntryInfo copyAs(VltEntryInfo.Type type) {
        XmlEntryInfo info = new XmlEntryInfo(type);
        info.update(this);
        return info;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name == null && name != null || this.name != null && !this.name.equals(name)) {
            this.name = name;
            this.dirty = true;
        }
    }

    @Override
    public VltEntryInfo.Type getType() {
        return this.type;
    }

    @Override
    public long getDate() {
        return this.date;
    }

    @Override
    public void setDate(long date) {
        if ((date -= date % 1000L) != this.date) {
            this.date = date;
            this.dirty = true;
        }
    }

    @Override
    public MD5 getMd5() {
        return this.md5;
    }

    @Override
    public void setMd5(MD5 md5) {
        if (this.md5 == null && md5 != null || this.md5 != null && !this.md5.equals((Object)md5)) {
            this.md5 = md5;
            this.dirty = true;
        }
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(String contentType) {
        if (this.contentType == null && contentType != null || this.contentType != null && !this.contentType.equals(contentType)) {
            this.contentType = contentType;
            this.dirty = true;
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setSize(long size) {
        if (size != this.size) {
            this.size = size;
            this.dirty = true;
        }
    }

    @Override
    public boolean checkModified(VaultFile remoteFile) {
        long rTime = remoteFile.lastModified();
        rTime -= rTime % 1000L;
        if (this.date <= 0L || rTime <= 0L || rTime > this.date) {
            return true;
        }
        long rSize = remoteFile.length();
        if (rSize < 0L || rSize != this.size) {
            return true;
        }
        String ct = remoteFile.getContentType();
        return ct == null || !ct.equals(this.contentType);
    }

    @Override
    public void update(VltEntryInfo base) {
        this.setName(((XmlEntryInfo)base).getName());
        this.setDate(base.getDate());
        this.setMd5(base.getMd5());
        this.setContentType(base.getContentType());
        this.setSize(base.getSize());
    }

    @Override
    public void update(File file, boolean force) throws IOException {
        if (file.isDirectory()) {
            boolean bl = this.dirty = this.size != 0L && this.md5 != null && this.contentType != null;
            if (this.dirty) {
                this.size = 0L;
                this.md5 = null;
                this.contentType = null;
                this.date = file.lastModified();
            }
        } else if (force || file.lastModified() != this.date || file.length() != this.size) {
            this.size = file.length();
            this.md5 = MD5.digest((File)file);
            this.date = file.lastModified();
            this.dirty = true;
        }
    }

    @Override
    public void update(MetaFile file, boolean force) throws IOException {
        if (force || file.lastModified() > this.date) {
            this.size = file.length();
            this.md5 = file.md5();
            this.date = file.lastModified();
            this.dirty = true;
        }
    }

    @Override
    public boolean isDirectory() {
        return this.size == 0L && this.md5 == null && this.contentType == null;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isSame(VltEntryInfo base) {
        return this.size == base.getSize() && (this.md5 == null && base.getMd5() == null || this.md5 != null && this.md5.equals((Object)base.getMd5()));
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(this.type.name().toLowerCase());
        writer.writeEndElement();
        this.dirty = false;
    }

    protected void addAttributes(AttributesImpl attrs) {
        if (this.name != null) {
            attrs.addAttribute("", AN_NAME, "", "CDATA", this.name);
        }
        if (this.date > 0L) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(this.date);
            attrs.addAttribute("", AN_DATE, "", "CDATA", ISO8601.format((Calendar)c));
        }
        if (this.md5 != null) {
            attrs.addAttribute("", AN_MD5, "", "CDATA", this.md5.toString());
        }
        if (this.contentType != null) {
            attrs.addAttribute("", AN_CONTENT_TYPE, "", "CDATA", this.contentType);
        }
        if (this.size > 0L) {
            attrs.addAttribute("", AN_SIZE, "", "CDATA", String.valueOf(this.size));
        }
    }

    protected static VltEntryInfo load(Element elem) throws VltException {
        VltEntryInfo.Type type;
        try {
            type = VltEntryInfo.Type.valueOf(elem.getNodeName().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new VltException("unknown entry type '" + elem.getNodeName() + "'");
        }
        XmlEntryInfo entry = new XmlEntryInfo(type);
        if (elem.hasAttribute(AN_NAME)) {
            entry.setName(elem.getAttribute(AN_NAME));
        }
        if (elem.hasAttribute(AN_DATE)) {
            entry.setDate(ISO8601.parse((String)elem.getAttribute(AN_DATE)).getTime().getTime());
        }
        if (elem.hasAttribute(AN_MD5)) {
            try {
                entry.setMd5(new MD5(elem.getAttribute(AN_MD5)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (elem.hasAttribute(AN_CONTENT_TYPE)) {
            entry.setContentType(elem.getAttribute(AN_CONTENT_TYPE));
        }
        if (elem.hasAttribute(AN_SIZE)) {
            try {
                entry.setSize(Integer.parseInt(elem.getAttribute(AN_SIZE)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        entry.dirty = false;
        return entry;
    }
}

