/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.meta.xml.file;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.vault.util.FileInputSource;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.meta.MetaDirectory;
import org.apache.jackrabbit.vault.vlt.meta.MetaFile;
import org.apache.jackrabbit.vault.vlt.meta.VltEntries;
import org.apache.jackrabbit.vault.vlt.meta.xml.XmlEntries;
import org.apache.jackrabbit.vault.vlt.meta.xml.file.FileMetaFile;
import org.xml.sax.InputSource;

public class FileMetaDir
implements MetaDirectory {
    public static final String ADDRESS_FILE_NAME = "repository.url";
    public static final String BASE_DIR_NAME = "base";
    public static final String TMP_DIR_NAME = "tmp";
    public static final String ENTRIES_FILE_NAME = "entries.xml";
    private final File dir;
    private final File tmpDir;
    private final File baseDir;
    private final File entriesFile;
    private XmlEntries entries;

    public FileMetaDir(File dir) {
        this.dir = dir;
        this.tmpDir = new File(dir, TMP_DIR_NAME);
        this.baseDir = new File(dir, BASE_DIR_NAME);
        this.entriesFile = new File(dir, ENTRIES_FILE_NAME);
    }

    @Override
    public boolean exists() {
        return this.dir.exists();
    }

    @Override
    public void create(String path) throws IOException {
        if (!this.dir.exists()) {
            this.dir.mkdirs();
            this.entries = new XmlEntries(path, true);
            this.sync();
        }
    }

    @Override
    public void delete() throws IOException {
        FileUtils.deleteDirectory((File)this.dir);
    }

    @Override
    public File getFile() {
        return this.dir;
    }

    @Override
    public String getRepositoryUrl() throws IOException {
        File mpFile = new File(this.dir, ADDRESS_FILE_NAME);
        if (!mpFile.canRead()) {
            return null;
        }
        List lines = FileUtils.readLines((File)mpFile, (String)"utf-8");
        if (lines.isEmpty()) {
            throw new IOException(mpFile.getPath() + " is empty.");
        }
        return (String)lines.get(0);
    }

    @Override
    public void setRepositoryUrl(String url) throws IOException {
        File mpFile = new File(this.dir, ADDRESS_FILE_NAME);
        LinkedList<String> lines = new LinkedList<String>();
        lines.add(url);
        FileUtils.writeLines((File)mpFile, lines, (String)"utf-8");
    }

    @Override
    public VltEntries getEntries() throws VltException {
        if (this.entries == null && this.entriesFile.exists()) {
            this.entries = XmlEntries.load((InputSource)new FileInputSource(this.entriesFile));
        }
        return this.entries;
    }

    @Override
    public MetaFile getFile(String name) throws IOException {
        return this.getFile(name, false);
    }

    @Override
    public MetaFile getFile(String name, boolean create) throws IOException {
        File file = new File(this.dir, name);
        if (file.exists() || create) {
            return new FileMetaFile(this, file);
        }
        return null;
    }

    @Override
    public MetaFile getTmpFile(String name, boolean create) throws IOException {
        File file = new File(this.tmpDir, name);
        if (file.exists() || create) {
            return new FileMetaFile(this, file);
        }
        return null;
    }

    @Override
    public MetaFile getBaseFile(String name, boolean create) throws IOException {
        File file = new File(this.baseDir, name);
        if (file.exists() || create) {
            return new FileMetaFile(this, file);
        }
        return null;
    }

    @Override
    public boolean hasFile(String name) throws IOException {
        File file = new File(this.dir, name);
        return file.exists();
    }

    public void delete(String name) throws IOException {
        File file = new File(this.dir, name);
        FileUtils.forceDelete((File)file);
    }

    @Override
    public void sync() throws IOException {
        if (this.entries != null && this.entries.isDirty()) {
            this.entries.save(FileUtils.openOutputStream((File)this.entriesFile));
        }
    }

    @Override
    public void close() throws IOException {
        this.sync();
    }
}

