/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.meta.xml.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.vault.util.MD5;
import org.apache.jackrabbit.vault.vlt.meta.MetaDirectory;
import org.apache.jackrabbit.vault.vlt.meta.MetaFile;
import org.apache.jackrabbit.vault.vlt.meta.xml.file.FileMetaDir;

public class FileMetaFile
implements MetaFile {
    private final FileMetaDir parent;
    private File file;

    public FileMetaFile(FileMetaDir parent, File file) {
        this.parent = parent;
        this.file = file;
    }

    @Override
    public MetaDirectory getDirectory() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return FileUtils.openInputStream((File)this.file);
    }

    @Override
    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream(), "utf-8");
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public MD5 md5() throws IOException {
        return MD5.digest((File)this.file);
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public void delete() throws IOException {
        FileUtils.forceDelete((File)this.file);
    }

    @Override
    public File openTempFile() throws IOException {
        if (!this.file.exists()) {
            if (!this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdirs();
            }
            this.file.createNewFile();
        }
        return this.file;
    }

    @Override
    public void closeTempFile(boolean discard) throws IOException {
    }

    @Override
    public void moveTo(MetaFile dst) throws IOException {
        FileMetaFile dest = (FileMetaFile)dst;
        FileUtils.copyFile((File)this.file, (File)dest.file, (boolean)true);
        FileUtils.forceDelete((File)this.file);
        this.file = dest.file;
    }

    public void copyTo(MetaFile dst) throws IOException {
        FileMetaFile dest = (FileMetaFile)dst;
        FileUtils.copyFile((File)this.file, (File)dest.file, (boolean)true);
    }

    @Override
    public void copyTo(File dst, boolean preserveFileDate) throws IOException {
        FileUtils.copyFile((File)this.file, (File)dst, (boolean)preserveFileDate);
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }
}

