/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.meta.xml.zip;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateableZipFile {
    private static final Logger log = LoggerFactory.getLogger(UpdateableZipFile.class);
    private final File file;
    private Set<String> toDelete = new HashSet<String>();
    private Map<String, InputStream> toUpdate = new HashMap<String, InputStream>();
    private Map<String, String> toMove = new HashMap<String, String>();

    public UpdateableZipFile(File file) throws IOException {
        this.file = file;
    }

    public File getZipFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String getPath() {
        return this.file.getPath();
    }

    public void delete() {
        if (this.file.exists()) {
            this.file.delete();
        }
        this.toDelete.clear();
        this.toUpdate.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String name) {
        ZipEntry zipEntry;
        if (!this.file.exists()) {
            return null;
        }
        FileInputStream in = FileUtils.openInputStream((File)this.file);
        ZipInputStream zin = new ZipInputStream(in);
        try {
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                if (entry.getName().equals(name)) {
                    zin.closeEntry();
                    break;
                }
                entry = zin.getNextEntry();
            }
            zipEntry = entry;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)zin);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
            catch (IOException e) {
                log.error("Error while retrieving zip entry {}: {}", (Object)name, (Object)e.toString());
                return null;
            }
        }
        IOUtils.closeQuietly((InputStream)zin);
        IOUtils.closeQuietly((InputStream)in);
        return zipEntry;
    }

    public InputStream getInputStream(String name) throws IOException {
        if (!this.file.exists()) {
            return null;
        }
        ZipInputStream zin = null;
        FileInputStream in = FileUtils.openInputStream((File)this.file);
        try {
            zin = new ZipInputStream(in);
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                if (entry.getName().equals(name)) {
                    return zin;
                }
                entry = zin.getNextEntry();
            }
        }
        catch (IOException e) {
            IOUtils.closeQuietly(zin);
            IOUtils.closeQuietly((InputStream)in);
            throw e;
        }
        IOUtils.closeQuietly((InputStream)zin);
        IOUtils.closeQuietly((InputStream)in);
        return null;
    }

    public void delete(String name) {
        this.toDelete.add(name);
    }

    public void update(String name, InputStream in) {
        this.toUpdate.put(name, in);
    }

    public void update(String name, byte[] bytes) {
        this.toUpdate.put(name, new ByteArrayInputStream(bytes));
    }

    public void move(String src, String dst) {
        this.toMove.put(src, dst);
        this.toDelete.add(dst);
    }

    public void sync() throws IOException {
        File newZip;
        block21: {
            if (this.toDelete.isEmpty() && this.toUpdate.isEmpty() && this.toMove.isEmpty()) {
                return;
            }
            newZip = File.createTempFile(this.file.getName(), ".tmp", this.file.getParentFile());
            try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(newZip)));){
                ZipEntry entry;
                out.setLevel(0);
                for (Map.Entry<String, InputStream> update : this.toUpdate.entrySet()) {
                    entry = new ZipEntry(update.getKey());
                    out.putNextEntry(entry);
                    InputStream in = update.getValue();
                    UpdateableZipFile.copy(in, out);
                    IOUtils.closeQuietly((InputStream)in);
                }
                if (!this.file.exists()) break block21;
                try (FileInputStream in = FileUtils.openInputStream((File)this.file);
                     ZipInputStream zin = new ZipInputStream(in);){
                    entry = zin.getNextEntry();
                    while (entry != null) {
                        if (!this.toUpdate.containsKey(entry.getName()) && !this.toDelete.contains(entry.getName())) {
                            ZipEntry newEntry = entry;
                            if (this.toMove.containsKey(entry.getName())) {
                                newEntry = new ZipEntry(this.toMove.get(entry.getName()));
                                newEntry.setTime(entry.getTime());
                            }
                            out.putNextEntry(newEntry);
                            UpdateableZipFile.copy(zin, out);
                        }
                        entry = zin.getNextEntry();
                    }
                }
            }
        }
        this.toDelete.clear();
        this.toUpdate.clear();
        FileUtils.deleteQuietly((File)this.file);
        FileUtils.moveFile((File)newZip, (File)this.file);
    }

    protected static void copy(InputStream in, ZipOutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) >= 0) {
            out.write(buffer, 0, read);
        }
    }

    public void close() throws IOException {
        this.sync();
    }
}

