/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.meta.xml.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.jackrabbit.vault.vlt.VltException;
import org.apache.jackrabbit.vault.vlt.meta.MetaDirectory;
import org.apache.jackrabbit.vault.vlt.meta.MetaFile;
import org.apache.jackrabbit.vault.vlt.meta.VltEntries;
import org.apache.jackrabbit.vault.vlt.meta.xml.XmlEntries;
import org.apache.jackrabbit.vault.vlt.meta.xml.zip.UpdateableZipFile;
import org.apache.jackrabbit.vault.vlt.meta.xml.zip.ZipMetaFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipMetaDir
implements MetaDirectory {
    private static final Logger log = LoggerFactory.getLogger(ZipMetaDir.class);
    public static final String ADDRESS_FILE_NAME = "repository.url";
    public static final String BASE_DIR_NAME = "base";
    public static final String TMP_DIR_NAME = "tmp";
    public static final String ENTRIES_FILE_NAME = "entries.xml";
    private final UpdateableZipFile zip;
    private XmlEntries entries;

    public ZipMetaDir(File file) throws IOException {
        this.zip = new UpdateableZipFile(file);
    }

    protected UpdateableZipFile getZip() {
        return this.zip;
    }

    @Override
    public File getFile() {
        return this.zip.getZipFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRepositoryUrl() throws IOException {
        InputStream in = this.zip.getInputStream(ADDRESS_FILE_NAME);
        if (in == null) {
            return null;
        }
        try {
            List lines = IOUtils.readLines((InputStream)in, (String)"utf-8");
            if (lines.isEmpty()) {
                throw new IOException(this.getFile() + ":" + ADDRESS_FILE_NAME + " is empty.");
            }
            String string = (String)lines.get(0);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public void setRepositoryUrl(String url) throws IOException {
        this.zip.update(ADDRESS_FILE_NAME, url.getBytes("utf-8"));
        this.zip.sync();
    }

    @Override
    public boolean exists() {
        return this.zip.exists();
    }

    @Override
    public void create(String path) throws IOException {
        if (!this.zip.exists()) {
            this.entries = new XmlEntries(path, true);
            this.sync();
        }
    }

    @Override
    public void delete() throws IOException {
        this.zip.delete();
    }

    @Override
    public VltEntries getEntries() throws VltException {
        try {
            InputStream in;
            if (this.entries == null && (in = this.zip.getInputStream(ENTRIES_FILE_NAME)) != null) {
                try {
                    this.entries = XmlEntries.load(in);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            return this.entries;
        }
        catch (IOException e) {
            throw new VltException("Error while reading entries.", e);
        }
    }

    @Override
    public MetaFile getFile(String name) throws IOException {
        return this.getFile(name, false);
    }

    @Override
    public MetaFile getFile(String name, boolean create) throws IOException {
        if (create || this.zip.getEntry(name) != null) {
            return new ZipMetaFile(this, name);
        }
        return null;
    }

    @Override
    public MetaFile getTmpFile(String name, boolean create) throws IOException {
        return this.getFile("tmp/" + name, create);
    }

    @Override
    public MetaFile getBaseFile(String name, boolean create) throws IOException {
        return this.getFile("base/" + name, create);
    }

    @Override
    public boolean hasFile(String name) throws IOException {
        return this.zip.getEntry(name) != null;
    }

    @Override
    public void sync() throws IOException {
        if (this.entries != null && this.entries.isDirty()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.entries.save((OutputStream)out);
            this.zip.update(ENTRIES_FILE_NAME, out.toByteArray());
        }
        this.zip.sync();
    }

    @Override
    public void close() throws IOException {
        this.sync();
        this.zip.close();
    }
}

