/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.vlt.meta.xml.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.util.MD5;
import org.apache.jackrabbit.vault.vlt.meta.MetaDirectory;
import org.apache.jackrabbit.vault.vlt.meta.MetaFile;
import org.apache.jackrabbit.vault.vlt.meta.xml.zip.ZipMetaDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipMetaFile
implements MetaFile {
    private static final Logger log = LoggerFactory.getLogger(ZipMetaFile.class);
    private final ZipMetaDir parent;
    private final String relPath;
    private final String name;
    private File tmpFile;

    public ZipMetaFile(ZipMetaDir parent, String relPath) {
        this.parent = parent;
        this.relPath = relPath;
        this.name = relPath.substring(relPath.lastIndexOf(47) + 1);
    }

    @Override
    public MetaDirectory getDirectory() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream in = this.parent.getZip().getInputStream(this.relPath);
        if (in == null) {
            throw new FileNotFoundException(this.parent.getFile() + ":" + this.relPath);
        }
        return in;
    }

    @Override
    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream(), "utf-8");
    }

    @Override
    public long length() {
        ZipEntry entry = this.parent.getZip().getEntry(this.relPath);
        return entry == null ? -1L : entry.getSize();
    }

    @Override
    public MD5 md5() throws IOException {
        InputStream in = this.parent.getZip().getInputStream(this.relPath);
        if (in == null) {
            throw new FileNotFoundException(this.parent.getFile() + ":" + this.relPath);
        }
        try {
            MD5 mD5 = MD5.digest((InputStream)in);
            return mD5;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public long lastModified() {
        ZipEntry entry = this.parent.getZip().getEntry(this.relPath);
        return entry == null ? 0L : entry.getTime();
    }

    @Override
    public void delete() throws IOException {
        this.parent.getZip().delete(this.relPath);
        this.parent.getZip().sync();
    }

    @Override
    public File openTempFile() throws IOException {
        if (this.tmpFile == null) {
            File parentDir = this.parent.getZip().getZipFile().getParentFile();
            this.tmpFile = File.createTempFile(".vlt-", ".tmp", parentDir);
            this.tmpFile.createNewFile();
            this.copyToSilent(this.tmpFile, true);
        }
        return this.tmpFile;
    }

    @Override
    public void closeTempFile(boolean discard) throws IOException {
        if (this.tmpFile == null) {
            log.warn("tmp file never opened: " + this.parent.getFile() + ":" + this.relPath);
        } else {
            if (!discard) {
                FileInputStream in = new FileInputStream(this.tmpFile);
                try {
                    this.parent.getZip().update(this.relPath, in);
                    this.parent.getZip().sync();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            FileUtils.deleteQuietly((File)this.tmpFile);
            this.tmpFile = null;
        }
    }

    @Override
    public void moveTo(MetaFile dst) throws IOException {
        ZipMetaFile dest = (ZipMetaFile)dst;
        this.parent.getZip().move(this.relPath, dest.relPath);
        this.parent.getZip().sync();
    }

    @Override
    public void copyTo(File file, boolean preserveFileDate) throws IOException {
        if (!this.copyToSilent(file, preserveFileDate)) {
            throw new FileNotFoundException(this.parent.getFile() + ":" + this.relPath);
        }
    }

    @Override
    public String getPath() {
        return this.parent.getFile() + ":" + this.relPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyToSilent(File file, boolean preserveFileDate) throws IOException {
        InputStream in = this.parent.getZip().getInputStream(this.relPath);
        if (in == null) {
            return false;
        }
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream((File)file);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            if (preserveFileDate) {
                ZipEntry entry = this.parent.getZip().getEntry(this.relPath);
                file.setLastModified(entry.getTime());
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
        return true;
    }

    public String toString() {
        return this.getPath();
    }
}

