/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init.configuration;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import java.util.Optional;

public interface JamesExecutionProfiles {
    public static DriverExecutionProfile getLWTProfile(CqlSession session) {
        DriverExecutionProfile executionProfile = (DriverExecutionProfile)session.getContext().getConfig().getProfiles().get("LWT");
        return Optional.ofNullable(executionProfile).orElseGet(() -> JamesExecutionProfiles.defaultLWTProfile(session));
    }

    private static DriverExecutionProfile defaultLWTProfile(CqlSession session) {
        return session.getContext().getConfig().getDefaultProfile().withString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, DefaultConsistencyLevel.SERIAL.name()).withString((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY, DefaultConsistencyLevel.SERIAL.name());
    }

    public static DriverExecutionProfile getCachingProfile(CqlSession session) {
        DriverExecutionProfile executionProfile = (DriverExecutionProfile)session.getContext().getConfig().getProfiles().get("CACHING");
        return Optional.ofNullable(executionProfile).orElseGet(() -> JamesExecutionProfiles.defaultCachingProfile(session));
    }

    private static DriverExecutionProfile defaultCachingProfile(CqlSession session) {
        return session.getContext().getConfig().getDefaultProfile().withString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, DefaultConsistencyLevel.ONE.name());
    }

    public static DriverExecutionProfile getOptimisticConsistencyLevelProfile(CqlSession session) {
        DriverExecutionProfile executionProfile = (DriverExecutionProfile)session.getContext().getConfig().getProfiles().get("OPTIMISTIC_CONSISTENCY_LEVEL");
        return Optional.ofNullable(executionProfile).orElseGet(() -> JamesExecutionProfiles.defaultOptimisticConsistencyLevelProfile(session));
    }

    private static DriverExecutionProfile defaultOptimisticConsistencyLevelProfile(CqlSession session) {
        return session.getContext().getConfig().getDefaultProfile().withString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, DefaultConsistencyLevel.LOCAL_ONE.name());
    }

    public static DriverExecutionProfile getBatchProfile(CqlSession session) {
        DriverExecutionProfile executionProfile = (DriverExecutionProfile)session.getContext().getConfig().getProfiles().get("BATCH");
        return Optional.ofNullable(executionProfile).orElseGet(() -> JamesExecutionProfiles.defaultBatchProfile(session));
    }

    private static DriverExecutionProfile defaultBatchProfile(CqlSession session) {
        return session.getContext().getConfig().getDefaultProfile().withLong((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, 3600000L);
    }

    public static DriverExecutionProfile getTableCreationProfile(CqlSession session) {
        DriverExecutionProfile executionProfile = (DriverExecutionProfile)session.getContext().getConfig().getProfiles().get("TABLE_CREATION");
        return Optional.ofNullable(executionProfile).orElseGet(() -> JamesExecutionProfiles.defaultTableCreationProfile(session));
    }

    private static DriverExecutionProfile defaultTableCreationProfile(CqlSession session) {
        return session.getContext().getConfig().getDefaultProfile().withLong((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, 10000L);
    }

    public static enum ConsistencyChoice {
        WEAK,
        STRONG;

    }
}

