/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.ModSeqProvider;

public abstract class AbstractLockingModSeqProvider
implements ModSeqProvider {
    private final MailboxPathLocker locker;

    public AbstractLockingModSeqProvider(MailboxPathLocker locker) {
        this.locker = locker;
    }

    @Override
    public long nextModSeq(MailboxSession session, Mailbox mailbox) throws MailboxException {
        boolean writeLock = true;
        return (Long)this.locker.executeWithLock(session, mailbox.generateAssociatedPath(), () -> this.lockedNextModSeq(session, mailbox), writeLock);
    }

    @Override
    public long nextModSeq(MailboxSession session, MailboxId mailboxId) {
        throw new NotImplementedException("Not implemented");
    }

    protected abstract long lockedNextModSeq(MailboxSession var1, Mailbox var2) throws MailboxException;
}

