/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.UidProvider;

public abstract class AbstractLockingUidProvider
implements UidProvider {
    private final MailboxPathLocker locker;

    public AbstractLockingUidProvider(MailboxPathLocker locker) {
        this.locker = locker;
    }

    @Override
    public MessageUid nextUid(MailboxSession session, Mailbox mailbox) throws MailboxException {
        boolean writeLock = true;
        return (MessageUid)this.locker.executeWithLock(session, mailbox.generateAssociatedPath(), () -> this.lockedNextUid(session, mailbox), writeLock);
    }

    protected abstract MessageUid lockedNextUid(MailboxSession var1, Mailbox var2) throws MailboxException;

    @Override
    public MessageUid nextUid(MailboxSession session, MailboxId mailboxId) {
        throw new NotImplementedException("Not implemented");
    }
}

