/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.mailbox.MailboxSession;

public class Username {
    private final String value;

    public static Username fromMailboxSession(MailboxSession mailboxSession) {
        Preconditions.checkNotNull((Object)mailboxSession);
        Preconditions.checkNotNull((Object)mailboxSession.getUser());
        return Username.fromRawValue(mailboxSession.getUser().asString());
    }

    public static Username fromRawValue(String value) {
        return new Username(value);
    }

    private Username(String value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof Username) {
            Username username = (Username)o;
            return Objects.equals(this.value, username.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }
}

