/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.DelegatingMailboxMessage;
import org.apache.james.mailbox.store.mail.model.FlagsFactory;
import org.apache.james.mailbox.store.mail.model.FlagsFilter;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMessage;

public class SimpleMailboxMessage
extends DelegatingMailboxMessage {
    private MessageUid uid;
    private final MailboxId mailboxId;
    private boolean answered;
    private boolean deleted;
    private boolean draft;
    private boolean flagged;
    private boolean recent;
    private boolean seen;
    private String[] userFlags;
    private long modSeq;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(MailboxMessage original) throws MailboxException {
        return SimpleMailboxMessage.fromWithoutAttachments(original).addAttachments(original.getAttachments());
    }

    public static SimpleMailboxMessage copy(MailboxId mailboxId, MailboxMessage original) throws MailboxException {
        return SimpleMailboxMessage.from(original).mailboxId(mailboxId).build();
    }

    public static Builder fromWithoutAttachments(MailboxMessage original) throws MailboxException {
        PropertyBuilder propertyBuilder = new PropertyBuilder(original.getProperties());
        propertyBuilder.setTextualLineCount(original.getTextualLineCount());
        return SimpleMailboxMessage.builder().bodyStartOctet(Ints.checkedCast((long)(original.getFullContentOctets() - original.getBodyOctets()))).content((SharedInputStream)SimpleMailboxMessage.copyFullContent(original)).messageId(original.getMessageId()).internalDate(original.getInternalDate()).size(original.getFullContentOctets()).flags(original.createFlags()).propertyBuilder(propertyBuilder);
    }

    public static SimpleMailboxMessage copyWithoutAttachments(MailboxId mailboxId, MailboxMessage original) throws MailboxException {
        return SimpleMailboxMessage.fromWithoutAttachments(original).mailboxId(mailboxId).build();
    }

    private static SharedByteArrayInputStream copyFullContent(MailboxMessage original) throws MailboxException {
        try {
            return new SharedByteArrayInputStream(IOUtils.toByteArray((InputStream)original.getFullContent()));
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Throwable)e);
        }
    }

    public SimpleMailboxMessage(MessageId messageId, Date internalDate, long size, int bodyStartOctet, SharedInputStream content, Flags flags, PropertyBuilder propertyBuilder, MailboxId mailboxId, List<MessageAttachment> attachments) {
        super(new SimpleMessage(messageId, content, size, internalDate, propertyBuilder.getSubType(), propertyBuilder.getMediaType(), bodyStartOctet, propertyBuilder.getTextualLineCount(), propertyBuilder.toProperties(), attachments));
        this.setFlags(flags);
        this.mailboxId = mailboxId;
        this.userFlags = flags.getUserFlags();
    }

    public SimpleMailboxMessage(MessageId messageId, Date internalDate, long size, int bodyStartOctet, SharedInputStream content, Flags flags, PropertyBuilder propertyBuilder, MailboxId mailboxId) {
        this(messageId, internalDate, size, bodyStartOctet, content, flags, propertyBuilder, mailboxId, (List<MessageAttachment>)ImmutableList.of());
    }

    @Override
    public ComposedMessageIdWithMetaData getComposedMessageIdWithMetaData() {
        return ComposedMessageIdWithMetaData.builder().modSeq(this.modSeq).flags(this.createFlags()).composedMessageId(new ComposedMessageId(this.mailboxId, this.getMessageId(), this.uid)).build();
    }

    @Override
    protected String[] createUserFlags() {
        return (String[])this.userFlags.clone();
    }

    @Override
    public MailboxId getMailboxId() {
        return this.mailboxId;
    }

    @Override
    public MessageUid getUid() {
        return this.uid;
    }

    @Override
    public boolean isAnswered() {
        return this.answered;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public boolean isDraft() {
        return this.draft;
    }

    @Override
    public boolean isFlagged() {
        return this.flagged;
    }

    @Override
    public boolean isRecent() {
        return this.recent;
    }

    @Override
    public boolean isSeen() {
        return this.seen;
    }

    @Override
    public long getModSeq() {
        return this.modSeq;
    }

    @Override
    public void setModSeq(long modSeq) {
        this.modSeq = modSeq;
    }

    @Override
    public void setUid(MessageUid uid) {
        this.uid = uid;
    }

    @Override
    public synchronized void setFlags(Flags flags) {
        this.answered = flags.contains(Flags.Flag.ANSWERED);
        this.deleted = flags.contains(Flags.Flag.DELETED);
        this.draft = flags.contains(Flags.Flag.DRAFT);
        this.flagged = flags.contains(Flags.Flag.FLAGGED);
        this.recent = flags.contains(Flags.Flag.RECENT);
        this.seen = flags.contains(Flags.Flag.SEEN);
        this.userFlags = flags.getUserFlags();
    }

    public SimpleMailboxMessage filterFlags(FlagsFilter filter) throws MailboxException {
        Flags flags = FlagsFactory.builder().flags(this.createFlags()).addUserFlags(this.createUserFlags()).filteringFlags(filter).build();
        return SimpleMailboxMessage.from(this).flags(flags).build();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.uid});
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleMailboxMessage) {
            SimpleMailboxMessage other = (SimpleMailboxMessage)obj;
            return Objects.equal((Object)this.uid, (Object)other.uid);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uid", (Object)this.uid).add("mailboxId", (Object)this.mailboxId).add("answered", this.answered).add("deleted", this.deleted).add("draft", this.draft).add("flagged", this.flagged).add("recent", this.recent).add("seen", this.seen).add("message", (Object)this.getMessage()).toString();
    }

    public static class Builder {
        private MessageId messageId;
        private Date internalDate;
        private Long size;
        private Integer bodyStartOctet;
        private SharedInputStream content;
        private Flags flags;
        private PropertyBuilder propertyBuilder;
        private MailboxId mailboxId;
        private Optional<MessageUid> uid = Optional.empty();
        private Optional<Long> modseq = Optional.empty();
        private ImmutableList.Builder<MessageAttachment> attachments = ImmutableList.builder();

        public Builder messageId(MessageId messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder uid(MessageUid messageUid) {
            this.uid = Optional.of(messageUid);
            return this;
        }

        public Builder modseq(long modseq) {
            Preconditions.checkArgument((modseq >= 0L ? 1 : 0) != 0, (Object)"modseq can not be negative");
            this.modseq = Optional.of(modseq);
            return this;
        }

        public Builder internalDate(Date internalDate) {
            this.internalDate = internalDate;
            return this;
        }

        public Builder size(long size) {
            Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size can not be negative");
            this.size = size;
            return this;
        }

        public Builder bodyStartOctet(int bodyStartOctet) {
            Preconditions.checkArgument((bodyStartOctet >= 0 ? 1 : 0) != 0, (Object)"bodyStartOctet can not be negative");
            this.bodyStartOctet = bodyStartOctet;
            return this;
        }

        public Builder content(SharedInputStream content) {
            this.content = content;
            return this;
        }

        public Builder flags(Flags flags) {
            this.flags = flags;
            return this;
        }

        public Builder propertyBuilder(PropertyBuilder propertyBuilder) {
            this.propertyBuilder = propertyBuilder;
            return this;
        }

        public Builder mailboxId(MailboxId mailboxId) {
            this.mailboxId = mailboxId;
            return this;
        }

        public Builder addAttachments(Collection<MessageAttachment> attachments) {
            this.attachments.addAll(attachments);
            return this;
        }

        public SimpleMailboxMessage build() {
            Preconditions.checkNotNull((Object)this.messageId, (Object)"messageId is required");
            Preconditions.checkNotNull((Object)this.internalDate, (Object)"internalDate is required");
            Preconditions.checkNotNull((Object)this.size, (Object)"size is required");
            Preconditions.checkNotNull((Object)this.bodyStartOctet, (Object)"bodyStartOctet is required");
            Preconditions.checkNotNull((Object)this.content, (Object)"content is required");
            Preconditions.checkNotNull((Object)this.flags, (Object)"flags is required");
            Preconditions.checkNotNull((Object)this.propertyBuilder, (Object)"propertyBuilder is required");
            Preconditions.checkNotNull((Object)this.mailboxId, (Object)"mailboxId is required");
            SimpleMailboxMessage simpleMailboxMessage = new SimpleMailboxMessage(this.messageId, this.internalDate, this.size, this.bodyStartOctet, this.content, this.flags, this.propertyBuilder, this.mailboxId, (List<MessageAttachment>)this.attachments.build());
            this.uid.ifPresent(simpleMailboxMessage::setUid);
            this.modseq.ifPresent(simpleMailboxMessage::setModSeq);
            return simpleMailboxMessage;
        }
    }
}

