/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.User;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaRootDeserializer;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.SessionProvider;

public class DefaultUserQuotaRootResolver
implements UserQuotaRootResolver {
    public static final String SEPARATOR = "&";
    private static final DefaultQuotaRootDeserializer QUOTA_ROOT_DESERIALIZER = new DefaultQuotaRootDeserializer();
    private final SessionProvider sessionProvider;
    private final MailboxSessionMapperFactory factory;

    @Inject
    public DefaultUserQuotaRootResolver(SessionProvider sessionProvider, MailboxSessionMapperFactory factory) {
        this.sessionProvider = sessionProvider;
        this.factory = factory;
    }

    public QuotaRoot forUser(User user) {
        return QuotaRoot.quotaRoot((String)("#private&" + user.asString()), (Optional)user.getDomainPart());
    }

    public QuotaRoot getQuotaRoot(MailboxPath mailboxPath) {
        Preconditions.checkArgument((!mailboxPath.getNamespace().contains(SEPARATOR) ? 1 : 0) != 0, (Object)"Namespace should not contain &");
        return Optional.ofNullable(mailboxPath.getUser()).map(user -> {
            Preconditions.checkArgument((!mailboxPath.getUser().contains(SEPARATOR) ? 1 : 0) != 0, (Object)"Username should not contain &");
            return User.fromUsername((String)mailboxPath.getUser());
        }).map(user -> QuotaRoot.quotaRoot((String)(mailboxPath.getNamespace() + SEPARATOR + user.asString()), (Optional)user.getDomainPart())).orElseGet(() -> QuotaRoot.quotaRoot((String)mailboxPath.getNamespace(), Optional.empty()));
    }

    public QuotaRoot getQuotaRoot(MailboxId mailboxId) throws MailboxException {
        MailboxSession session = this.sessionProvider.createSystemSession("DefaultUserQuotaRootResolver");
        User user = User.fromUsername((String)this.factory.getMailboxMapper(session).findMailboxById(mailboxId).generateAssociatedPath().getUser());
        return this.forUser(user);
    }

    public QuotaRoot fromString(String serializedQuotaRoot) throws MailboxException {
        return QUOTA_ROOT_DESERIALIZER.fromString(serializedQuotaRoot);
    }

    public List<MailboxPath> retrieveAssociatedMailboxes(QuotaRoot quotaRoot, MailboxSession mailboxSession) throws MailboxException {
        List parts = DefaultUserQuotaRootResolver.QUOTA_ROOT_DESERIALIZER.toParts(quotaRoot.getValue());
        String namespace = (String)parts.get(0);
        String user = (String)parts.get(1);
        return Lists.transform(this.factory.getMailboxMapper(mailboxSession).findMailboxWithPathLike(new MailboxPath(namespace, user, "%")), Mailbox::generateAssociatedPath);
    }

    public static class DefaultQuotaRootDeserializer
    implements QuotaRootDeserializer {
        public QuotaRoot fromString(String serializedQuotaRoot) throws MailboxException {
            List<String> parts = this.toParts(serializedQuotaRoot);
            User user = User.fromUsername((String)parts.get(1));
            return QuotaRoot.quotaRoot((String)serializedQuotaRoot, (Optional)user.getDomainPart());
        }

        private List<String> toParts(String serializedQuotaRoot) throws MailboxException {
            List parts = Splitter.on((String)DefaultUserQuotaRootResolver.SEPARATOR).splitToList((CharSequence)serializedQuotaRoot);
            if (parts.size() != 2) {
                throw new MailboxException(serializedQuotaRoot + " used as QuotaRoot should contain exactly one \"" + DefaultUserQuotaRootResolver.SEPARATOR + "\"");
            }
            return parts;
        }
    }
}

