/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import javax.inject.Inject;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.EventBus;
import org.apache.james.mailbox.events.Group;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.events.RegistrationKey;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.quota.QuotaUpdater;
import org.apache.james.mailbox.store.quota.StoreCurrentQuotaManager;

public class ListeningCurrentQuotaUpdater
implements MailboxListener.GroupMailboxListener,
QuotaUpdater {
    public static final Group GROUP = new ListeningCurrentQuotaUpdaterGroup();
    private static final ImmutableSet<RegistrationKey> NO_REGISTRATION_KEYS = ImmutableSet.of();
    private final StoreCurrentQuotaManager currentQuotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final EventBus eventBus;
    private final QuotaManager quotaManager;

    @Inject
    public ListeningCurrentQuotaUpdater(StoreCurrentQuotaManager currentQuotaManager, QuotaRootResolver quotaRootResolver, EventBus eventBus, QuotaManager quotaManager) {
        this.currentQuotaManager = currentQuotaManager;
        this.quotaRootResolver = quotaRootResolver;
        this.eventBus = eventBus;
        this.quotaManager = quotaManager;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxListener.Added || event instanceof MailboxListener.Expunged || event instanceof MailboxListener.MailboxDeletion;
    }

    public void event(Event event) throws MailboxException {
        if (event instanceof MailboxListener.Added) {
            MailboxListener.Added addedEvent = (MailboxListener.Added)event;
            QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(addedEvent.getMailboxId());
            this.handleAddedEvent(addedEvent, quotaRoot);
        } else if (event instanceof MailboxListener.Expunged) {
            MailboxListener.Expunged expungedEvent = (MailboxListener.Expunged)event;
            QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(expungedEvent.getMailboxId());
            this.handleExpungedEvent(expungedEvent, quotaRoot);
        } else if (event instanceof MailboxListener.MailboxDeletion) {
            MailboxListener.MailboxDeletion mailboxDeletionEvent = (MailboxListener.MailboxDeletion)event;
            this.handleMailboxDeletionEvent(mailboxDeletionEvent);
        }
    }

    private void handleExpungedEvent(MailboxListener.Expunged expunged, QuotaRoot quotaRoot) throws MailboxException {
        long expungedSize = this.totalSize((MailboxListener.MetaDataHoldingEvent)expunged);
        long expungedCount = expunged.getUids().size();
        if (expungedCount != 0L && expungedSize != 0L) {
            this.currentQuotaManager.decrease(quotaRoot, expungedCount, expungedSize);
        }
        this.eventBus.dispatch((Event)EventFactory.quotaUpdated().randomEventId().user(expunged.getUser()).quotaRoot(quotaRoot).quotaCount((Quota<QuotaCount>)this.quotaManager.getMessageQuota(quotaRoot)).quotaSize((Quota<QuotaSize>)this.quotaManager.getStorageQuota(quotaRoot)).instant(Instant.now()).build(), NO_REGISTRATION_KEYS).block();
    }

    private void handleAddedEvent(MailboxListener.Added added, QuotaRoot quotaRoot) throws MailboxException {
        long addedSize = this.totalSize((MailboxListener.MetaDataHoldingEvent)added);
        long addedCount = added.getUids().size();
        if (addedCount != 0L && addedSize != 0L) {
            this.currentQuotaManager.increase(quotaRoot, addedCount, addedSize);
        }
        this.eventBus.dispatch((Event)EventFactory.quotaUpdated().randomEventId().user(added.getUser()).quotaRoot(quotaRoot).quotaCount((Quota<QuotaCount>)this.quotaManager.getMessageQuota(quotaRoot)).quotaSize((Quota<QuotaSize>)this.quotaManager.getStorageQuota(quotaRoot)).instant(Instant.now()).build(), NO_REGISTRATION_KEYS).block();
    }

    private long totalSize(MailboxListener.MetaDataHoldingEvent metaDataHoldingEvent) {
        return metaDataHoldingEvent.getUids().stream().mapToLong(uid -> metaDataHoldingEvent.getMetaData(uid).getSize()).sum();
    }

    private void handleMailboxDeletionEvent(MailboxListener.MailboxDeletion mailboxDeletionEvent) throws MailboxException {
        boolean mailboxContainedMessages;
        boolean bl = mailboxContainedMessages = mailboxDeletionEvent.getDeletedMessageCount().asLong() > 0L;
        if (mailboxContainedMessages) {
            this.currentQuotaManager.decrease(mailboxDeletionEvent.getQuotaRoot(), mailboxDeletionEvent.getDeletedMessageCount().asLong(), mailboxDeletionEvent.getTotalDeletedSize().asLong());
        }
    }

    public static class ListeningCurrentQuotaUpdaterGroup
    extends Group {
    }
}

