/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.core.quota.QuotaValue;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;

public class QuotaChecker {
    private final Quota<QuotaCount> messageQuota;
    private final Quota<QuotaSize> sizeQuota;
    private final QuotaRoot quotaRoot;

    public QuotaChecker(QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, Mailbox mailbox) throws MailboxException {
        this.quotaRoot = quotaRootResolver.getQuotaRoot(mailbox.generateAssociatedPath());
        this.messageQuota = quotaManager.getMessageQuota(this.quotaRoot);
        this.sizeQuota = quotaManager.getStorageQuota(this.quotaRoot);
    }

    public QuotaChecker(Quota<QuotaCount> messageQuota, Quota<QuotaSize> sizeQuota, QuotaRoot quotaRoot) {
        this.messageQuota = messageQuota;
        this.sizeQuota = sizeQuota;
        this.quotaRoot = quotaRoot;
    }

    public void tryAddition(long count, long size) throws OverQuotaException {
        this.tryCountAddition(count);
        this.trySizeAddition(size);
    }

    private void trySizeAddition(long size) throws OverQuotaException {
        Quota afterAdditionQuotaSize = this.sizeQuota.addValueToQuota((QuotaValue)QuotaSize.size((long)size));
        if (afterAdditionQuotaSize.isOverQuota()) {
            throw new OverQuotaException("You use too much space in " + this.quotaRoot.getValue(), afterAdditionQuotaSize.getLimit(), afterAdditionQuotaSize.getUsed());
        }
    }

    private void tryCountAddition(long count) throws OverQuotaException {
        Quota afterAdditionQuotaCount = this.messageQuota.addValueToQuota((QuotaValue)QuotaCount.count((long)count));
        if (afterAdditionQuotaCount.isOverQuota()) {
            throw new OverQuotaException("You have too many messages in " + this.quotaRoot.getValue(), this.messageQuota.getLimit(), this.messageQuota.getUsed());
        }
    }
}

