/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.SearchQuery;

public interface MessageSearchIndex {
    public Stream<MessageUid> search(MailboxSession var1, Mailbox var2, SearchQuery var3) throws MailboxException;

    public List<MessageId> search(MailboxSession var1, Collection<MailboxId> var2, SearchQuery var3, long var4) throws MailboxException;

    public EnumSet<MailboxManager.SearchCapabilities> getSupportedCapabilities(EnumSet<MailboxManager.MessageCapabilities> var1);

    public static class SearchResult {
        private final Optional<MessageId> messageId;
        private final MailboxId mailboxId;
        private final MessageUid messageUid;

        public SearchResult(Optional<MessageId> messageId, MailboxId mailboxId, MessageUid messageUid) {
            this.messageId = messageId;
            this.mailboxId = mailboxId;
            this.messageUid = messageUid;
        }

        public Optional<MessageId> getMessageId() {
            return this.messageId;
        }

        public MailboxId getMailboxId() {
            return this.mailboxId;
        }

        public MessageUid getMessageUid() {
            return this.messageUid;
        }
    }
}

