/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.field.Fields;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.message.AbstractEntityBuilder;
import org.apache.james.mime4j.message.BasicBodyFactory;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.HeaderImpl;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.NameValuePair;

public class BodyPartBuilder
extends AbstractEntityBuilder {
    private BodyFactory bodyFactory;

    public static BodyPartBuilder create() {
        return new BodyPartBuilder();
    }

    public BodyPartBuilder use(BodyFactory bodyFactory) {
        this.bodyFactory = bodyFactory;
        return this;
    }

    public BodyPartBuilder setField(Field field) {
        super.setField(field);
        return this;
    }

    public AbstractEntityBuilder addField(Field field) {
        super.addField(field);
        return this;
    }

    public AbstractEntityBuilder removeFields(String name) {
        super.removeFields(name);
        return this;
    }

    public BodyPartBuilder setContentTransferEncoding(String contentTransferEncoding) {
        super.setContentTransferEncoding(contentTransferEncoding);
        return this;
    }

    public BodyPartBuilder setContentType(String mimeType, NameValuePair ... parameters) {
        super.setContentType(mimeType, parameters);
        return this;
    }

    public BodyPartBuilder setContentDisposition(String dispositionType) {
        super.setContentDisposition(dispositionType);
        return this;
    }

    public BodyPartBuilder setContentDisposition(String dispositionType, String filename) {
        super.setContentDisposition(dispositionType, filename);
        return this;
    }

    public BodyPartBuilder setContentDisposition(String dispositionType, String filename, long size) {
        super.setContentDisposition(dispositionType, filename, size);
        return this;
    }

    public BodyPartBuilder setContentDisposition(String dispositionType, String filename, long size, Date creationDate, Date modificationDate, Date readDate) {
        super.setContentDisposition(dispositionType, filename, size, creationDate, modificationDate, readDate);
        return this;
    }

    public BodyPartBuilder setBody(Body body) {
        super.setBody(body);
        return this;
    }

    public BodyPartBuilder setBody(TextBody textBody) {
        super.setBody(textBody);
        return this;
    }

    public BodyPartBuilder setBody(BinaryBody binaryBody) {
        super.setBody(binaryBody);
        return this;
    }

    public BodyPartBuilder setBody(Multipart multipart) {
        super.setBody(multipart);
        return this;
    }

    public BodyPartBuilder setBody(Message message) {
        super.setBody(message);
        return this;
    }

    public BodyPartBuilder setBody(String text, Charset charset) throws IOException {
        return this.setBody(text, null, charset);
    }

    public BodyPartBuilder setBody(String text, String subtype, Charset charset) throws IOException {
        String mimeType = "text/" + (subtype != null ? subtype : "plain");
        if (charset != null) {
            this.setField(Fields.contentType(mimeType, new NameValuePair("charset", charset.name())));
        } else {
            this.setField(Fields.contentType(mimeType));
        }
        TextBody textBody = this.bodyFactory != null ? this.bodyFactory.textBody(InputStreams.create((CharSequence)text, (Charset)charset), charset != null ? charset.name() : null) : BasicBodyFactory.INSTANCE.textBody(text, charset);
        return this.setBody((Body)textBody);
    }

    public BodyPartBuilder setBody(byte[] bin, String mimeType) throws IOException {
        this.setField(Fields.contentType(mimeType != null ? mimeType : "application/octet-stream"));
        BinaryBody binBody = this.bodyFactory != null ? this.bodyFactory.binaryBody(InputStreams.create((byte[])bin)) : BasicBodyFactory.INSTANCE.binaryBody(bin);
        return this.setBody((Body)binBody);
    }

    public BodyPart build() {
        BodyPart bodyPart = new BodyPart();
        HeaderImpl header = new HeaderImpl();
        bodyPart.setHeader(header);
        for (Field field : this.getFields()) {
            header.addField(field);
        }
        bodyPart.setBody(this.getBody());
        return bodyPart;
    }
}

