/* Generated By:JavaCC: Do not edit this line. DateTimeParser.java */
/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/
package org.apache.james.mime4j.field.datetime.parser;

import org.apache.james.mime4j.dom.datetime.DateTime;

public class DateTimeParser implements DateTimeParserConstants {
    private static final boolean ignoreMilitaryZoneOffset = true;

    public static void main(String args[]) throws ParseException {
                while (true) {
                    try {
                                DateTimeParser parser = new DateTimeParser(System.in);
                        parser.parseLine();
                    } catch (Exception x) {
                                x.printStackTrace();
                                return;
                    }
                }
    }

    private static int parseDigits(Token token) {
        return Integer.parseInt(token.image, 10);
    }

    private static int getMilitaryZoneOffset(char c) {
        if (ignoreMilitaryZoneOffset)
            return 0;

        c = Character.toUpperCase(c);

        switch (c) {
            case 'A': return 1;
            case 'B': return 2;
            case 'C': return 3;
            case 'D': return 4;
            case 'E': return 5;
            case 'F': return 6;
            case 'G': return 7;
            case 'H': return 8;
            case 'I': return 9;
            case 'K': return 10;
            case 'L': return 11;
            case 'M': return 12;

            case 'N': return -1;
            case 'O': return -2;
            case 'P': return -3;
            case 'Q': return -4;
            case 'R': return -5;
            case 'S': return -6;
            case 'T': return -7;
            case 'U': return -8;
            case 'V': return -9;
            case 'W': return -10;
            case 'X': return -11;
            case 'Y': return -12;

            case 'Z': return 0;
            default: return 0;
        }
    }

    private static class Time {
        private int hour;
        private int minute;
        private int second;
        private int zone;

        public Time(int hour, int minute, int second, int zone) {
            this.hour = hour;
            this.minute = minute;
            this.second = second;
            this.zone = zone;
        }

        public int getHour() { return hour; }
        public int getMinute() { return minute; }
        public int getSecond() { return second; }
        public int getZone() { return zone; }
    }

    private static class Date {
        private String year;
        private int month;
        private int day;

        public Date(String year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }

        public String getYear() { return year; }
        public int getMonth() { return month; }
        public int getDay() { return day; }
    }

  final public DateTime parseLine() throws ParseException {
 DateTime dt;
    dt = date_time();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 1:
      jj_consume_token(1);
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    jj_consume_token(2);
          {if (true) return dt;}
    throw new Error("Missing return statement in function");
  }

  final public DateTime parseAll() throws ParseException {
 DateTime dt;
    dt = date_time();
    jj_consume_token(0);
          {if (true) return dt;}
    throw new Error("Missing return statement in function");
  }

  final public DateTime date_time() throws ParseException {
 Date d; Time t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MON:
    case TUE:
    case WED:
    case THU:
    case FRI:
    case SAT:
    case SUN:
      day_of_week();
      jj_consume_token(3);
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    d = date();
    t = time();
            {if (true) return new DateTime(
                    d.getYear(),
                    d.getMonth(),
                    d.getDay(),
                    t.getHour(),
                    t.getMinute(),
                    t.getSecond(),
                    t.getZone());}    // time zone offset

    throw new Error("Missing return statement in function");
  }

  final public String day_of_week() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MON:
      jj_consume_token(MON);
      break;
    case TUE:
      jj_consume_token(TUE);
      break;
    case WED:
      jj_consume_token(WED);
      break;
    case THU:
      jj_consume_token(THU);
      break;
    case FRI:
      jj_consume_token(FRI);
      break;
    case SAT:
      jj_consume_token(SAT);
      break;
    case SUN:
      jj_consume_token(SUN);
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return token.image;}
    throw new Error("Missing return statement in function");
  }

  final public Date date() throws ParseException {
 int d, m; String y;
    d = day();
    m = month();
    y = year();
      {if (true) return new Date(y, m, d);}
    throw new Error("Missing return statement in function");
  }

  final public int day() throws ParseException {
 Token t;
    t = jj_consume_token(DIGITS);
                 {if (true) return parseDigits(t);}
    throw new Error("Missing return statement in function");
  }

  final public int month() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case JAN:
      jj_consume_token(JAN);
            {if (true) return 1;}
      break;
    case FEB:
      jj_consume_token(FEB);
            {if (true) return 2;}
      break;
    case MAR:
      jj_consume_token(MAR);
            {if (true) return 3;}
      break;
    case APR:
      jj_consume_token(APR);
            {if (true) return 4;}
      break;
    case MAY:
      jj_consume_token(MAY);
            {if (true) return 5;}
      break;
    case JUN:
      jj_consume_token(JUN);
            {if (true) return 6;}
      break;
    case JUL:
      jj_consume_token(JUL);
            {if (true) return 7;}
      break;
    case AUG:
      jj_consume_token(AUG);
            {if (true) return 8;}
      break;
    case SEP:
      jj_consume_token(SEP);
            {if (true) return 9;}
      break;
    case OCT:
      jj_consume_token(OCT);
            {if (true) return 10;}
      break;
    case NOV:
      jj_consume_token(NOV);
            {if (true) return 11;}
      break;
    case DEC:
      jj_consume_token(DEC);
            {if (true) return 12;}
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String year() throws ParseException {
 Token t;
    t = jj_consume_token(DIGITS);
      String year = (String) t.image;
      if (year.length() == 2)
      {
        if (year.charAt(0) > '6')
        {
          {if (true) return "19" + year;}
        }
        {if (true) return "20" + year;}
      }
      {if (true) return year;}
    throw new Error("Missing return statement in function");
  }

  final public Time time() throws ParseException {
 int h, m, s=0, z;
    h = hour();
    jj_consume_token(4);
    m = minute();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 4:
      jj_consume_token(4);
      s = second();
      break;
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    z = zone();
      {if (true) return new Time(h, m, s, z);}
    throw new Error("Missing return statement in function");
  }

  final public int hour() throws ParseException {
 Token t;
    t = jj_consume_token(DIGITS);
                 {if (true) return parseDigits(t);}
    throw new Error("Missing return statement in function");
  }

  final public int minute() throws ParseException {
 Token t;
    t = jj_consume_token(DIGITS);
                 {if (true) return parseDigits(t);}
    throw new Error("Missing return statement in function");
  }

  final public int second() throws ParseException {
 Token t;
    t = jj_consume_token(DIGITS);
                 {if (true) return parseDigits(t);}
    throw new Error("Missing return statement in function");
  }

  final public int zone() throws ParseException {
  Token t, u; int z;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OFFSETDIR:
      t = jj_consume_token(OFFSETDIR);
      u = jj_consume_token(DIGITS);
                                              z=parseDigits(u)*(t.image.equals("-") ? -1 : 1);
      break;
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case MILITARY_ZONE:
      z = obs_zone();
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return z;}
    throw new Error("Missing return statement in function");
  }

  final public int obs_zone() throws ParseException {
 Token t; int z;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 6:
      jj_consume_token(6);
            z=0;
      break;
    case 7:
      jj_consume_token(7);
            z=0;
      break;
    case 8:
      jj_consume_token(8);
            z=-5;
      break;
    case 9:
      jj_consume_token(9);
            z=-4;
      break;
    case 10:
      jj_consume_token(10);
            z=-6;
      break;
    case 11:
      jj_consume_token(11);
            z=-5;
      break;
    case 12:
      jj_consume_token(12);
            z=-7;
      break;
    case 13:
      jj_consume_token(13);
            z=-6;
      break;
    case 14:
      jj_consume_token(14);
            z=-8;
      break;
    case 15:
      jj_consume_token(15);
            z=-7;
      break;
    case MILITARY_ZONE:
      t = jj_consume_token(MILITARY_ZONE);
                                                             z=getMilitaryZoneOffset(t.image.charAt(0));
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return z * 100;}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public DateTimeParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[7];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x2,0x0,0x0,0xf0000000,0x10,0x1ffe0,0x1ffc0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x7f00,0x7f00,0xff,0x0,0x0,0x0,};
   }

  /** Constructor with InputStream. */
  public DateTimeParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public DateTimeParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new DateTimeParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 7; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 7; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public DateTimeParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new DateTimeParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 7; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 7; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public DateTimeParser(DateTimeParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 7; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(DateTimeParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 7; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[49];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 7; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 49; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
