/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.mboxiterator;

import java.io.CharConversionException;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.james.mime4j.mboxiterator.CharBufferWrapper;

public class MboxIterator
implements Iterable<CharBufferWrapper>,
Closeable {
    private final CharBuffer mboxCharBuffer;
    private Matcher fromLineMatcher;
    private boolean fromLineFound;
    private final ByteBuffer byteBuffer;
    private final CharsetDecoder DECODER;
    private boolean endOfInputFlag = false;
    private final int maxMessageSize;
    private final Pattern MESSAGE_START;
    private int findStart = -1;
    private int findEnd = -1;
    private final Path mbox;

    private MboxIterator(Path mbox, Charset charset, String regexpPattern, int regexpFlags, int MAX_MESSAGE_SIZE) throws FileNotFoundException, IOException, CharConversionException {
        this.maxMessageSize = MAX_MESSAGE_SIZE;
        this.MESSAGE_START = Pattern.compile(regexpPattern, regexpFlags);
        this.DECODER = charset.newDecoder();
        this.mboxCharBuffer = CharBuffer.allocate(MAX_MESSAGE_SIZE);
        this.mbox = mbox;
        try (FileChannel channel = FileChannel.open(mbox, StandardOpenOption.READ);){
            this.byteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        }
        this.initMboxIterator();
    }

    protected void initMboxIterator() throws IOException {
        this.decodeNextCharBuffer();
        this.fromLineMatcher = this.MESSAGE_START.matcher(this.mboxCharBuffer);
        this.fromLineFound = this.fromLineMatcher.find();
        if (this.fromLineFound) {
            this.saveFindPositions(this.fromLineMatcher);
        } else if (this.fromLineMatcher.hitEnd()) {
            String path = "";
            if (this.mbox != null) {
                path = this.mbox.toString();
            }
            throw new IllegalArgumentException("File " + path + " does not contain From_ lines that match the pattern '" + this.MESSAGE_START.pattern() + "'! Maybe not be a valid Mbox or wrong matcher.");
        }
    }

    private void decodeNextCharBuffer() throws CharConversionException {
        CoderResult coderResult = this.DECODER.decode(this.byteBuffer, this.mboxCharBuffer, this.endOfInputFlag);
        this.updateEndOfInputFlag();
        this.mboxCharBuffer.flip();
        if (coderResult.isError()) {
            if (coderResult.isMalformed()) {
                throw new CharConversionException("Malformed input!");
            }
            if (coderResult.isUnmappable()) {
                throw new CharConversionException("Unmappable character!");
            }
        }
    }

    private void updateEndOfInputFlag() {
        if (this.byteBuffer.remaining() <= this.maxMessageSize) {
            this.endOfInputFlag = true;
        }
    }

    private void saveFindPositions(Matcher lineMatcher) {
        this.findStart = lineMatcher.start();
        this.findEnd = lineMatcher.end();
    }

    @Override
    public Iterator<CharBufferWrapper> iterator() {
        return new MessageIterator();
    }

    @Override
    public void close() throws IOException {
    }

    public static Builder fromFile(Path filePath) {
        return new Builder(filePath);
    }

    public static Builder fromFile(File filePath) {
        return MboxIterator.fromFile(filePath.toPath());
    }

    public static Builder fromFile(String file) {
        return MboxIterator.fromFile(new File(file));
    }

    public static String bufferDetailsToString(Buffer buffer) {
        StringBuilder sb = new StringBuilder("Buffer details: ");
        sb.append("\ncapacity:\t").append(buffer.capacity()).append("\nlimit:\t").append(buffer.limit()).append("\nremaining:\t").append(buffer.remaining()).append("\nposition:\t").append(buffer.position()).append("\nbuffer:\t").append(buffer.isReadOnly()).append("\nclass:\t").append(buffer.getClass());
        return sb.toString();
    }

    public static class Builder {
        private final Path path;
        private Charset charset = Charset.forName("UTF-8");
        private String regexpPattern = "^From \\S+@\\S.*\\d{4}$";
        private int flags = 8;
        private int maxMessageSize = 0xA00000;

        private Builder(Path path) {
            this.path = path;
        }

        public Builder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder fromLine(String fromLine) {
            this.regexpPattern = fromLine;
            return this;
        }

        public Builder flags(int flags) {
            this.flags = flags;
            return this;
        }

        public Builder maxMessageSize(int maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
            return this;
        }

        public MboxIterator build() throws FileNotFoundException, IOException {
            return new MboxIterator(this.path, this.charset, this.regexpPattern, this.flags, this.maxMessageSize);
        }
    }

    private class MessageIterator
    implements Iterator<CharBufferWrapper> {
        private MessageIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!MboxIterator.this.fromLineFound) {
                try {
                    MboxIterator.this.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Exception closing file!");
                }
            }
            return MboxIterator.this.fromLineFound;
        }

        @Override
        public CharBufferWrapper next() {
            CharBuffer message;
            MboxIterator.this.fromLineFound = MboxIterator.this.fromLineMatcher.find();
            if (MboxIterator.this.fromLineFound) {
                message = MboxIterator.this.mboxCharBuffer.slice();
                message.position(MboxIterator.this.findEnd + 1);
                MboxIterator.this.saveFindPositions(MboxIterator.this.fromLineMatcher);
                message.limit(MboxIterator.this.fromLineMatcher.start());
            } else if (MboxIterator.this.byteBuffer.hasRemaining()) {
                CharBuffer oldData = MboxIterator.this.mboxCharBuffer.duplicate();
                MboxIterator.this.mboxCharBuffer.clear();
                oldData.position(MboxIterator.this.findStart);
                while (oldData.hasRemaining()) {
                    MboxIterator.this.mboxCharBuffer.put(oldData.get());
                }
                try {
                    MboxIterator.this.decodeNextCharBuffer();
                }
                catch (CharConversionException ex) {
                    throw new RuntimeException(ex);
                }
                MboxIterator.this.fromLineMatcher = MboxIterator.this.MESSAGE_START.matcher(MboxIterator.this.mboxCharBuffer);
                MboxIterator.this.fromLineFound = MboxIterator.this.fromLineMatcher.find();
                if (MboxIterator.this.fromLineFound) {
                    MboxIterator.this.saveFindPositions(MboxIterator.this.fromLineMatcher);
                }
                message = MboxIterator.this.mboxCharBuffer.slice();
                message.position(MboxIterator.this.fromLineMatcher.end() + 1);
                MboxIterator.this.fromLineFound = MboxIterator.this.fromLineMatcher.find();
                if (MboxIterator.this.fromLineFound) {
                    MboxIterator.this.saveFindPositions(MboxIterator.this.fromLineMatcher);
                    message.limit(MboxIterator.this.fromLineMatcher.start());
                }
            } else {
                message = MboxIterator.this.mboxCharBuffer.slice();
                message.position(MboxIterator.this.findEnd + 1);
                message.limit(message.capacity());
            }
            return new CharBufferWrapper(message);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

