/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.james.core.Domain;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;

public interface RecipientRewriteTable {
    public static final EnumSet<Mapping.Type> listSourcesSupportedType = EnumSet.of(Mapping.Type.Group, Mapping.Type.Forward, Mapping.Type.Address, Mapping.Type.Alias, Mapping.Type.Domain);

    public void addMapping(MappingSource var1, Mapping var2) throws RecipientRewriteTableException;

    public void removeMapping(MappingSource var1, Mapping var2) throws RecipientRewriteTableException;

    public void addRegexMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeRegexMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void addAddressMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeAddressMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void addErrorMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeErrorMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void addAliasDomainMapping(MappingSource var1, Domain var2) throws RecipientRewriteTableException;

    public void removeAliasDomainMapping(MappingSource var1, Domain var2) throws RecipientRewriteTableException;

    public void addForwardMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeForwardMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void addGroupMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeGroupMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void addAliasMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeAliasMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public Mappings getResolvedMappings(String var1, Domain var2) throws ErrorMappingException, RecipientRewriteTableException;

    public Mappings getStoredMappings(MappingSource var1) throws RecipientRewriteTableException;

    public Map<MappingSource, Mappings> getAllMappings() throws RecipientRewriteTableException;

    default public Stream<MappingSource> listSources(Mapping mapping) throws RecipientRewriteTableException {
        Preconditions.checkArgument((boolean)listSourcesSupportedType.contains((Object)mapping.getType()), (Object)String.format("Not supported mapping of type %s", new Object[]{mapping.getType()}));
        return this.getAllMappings().entrySet().stream().filter(entry -> ((Mappings)entry.getValue()).contains(mapping)).map(Map.Entry::getKey);
    }

    default public Stream<MappingSource> getSourcesForType(Mapping.Type type) throws RecipientRewriteTableException {
        return this.getAllMappings().entrySet().stream().filter(e -> ((Mappings)e.getValue()).contains(type)).map(Map.Entry::getKey).sorted(Comparator.comparing(MappingSource::asMailAddressString));
    }

    default public Stream<Mapping> getMappingsForType(Mapping.Type type) throws RecipientRewriteTableException {
        return ImmutableSet.copyOf((Iterable)this.getAllMappings().values().stream().map(mappings -> mappings.select(type)).reduce(Mappings::union).orElse(MappingsImpl.empty())).stream();
    }

    public static class TooManyMappingException
    extends ErrorMappingException {
        public TooManyMappingException(String string) {
            super(string);
        }
    }

    public static class ErrorMappingException
    extends Exception {
        public ErrorMappingException(String string) {
            super(string);
        }
    }
}

